/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>GetBatchPrediction</code> operation.
 * </p>
 * <p>
 * The content consists of the detailed metadata, the status, and the data file information of a
 * <code>Batch Prediction</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchPrediction implements SdkPojo, Serializable, ToCopyableBuilder<BatchPrediction.Builder, BatchPrediction> {
    private static final SdkField<String> BATCH_PREDICTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BatchPredictionId").getter(getter(BatchPrediction::batchPredictionId))
            .setter(setter(Builder::batchPredictionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchPredictionId").build()).build();

    private static final SdkField<String> ML_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MLModelId").getter(getter(BatchPrediction::mlModelId)).setter(setter(Builder::mlModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MLModelId").build()).build();

    private static final SdkField<String> BATCH_PREDICTION_DATA_SOURCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("BatchPredictionDataSourceId")
            .getter(getter(BatchPrediction::batchPredictionDataSourceId))
            .setter(setter(Builder::batchPredictionDataSourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchPredictionDataSourceId")
                    .build()).build();

    private static final SdkField<String> INPUT_DATA_LOCATION_S3_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputDataLocationS3").getter(getter(BatchPrediction::inputDataLocationS3))
            .setter(setter(Builder::inputDataLocationS3))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataLocationS3").build())
            .build();

    private static final SdkField<String> CREATED_BY_IAM_USER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedByIamUser").getter(getter(BatchPrediction::createdByIamUser))
            .setter(setter(Builder::createdByIamUser))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedByIamUser").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(BatchPrediction::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedAt").getter(getter(BatchPrediction::lastUpdatedAt)).setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(BatchPrediction::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(BatchPrediction::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> OUTPUT_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputUri").getter(getter(BatchPrediction::outputUri)).setter(setter(Builder::outputUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputUri").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(BatchPrediction::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<Long> COMPUTE_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ComputeTime").getter(getter(BatchPrediction::computeTime)).setter(setter(Builder::computeTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeTime").build()).build();

    private static final SdkField<Instant> FINISHED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("FinishedAt").getter(getter(BatchPrediction::finishedAt)).setter(setter(Builder::finishedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinishedAt").build()).build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartedAt").getter(getter(BatchPrediction::startedAt)).setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedAt").build()).build();

    private static final SdkField<Long> TOTAL_RECORD_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TotalRecordCount").getter(getter(BatchPrediction::totalRecordCount))
            .setter(setter(Builder::totalRecordCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalRecordCount").build()).build();

    private static final SdkField<Long> INVALID_RECORD_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("InvalidRecordCount").getter(getter(BatchPrediction::invalidRecordCount))
            .setter(setter(Builder::invalidRecordCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvalidRecordCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BATCH_PREDICTION_ID_FIELD,
            ML_MODEL_ID_FIELD, BATCH_PREDICTION_DATA_SOURCE_ID_FIELD, INPUT_DATA_LOCATION_S3_FIELD, CREATED_BY_IAM_USER_FIELD,
            CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, NAME_FIELD, STATUS_FIELD, OUTPUT_URI_FIELD, MESSAGE_FIELD,
            COMPUTE_TIME_FIELD, FINISHED_AT_FIELD, STARTED_AT_FIELD, TOTAL_RECORD_COUNT_FIELD, INVALID_RECORD_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String batchPredictionId;

    private final String mlModelId;

    private final String batchPredictionDataSourceId;

    private final String inputDataLocationS3;

    private final String createdByIamUser;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final String name;

    private final String status;

    private final String outputUri;

    private final String message;

    private final Long computeTime;

    private final Instant finishedAt;

    private final Instant startedAt;

    private final Long totalRecordCount;

    private final Long invalidRecordCount;

    private BatchPrediction(BuilderImpl builder) {
        this.batchPredictionId = builder.batchPredictionId;
        this.mlModelId = builder.mlModelId;
        this.batchPredictionDataSourceId = builder.batchPredictionDataSourceId;
        this.inputDataLocationS3 = builder.inputDataLocationS3;
        this.createdByIamUser = builder.createdByIamUser;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.name = builder.name;
        this.status = builder.status;
        this.outputUri = builder.outputUri;
        this.message = builder.message;
        this.computeTime = builder.computeTime;
        this.finishedAt = builder.finishedAt;
        this.startedAt = builder.startedAt;
        this.totalRecordCount = builder.totalRecordCount;
        this.invalidRecordCount = builder.invalidRecordCount;
    }

    /**
     * <p>
     * The ID assigned to the <code>BatchPrediction</code> at creation. This value should be identical to the value of
     * the <code>BatchPredictionID</code> in the request.
     * </p>
     * 
     * @return The ID assigned to the <code>BatchPrediction</code> at creation. This value should be identical to the
     *         value of the <code>BatchPredictionID</code> in the request.
     */
    public final String batchPredictionId() {
        return batchPredictionId;
    }

    /**
     * <p>
     * The ID of the <code>MLModel</code> that generated predictions for the <code>BatchPrediction</code> request.
     * </p>
     * 
     * @return The ID of the <code>MLModel</code> that generated predictions for the <code>BatchPrediction</code>
     *         request.
     */
    public final String mlModelId() {
        return mlModelId;
    }

    /**
     * <p>
     * The ID of the <code>DataSource</code> that points to the group of observations to predict.
     * </p>
     * 
     * @return The ID of the <code>DataSource</code> that points to the group of observations to predict.
     */
    public final String batchPredictionDataSourceId() {
        return batchPredictionDataSourceId;
    }

    /**
     * <p>
     * The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
     * </p>
     * 
     * @return The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
     */
    public final String inputDataLocationS3() {
        return inputDataLocationS3;
    }

    /**
     * <p>
     * The AWS user account that invoked the <code>BatchPrediction</code>. The account type can be either an AWS root
     * account or an AWS Identity and Access Management (IAM) user account.
     * </p>
     * 
     * @return The AWS user account that invoked the <code>BatchPrediction</code>. The account type can be either an AWS
     *         root account or an AWS Identity and Access Management (IAM) user account.
     */
    public final String createdByIamUser() {
        return createdByIamUser;
    }

    /**
     * <p>
     * The time that the <code>BatchPrediction</code> was created. The time is expressed in epoch time.
     * </p>
     * 
     * @return The time that the <code>BatchPrediction</code> was created. The time is expressed in epoch time.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The time of the most recent edit to the <code>BatchPrediction</code>. The time is expressed in epoch time.
     * </p>
     * 
     * @return The time of the most recent edit to the <code>BatchPrediction</code>. The time is expressed in epoch
     *         time.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * A user-supplied name or description of the <code>BatchPrediction</code>.
     * </p>
     * 
     * @return A user-supplied name or description of the <code>BatchPrediction</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The status of the <code>BatchPrediction</code>. This element can have one of the following values:
     * </p>
     * <ul>
     * <li> <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to generate predictions for a
     * batch of observations.</li>
     * <li> <code>INPROGRESS</code> - The process is underway.</li>
     * <li> <code>FAILED</code> - The request to perform a batch prediction did not run to completion. It is not usable.</li>
     * <li> <code>COMPLETED</code> - The batch prediction process completed successfully.</li>
     * <li> <code>DELETED</code> - The <code>BatchPrediction</code> is marked as deleted. It is not usable.</li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EntityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the <code>BatchPrediction</code>. This element can have one of the following values:</p>
     *         <ul>
     *         <li> <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to generate
     *         predictions for a batch of observations.</li>
     *         <li> <code>INPROGRESS</code> - The process is underway.</li>
     *         <li> <code>FAILED</code> - The request to perform a batch prediction did not run to completion. It is not
     *         usable.</li>
     *         <li> <code>COMPLETED</code> - The batch prediction process completed successfully.</li>
     *         <li> <code>DELETED</code> - The <code>BatchPrediction</code> is marked as deleted. It is not usable.</li>
     * @see EntityStatus
     */
    public final EntityStatus status() {
        return EntityStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the <code>BatchPrediction</code>. This element can have one of the following values:
     * </p>
     * <ul>
     * <li> <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to generate predictions for a
     * batch of observations.</li>
     * <li> <code>INPROGRESS</code> - The process is underway.</li>
     * <li> <code>FAILED</code> - The request to perform a batch prediction did not run to completion. It is not usable.</li>
     * <li> <code>COMPLETED</code> - The batch prediction process completed successfully.</li>
     * <li> <code>DELETED</code> - The <code>BatchPrediction</code> is marked as deleted. It is not usable.</li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EntityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the <code>BatchPrediction</code>. This element can have one of the following values:</p>
     *         <ul>
     *         <li> <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to generate
     *         predictions for a batch of observations.</li>
     *         <li> <code>INPROGRESS</code> - The process is underway.</li>
     *         <li> <code>FAILED</code> - The request to perform a batch prediction did not run to completion. It is not
     *         usable.</li>
     *         <li> <code>COMPLETED</code> - The batch prediction process completed successfully.</li>
     *         <li> <code>DELETED</code> - The <code>BatchPrediction</code> is marked as deleted. It is not usable.</li>
     * @see EntityStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The location of an Amazon S3 bucket or directory to receive the operation results. The following substrings are
     * not allowed in the <code>s3 key</code> portion of the <code>outputURI</code> field: ':', '//', '/./', '/../'.
     * </p>
     * 
     * @return The location of an Amazon S3 bucket or directory to receive the operation results. The following
     *         substrings are not allowed in the <code>s3 key</code> portion of the <code>outputURI</code> field: ':',
     *         '//', '/./', '/../'.
     */
    public final String outputUri() {
        return outputUri;
    }

    /**
     * <p>
     * A description of the most recent details about processing the batch prediction request.
     * </p>
     * 
     * @return A description of the most recent details about processing the batch prediction request.
     */
    public final String message() {
        return message;
    }

    /**
     * Returns the value of the ComputeTime property for this object.
     * 
     * @return The value of the ComputeTime property for this object.
     */
    public final Long computeTime() {
        return computeTime;
    }

    /**
     * Returns the value of the FinishedAt property for this object.
     * 
     * @return The value of the FinishedAt property for this object.
     */
    public final Instant finishedAt() {
        return finishedAt;
    }

    /**
     * Returns the value of the StartedAt property for this object.
     * 
     * @return The value of the StartedAt property for this object.
     */
    public final Instant startedAt() {
        return startedAt;
    }

    /**
     * Returns the value of the TotalRecordCount property for this object.
     * 
     * @return The value of the TotalRecordCount property for this object.
     */
    public final Long totalRecordCount() {
        return totalRecordCount;
    }

    /**
     * Returns the value of the InvalidRecordCount property for this object.
     * 
     * @return The value of the InvalidRecordCount property for this object.
     */
    public final Long invalidRecordCount() {
        return invalidRecordCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(batchPredictionId());
        hashCode = 31 * hashCode + Objects.hashCode(mlModelId());
        hashCode = 31 * hashCode + Objects.hashCode(batchPredictionDataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(inputDataLocationS3());
        hashCode = 31 * hashCode + Objects.hashCode(createdByIamUser());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(outputUri());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(computeTime());
        hashCode = 31 * hashCode + Objects.hashCode(finishedAt());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(totalRecordCount());
        hashCode = 31 * hashCode + Objects.hashCode(invalidRecordCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPrediction)) {
            return false;
        }
        BatchPrediction other = (BatchPrediction) obj;
        return Objects.equals(batchPredictionId(), other.batchPredictionId()) && Objects.equals(mlModelId(), other.mlModelId())
                && Objects.equals(batchPredictionDataSourceId(), other.batchPredictionDataSourceId())
                && Objects.equals(inputDataLocationS3(), other.inputDataLocationS3())
                && Objects.equals(createdByIamUser(), other.createdByIamUser()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(outputUri(), other.outputUri())
                && Objects.equals(message(), other.message()) && Objects.equals(computeTime(), other.computeTime())
                && Objects.equals(finishedAt(), other.finishedAt()) && Objects.equals(startedAt(), other.startedAt())
                && Objects.equals(totalRecordCount(), other.totalRecordCount())
                && Objects.equals(invalidRecordCount(), other.invalidRecordCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchPrediction").add("BatchPredictionId", batchPredictionId()).add("MLModelId", mlModelId())
                .add("BatchPredictionDataSourceId", batchPredictionDataSourceId())
                .add("InputDataLocationS3", inputDataLocationS3()).add("CreatedByIamUser", createdByIamUser())
                .add("CreatedAt", createdAt()).add("LastUpdatedAt", lastUpdatedAt()).add("Name", name())
                .add("Status", statusAsString()).add("OutputUri", outputUri()).add("Message", message())
                .add("ComputeTime", computeTime()).add("FinishedAt", finishedAt()).add("StartedAt", startedAt())
                .add("TotalRecordCount", totalRecordCount()).add("InvalidRecordCount", invalidRecordCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BatchPredictionId":
            return Optional.ofNullable(clazz.cast(batchPredictionId()));
        case "MLModelId":
            return Optional.ofNullable(clazz.cast(mlModelId()));
        case "BatchPredictionDataSourceId":
            return Optional.ofNullable(clazz.cast(batchPredictionDataSourceId()));
        case "InputDataLocationS3":
            return Optional.ofNullable(clazz.cast(inputDataLocationS3()));
        case "CreatedByIamUser":
            return Optional.ofNullable(clazz.cast(createdByIamUser()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "LastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "OutputUri":
            return Optional.ofNullable(clazz.cast(outputUri()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "ComputeTime":
            return Optional.ofNullable(clazz.cast(computeTime()));
        case "FinishedAt":
            return Optional.ofNullable(clazz.cast(finishedAt()));
        case "StartedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "TotalRecordCount":
            return Optional.ofNullable(clazz.cast(totalRecordCount()));
        case "InvalidRecordCount":
            return Optional.ofNullable(clazz.cast(invalidRecordCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchPrediction, T> g) {
        return obj -> g.apply((BatchPrediction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchPrediction> {
        /**
         * <p>
         * The ID assigned to the <code>BatchPrediction</code> at creation. This value should be identical to the value
         * of the <code>BatchPredictionID</code> in the request.
         * </p>
         * 
         * @param batchPredictionId
         *        The ID assigned to the <code>BatchPrediction</code> at creation. This value should be identical to the
         *        value of the <code>BatchPredictionID</code> in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchPredictionId(String batchPredictionId);

        /**
         * <p>
         * The ID of the <code>MLModel</code> that generated predictions for the <code>BatchPrediction</code> request.
         * </p>
         * 
         * @param mlModelId
         *        The ID of the <code>MLModel</code> that generated predictions for the <code>BatchPrediction</code>
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlModelId(String mlModelId);

        /**
         * <p>
         * The ID of the <code>DataSource</code> that points to the group of observations to predict.
         * </p>
         * 
         * @param batchPredictionDataSourceId
         *        The ID of the <code>DataSource</code> that points to the group of observations to predict.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchPredictionDataSourceId(String batchPredictionDataSourceId);

        /**
         * <p>
         * The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
         * </p>
         * 
         * @param inputDataLocationS3
         *        The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDataLocationS3(String inputDataLocationS3);

        /**
         * <p>
         * The AWS user account that invoked the <code>BatchPrediction</code>. The account type can be either an AWS
         * root account or an AWS Identity and Access Management (IAM) user account.
         * </p>
         * 
         * @param createdByIamUser
         *        The AWS user account that invoked the <code>BatchPrediction</code>. The account type can be either an
         *        AWS root account or an AWS Identity and Access Management (IAM) user account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdByIamUser(String createdByIamUser);

        /**
         * <p>
         * The time that the <code>BatchPrediction</code> was created. The time is expressed in epoch time.
         * </p>
         * 
         * @param createdAt
         *        The time that the <code>BatchPrediction</code> was created. The time is expressed in epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The time of the most recent edit to the <code>BatchPrediction</code>. The time is expressed in epoch time.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The time of the most recent edit to the <code>BatchPrediction</code>. The time is expressed in epoch
         *        time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * A user-supplied name or description of the <code>BatchPrediction</code>.
         * </p>
         * 
         * @param name
         *        A user-supplied name or description of the <code>BatchPrediction</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of the <code>BatchPrediction</code>. This element can have one of the following values:
         * </p>
         * <ul>
         * <li> <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to generate predictions
         * for a batch of observations.</li>
         * <li> <code>INPROGRESS</code> - The process is underway.</li>
         * <li> <code>FAILED</code> - The request to perform a batch prediction did not run to completion. It is not
         * usable.</li>
         * <li> <code>COMPLETED</code> - The batch prediction process completed successfully.</li>
         * <li> <code>DELETED</code> - The <code>BatchPrediction</code> is marked as deleted. It is not usable.</li>
         * </ul>
         * 
         * @param status
         *        The status of the <code>BatchPrediction</code>. This element can have one of the following values:</p>
         *        <ul>
         *        <li> <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to generate
         *        predictions for a batch of observations.</li>
         *        <li> <code>INPROGRESS</code> - The process is underway.</li>
         *        <li> <code>FAILED</code> - The request to perform a batch prediction did not run to completion. It is
         *        not usable.</li>
         *        <li> <code>COMPLETED</code> - The batch prediction process completed successfully.</li>
         *        <li> <code>DELETED</code> - The <code>BatchPrediction</code> is marked as deleted. It is not usable.</li>
         * @see EntityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the <code>BatchPrediction</code>. This element can have one of the following values:
         * </p>
         * <ul>
         * <li> <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to generate predictions
         * for a batch of observations.</li>
         * <li> <code>INPROGRESS</code> - The process is underway.</li>
         * <li> <code>FAILED</code> - The request to perform a batch prediction did not run to completion. It is not
         * usable.</li>
         * <li> <code>COMPLETED</code> - The batch prediction process completed successfully.</li>
         * <li> <code>DELETED</code> - The <code>BatchPrediction</code> is marked as deleted. It is not usable.</li>
         * </ul>
         * 
         * @param status
         *        The status of the <code>BatchPrediction</code>. This element can have one of the following values:</p>
         *        <ul>
         *        <li> <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to generate
         *        predictions for a batch of observations.</li>
         *        <li> <code>INPROGRESS</code> - The process is underway.</li>
         *        <li> <code>FAILED</code> - The request to perform a batch prediction did not run to completion. It is
         *        not usable.</li>
         *        <li> <code>COMPLETED</code> - The batch prediction process completed successfully.</li>
         *        <li> <code>DELETED</code> - The <code>BatchPrediction</code> is marked as deleted. It is not usable.</li>
         * @see EntityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityStatus
         */
        Builder status(EntityStatus status);

        /**
         * <p>
         * The location of an Amazon S3 bucket or directory to receive the operation results. The following substrings
         * are not allowed in the <code>s3 key</code> portion of the <code>outputURI</code> field: ':', '//', '/./',
         * '/../'.
         * </p>
         * 
         * @param outputUri
         *        The location of an Amazon S3 bucket or directory to receive the operation results. The following
         *        substrings are not allowed in the <code>s3 key</code> portion of the <code>outputURI</code> field:
         *        ':', '//', '/./', '/../'.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputUri(String outputUri);

        /**
         * <p>
         * A description of the most recent details about processing the batch prediction request.
         * </p>
         * 
         * @param message
         *        A description of the most recent details about processing the batch prediction request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * Sets the value of the ComputeTime property for this object.
         *
         * @param computeTime
         *        The new value for the ComputeTime property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeTime(Long computeTime);

        /**
         * Sets the value of the FinishedAt property for this object.
         *
         * @param finishedAt
         *        The new value for the FinishedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finishedAt(Instant finishedAt);

        /**
         * Sets the value of the StartedAt property for this object.
         *
         * @param startedAt
         *        The new value for the StartedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * Sets the value of the TotalRecordCount property for this object.
         *
         * @param totalRecordCount
         *        The new value for the TotalRecordCount property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalRecordCount(Long totalRecordCount);

        /**
         * Sets the value of the InvalidRecordCount property for this object.
         *
         * @param invalidRecordCount
         *        The new value for the InvalidRecordCount property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidRecordCount(Long invalidRecordCount);
    }

    static final class BuilderImpl implements Builder {
        private String batchPredictionId;

        private String mlModelId;

        private String batchPredictionDataSourceId;

        private String inputDataLocationS3;

        private String createdByIamUser;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private String name;

        private String status;

        private String outputUri;

        private String message;

        private Long computeTime;

        private Instant finishedAt;

        private Instant startedAt;

        private Long totalRecordCount;

        private Long invalidRecordCount;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPrediction model) {
            batchPredictionId(model.batchPredictionId);
            mlModelId(model.mlModelId);
            batchPredictionDataSourceId(model.batchPredictionDataSourceId);
            inputDataLocationS3(model.inputDataLocationS3);
            createdByIamUser(model.createdByIamUser);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
            name(model.name);
            status(model.status);
            outputUri(model.outputUri);
            message(model.message);
            computeTime(model.computeTime);
            finishedAt(model.finishedAt);
            startedAt(model.startedAt);
            totalRecordCount(model.totalRecordCount);
            invalidRecordCount(model.invalidRecordCount);
        }

        public final String getBatchPredictionId() {
            return batchPredictionId;
        }

        @Override
        public final Builder batchPredictionId(String batchPredictionId) {
            this.batchPredictionId = batchPredictionId;
            return this;
        }

        public final void setBatchPredictionId(String batchPredictionId) {
            this.batchPredictionId = batchPredictionId;
        }

        public final String getMlModelId() {
            return mlModelId;
        }

        @Override
        public final Builder mlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
            return this;
        }

        public final void setMlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
        }

        public final String getBatchPredictionDataSourceId() {
            return batchPredictionDataSourceId;
        }

        @Override
        public final Builder batchPredictionDataSourceId(String batchPredictionDataSourceId) {
            this.batchPredictionDataSourceId = batchPredictionDataSourceId;
            return this;
        }

        public final void setBatchPredictionDataSourceId(String batchPredictionDataSourceId) {
            this.batchPredictionDataSourceId = batchPredictionDataSourceId;
        }

        public final String getInputDataLocationS3() {
            return inputDataLocationS3;
        }

        @Override
        public final Builder inputDataLocationS3(String inputDataLocationS3) {
            this.inputDataLocationS3 = inputDataLocationS3;
            return this;
        }

        public final void setInputDataLocationS3(String inputDataLocationS3) {
            this.inputDataLocationS3 = inputDataLocationS3;
        }

        public final String getCreatedByIamUser() {
            return createdByIamUser;
        }

        @Override
        public final Builder createdByIamUser(String createdByIamUser) {
            this.createdByIamUser = createdByIamUser;
            return this;
        }

        public final void setCreatedByIamUser(String createdByIamUser) {
            this.createdByIamUser = createdByIamUser;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EntityStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getOutputUri() {
            return outputUri;
        }

        @Override
        public final Builder outputUri(String outputUri) {
            this.outputUri = outputUri;
            return this;
        }

        public final void setOutputUri(String outputUri) {
            this.outputUri = outputUri;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Long getComputeTime() {
            return computeTime;
        }

        @Override
        public final Builder computeTime(Long computeTime) {
            this.computeTime = computeTime;
            return this;
        }

        public final void setComputeTime(Long computeTime) {
            this.computeTime = computeTime;
        }

        public final Instant getFinishedAt() {
            return finishedAt;
        }

        @Override
        public final Builder finishedAt(Instant finishedAt) {
            this.finishedAt = finishedAt;
            return this;
        }

        public final void setFinishedAt(Instant finishedAt) {
            this.finishedAt = finishedAt;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        public final Long getTotalRecordCount() {
            return totalRecordCount;
        }

        @Override
        public final Builder totalRecordCount(Long totalRecordCount) {
            this.totalRecordCount = totalRecordCount;
            return this;
        }

        public final void setTotalRecordCount(Long totalRecordCount) {
            this.totalRecordCount = totalRecordCount;
        }

        public final Long getInvalidRecordCount() {
            return invalidRecordCount;
        }

        @Override
        public final Builder invalidRecordCount(Long invalidRecordCount) {
            this.invalidRecordCount = invalidRecordCount;
            return this;
        }

        public final void setInvalidRecordCount(Long invalidRecordCount) {
            this.invalidRecordCount = invalidRecordCount;
        }

        @Override
        public BatchPrediction build() {
            return new BatchPrediction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
