/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.machinelearning.MachineLearningAsyncClient;
import software.amazon.awssdk.services.machinelearning.model.BatchPrediction;
import software.amazon.awssdk.services.machinelearning.model.DescribeBatchPredictionsRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeBatchPredictionsResponse;

public class DescribeBatchPredictionsPublisher
implements SdkPublisher<DescribeBatchPredictionsResponse> {
    private final MachineLearningAsyncClient client;
    private final DescribeBatchPredictionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeBatchPredictionsPublisher(MachineLearningAsyncClient client, DescribeBatchPredictionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeBatchPredictionsPublisher(MachineLearningAsyncClient client, DescribeBatchPredictionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeBatchPredictionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeBatchPredictionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<BatchPrediction> results() {
        Function<DescribeBatchPredictionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.results() != null) {
                return response.results().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeBatchPredictionsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeBatchPredictionsPublisher resume(DescribeBatchPredictionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeBatchPredictionsPublisher(this.client, (DescribeBatchPredictionsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeBatchPredictionsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeBatchPredictionsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeBatchPredictionsResponseFetcher
    implements AsyncPageFetcher<DescribeBatchPredictionsResponse> {
        private DescribeBatchPredictionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeBatchPredictionsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<DescribeBatchPredictionsResponse> nextPage(DescribeBatchPredictionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeBatchPredictionsPublisher.this.client.describeBatchPredictions(DescribeBatchPredictionsPublisher.this.firstRequest);
            }
            return DescribeBatchPredictionsPublisher.this.client.describeBatchPredictions((DescribeBatchPredictionsRequest)((Object)DescribeBatchPredictionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

