/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.machinelearning.model.EntityStatus;
import software.amazon.awssdk.services.machinelearning.model.MachineLearningResponse;
import software.amazon.awssdk.services.machinelearning.model.RDSMetadata;
import software.amazon.awssdk.services.machinelearning.model.RedshiftMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetDataSourceResponse
extends MachineLearningResponse
implements ToCopyableBuilder<Builder, GetDataSourceResponse> {
    private final String dataSourceId;
    private final String dataLocationS3;
    private final String dataRearrangement;
    private final String createdByIamUser;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;
    private final Long dataSizeInBytes;
    private final Long numberOfFiles;
    private final String name;
    private final String status;
    private final String logUri;
    private final String message;
    private final RedshiftMetadata redshiftMetadata;
    private final RDSMetadata rdsMetadata;
    private final String roleARN;
    private final Boolean computeStatistics;
    private final Long computeTime;
    private final Instant finishedAt;
    private final Instant startedAt;
    private final String dataSourceSchema;

    private GetDataSourceResponse(BuilderImpl builder) {
        super(builder);
        this.dataSourceId = builder.dataSourceId;
        this.dataLocationS3 = builder.dataLocationS3;
        this.dataRearrangement = builder.dataRearrangement;
        this.createdByIamUser = builder.createdByIamUser;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.dataSizeInBytes = builder.dataSizeInBytes;
        this.numberOfFiles = builder.numberOfFiles;
        this.name = builder.name;
        this.status = builder.status;
        this.logUri = builder.logUri;
        this.message = builder.message;
        this.redshiftMetadata = builder.redshiftMetadata;
        this.rdsMetadata = builder.rdsMetadata;
        this.roleARN = builder.roleARN;
        this.computeStatistics = builder.computeStatistics;
        this.computeTime = builder.computeTime;
        this.finishedAt = builder.finishedAt;
        this.startedAt = builder.startedAt;
        this.dataSourceSchema = builder.dataSourceSchema;
    }

    public String dataSourceId() {
        return this.dataSourceId;
    }

    public String dataLocationS3() {
        return this.dataLocationS3;
    }

    public String dataRearrangement() {
        return this.dataRearrangement;
    }

    public String createdByIamUser() {
        return this.createdByIamUser;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public Long dataSizeInBytes() {
        return this.dataSizeInBytes;
    }

    public Long numberOfFiles() {
        return this.numberOfFiles;
    }

    public String name() {
        return this.name;
    }

    public EntityStatus status() {
        return EntityStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public String logUri() {
        return this.logUri;
    }

    public String message() {
        return this.message;
    }

    public RedshiftMetadata redshiftMetadata() {
        return this.redshiftMetadata;
    }

    public RDSMetadata rdsMetadata() {
        return this.rdsMetadata;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public Boolean computeStatistics() {
        return this.computeStatistics;
    }

    public Long computeTime() {
        return this.computeTime;
    }

    public Instant finishedAt() {
        return this.finishedAt;
    }

    public Instant startedAt() {
        return this.startedAt;
    }

    public String dataSourceSchema() {
        return this.dataSourceSchema;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataLocationS3());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataRearrangement());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdByIamUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfFiles());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.logUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.redshiftMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.rdsMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.finishedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceSchema());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataSourceResponse)) {
            return false;
        }
        GetDataSourceResponse other = (GetDataSourceResponse)((Object)obj);
        return Objects.equals(this.dataSourceId(), other.dataSourceId()) && Objects.equals(this.dataLocationS3(), other.dataLocationS3()) && Objects.equals(this.dataRearrangement(), other.dataRearrangement()) && Objects.equals(this.createdByIamUser(), other.createdByIamUser()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.dataSizeInBytes(), other.dataSizeInBytes()) && Objects.equals(this.numberOfFiles(), other.numberOfFiles()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.logUri(), other.logUri()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.redshiftMetadata(), other.redshiftMetadata()) && Objects.equals(this.rdsMetadata(), other.rdsMetadata()) && Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.computeStatistics(), other.computeStatistics()) && Objects.equals(this.computeTime(), other.computeTime()) && Objects.equals(this.finishedAt(), other.finishedAt()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.dataSourceSchema(), other.dataSourceSchema());
    }

    public String toString() {
        return ToString.builder((String)"GetDataSourceResponse").add("DataSourceId", (Object)this.dataSourceId()).add("DataLocationS3", (Object)this.dataLocationS3()).add("DataRearrangement", (Object)this.dataRearrangement()).add("CreatedByIamUser", (Object)this.createdByIamUser()).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("DataSizeInBytes", (Object)this.dataSizeInBytes()).add("NumberOfFiles", (Object)this.numberOfFiles()).add("Name", (Object)this.name()).add("Status", (Object)this.statusString()).add("LogUri", (Object)this.logUri()).add("Message", (Object)this.message()).add("RedshiftMetadata", (Object)this.redshiftMetadata()).add("RDSMetadata", (Object)this.rdsMetadata()).add("RoleARN", (Object)this.roleARN()).add("ComputeStatistics", (Object)this.computeStatistics()).add("ComputeTime", (Object)this.computeTime()).add("FinishedAt", (Object)this.finishedAt()).add("StartedAt", (Object)this.startedAt()).add("DataSourceSchema", (Object)this.dataSourceSchema()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSourceId": {
                return Optional.of(clazz.cast(this.dataSourceId()));
            }
            case "DataLocationS3": {
                return Optional.of(clazz.cast(this.dataLocationS3()));
            }
            case "DataRearrangement": {
                return Optional.of(clazz.cast(this.dataRearrangement()));
            }
            case "CreatedByIamUser": {
                return Optional.of(clazz.cast(this.createdByIamUser()));
            }
            case "CreatedAt": {
                return Optional.of(clazz.cast(this.createdAt()));
            }
            case "LastUpdatedAt": {
                return Optional.of(clazz.cast(this.lastUpdatedAt()));
            }
            case "DataSizeInBytes": {
                return Optional.of(clazz.cast(this.dataSizeInBytes()));
            }
            case "NumberOfFiles": {
                return Optional.of(clazz.cast(this.numberOfFiles()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "LogUri": {
                return Optional.of(clazz.cast(this.logUri()));
            }
            case "Message": {
                return Optional.of(clazz.cast(this.message()));
            }
            case "RedshiftMetadata": {
                return Optional.of(clazz.cast(this.redshiftMetadata()));
            }
            case "RDSMetadata": {
                return Optional.of(clazz.cast(this.rdsMetadata()));
            }
            case "RoleARN": {
                return Optional.of(clazz.cast(this.roleARN()));
            }
            case "ComputeStatistics": {
                return Optional.of(clazz.cast(this.computeStatistics()));
            }
            case "ComputeTime": {
                return Optional.of(clazz.cast(this.computeTime()));
            }
            case "FinishedAt": {
                return Optional.of(clazz.cast(this.finishedAt()));
            }
            case "StartedAt": {
                return Optional.of(clazz.cast(this.startedAt()));
            }
            case "DataSourceSchema": {
                return Optional.of(clazz.cast(this.dataSourceSchema()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MachineLearningResponse.BuilderImpl
    implements Builder {
        private String dataSourceId;
        private String dataLocationS3;
        private String dataRearrangement;
        private String createdByIamUser;
        private Instant createdAt;
        private Instant lastUpdatedAt;
        private Long dataSizeInBytes;
        private Long numberOfFiles;
        private String name;
        private String status;
        private String logUri;
        private String message;
        private RedshiftMetadata redshiftMetadata;
        private RDSMetadata rdsMetadata;
        private String roleARN;
        private Boolean computeStatistics;
        private Long computeTime;
        private Instant finishedAt;
        private Instant startedAt;
        private String dataSourceSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataSourceResponse model) {
            this.dataSourceId(model.dataSourceId);
            this.dataLocationS3(model.dataLocationS3);
            this.dataRearrangement(model.dataRearrangement);
            this.createdByIamUser(model.createdByIamUser);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.dataSizeInBytes(model.dataSizeInBytes);
            this.numberOfFiles(model.numberOfFiles);
            this.name(model.name);
            this.status(model.status);
            this.logUri(model.logUri);
            this.message(model.message);
            this.redshiftMetadata(model.redshiftMetadata);
            this.rdsMetadata(model.rdsMetadata);
            this.roleARN(model.roleARN);
            this.computeStatistics(model.computeStatistics);
            this.computeTime(model.computeTime);
            this.finishedAt(model.finishedAt);
            this.startedAt(model.startedAt);
            this.dataSourceSchema(model.dataSourceSchema);
        }

        public final String getDataSourceId() {
            return this.dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        public final String getDataLocationS3() {
            return this.dataLocationS3;
        }

        @Override
        public final Builder dataLocationS3(String dataLocationS3) {
            this.dataLocationS3 = dataLocationS3;
            return this;
        }

        public final void setDataLocationS3(String dataLocationS3) {
            this.dataLocationS3 = dataLocationS3;
        }

        public final String getDataRearrangement() {
            return this.dataRearrangement;
        }

        @Override
        public final Builder dataRearrangement(String dataRearrangement) {
            this.dataRearrangement = dataRearrangement;
            return this;
        }

        public final void setDataRearrangement(String dataRearrangement) {
            this.dataRearrangement = dataRearrangement;
        }

        public final String getCreatedByIamUser() {
            return this.createdByIamUser;
        }

        @Override
        public final Builder createdByIamUser(String createdByIamUser) {
            this.createdByIamUser = createdByIamUser;
            return this;
        }

        public final void setCreatedByIamUser(String createdByIamUser) {
            this.createdByIamUser = createdByIamUser;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public final Long getDataSizeInBytes() {
            return this.dataSizeInBytes;
        }

        @Override
        public final Builder dataSizeInBytes(Long dataSizeInBytes) {
            this.dataSizeInBytes = dataSizeInBytes;
            return this;
        }

        public final void setDataSizeInBytes(Long dataSizeInBytes) {
            this.dataSizeInBytes = dataSizeInBytes;
        }

        public final Long getNumberOfFiles() {
            return this.numberOfFiles;
        }

        @Override
        public final Builder numberOfFiles(Long numberOfFiles) {
            this.numberOfFiles = numberOfFiles;
            return this;
        }

        public final void setNumberOfFiles(Long numberOfFiles) {
            this.numberOfFiles = numberOfFiles;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EntityStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getLogUri() {
            return this.logUri;
        }

        @Override
        public final Builder logUri(String logUri) {
            this.logUri = logUri;
            return this;
        }

        public final void setLogUri(String logUri) {
            this.logUri = logUri;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final RedshiftMetadata.Builder getRedshiftMetadata() {
            return this.redshiftMetadata != null ? this.redshiftMetadata.toBuilder() : null;
        }

        @Override
        public final Builder redshiftMetadata(RedshiftMetadata redshiftMetadata) {
            this.redshiftMetadata = redshiftMetadata;
            return this;
        }

        public final void setRedshiftMetadata(RedshiftMetadata.BuilderImpl redshiftMetadata) {
            this.redshiftMetadata = redshiftMetadata != null ? redshiftMetadata.build() : null;
        }

        public final RDSMetadata.Builder getRDSMetadata() {
            return this.rdsMetadata != null ? this.rdsMetadata.toBuilder() : null;
        }

        @Override
        public final Builder rdsMetadata(RDSMetadata rdsMetadata) {
            this.rdsMetadata = rdsMetadata;
            return this;
        }

        public final void setRDSMetadata(RDSMetadata.BuilderImpl rdsMetadata) {
            this.rdsMetadata = rdsMetadata != null ? rdsMetadata.build() : null;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final Boolean getComputeStatistics() {
            return this.computeStatistics;
        }

        @Override
        public final Builder computeStatistics(Boolean computeStatistics) {
            this.computeStatistics = computeStatistics;
            return this;
        }

        public final void setComputeStatistics(Boolean computeStatistics) {
            this.computeStatistics = computeStatistics;
        }

        public final Long getComputeTime() {
            return this.computeTime;
        }

        @Override
        public final Builder computeTime(Long computeTime) {
            this.computeTime = computeTime;
            return this;
        }

        public final void setComputeTime(Long computeTime) {
            this.computeTime = computeTime;
        }

        public final Instant getFinishedAt() {
            return this.finishedAt;
        }

        @Override
        public final Builder finishedAt(Instant finishedAt) {
            this.finishedAt = finishedAt;
            return this;
        }

        public final void setFinishedAt(Instant finishedAt) {
            this.finishedAt = finishedAt;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        public final String getDataSourceSchema() {
            return this.dataSourceSchema;
        }

        @Override
        public final Builder dataSourceSchema(String dataSourceSchema) {
            this.dataSourceSchema = dataSourceSchema;
            return this;
        }

        public final void setDataSourceSchema(String dataSourceSchema) {
            this.dataSourceSchema = dataSourceSchema;
        }

        @Override
        public GetDataSourceResponse build() {
            return new GetDataSourceResponse(this);
        }
    }

    public static interface Builder
    extends MachineLearningResponse.Builder,
    CopyableBuilder<Builder, GetDataSourceResponse> {
        public Builder dataSourceId(String var1);

        public Builder dataLocationS3(String var1);

        public Builder dataRearrangement(String var1);

        public Builder createdByIamUser(String var1);

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder dataSizeInBytes(Long var1);

        public Builder numberOfFiles(Long var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(EntityStatus var1);

        public Builder logUri(String var1);

        public Builder message(String var1);

        public Builder redshiftMetadata(RedshiftMetadata var1);

        default public Builder redshiftMetadata(Consumer<RedshiftMetadata.Builder> redshiftMetadata) {
            return this.redshiftMetadata((RedshiftMetadata)((RedshiftMetadata.Builder)RedshiftMetadata.builder().apply(redshiftMetadata)).build());
        }

        public Builder rdsMetadata(RDSMetadata var1);

        default public Builder rdsMetadata(Consumer<RDSMetadata.Builder> rdsMetadata) {
            return this.rdsMetadata((RDSMetadata)((RDSMetadata.Builder)RDSMetadata.builder().apply(rdsMetadata)).build());
        }

        public Builder roleARN(String var1);

        public Builder computeStatistics(Boolean var1);

        public Builder computeTime(Long var1);

        public Builder finishedAt(Instant var1);

        public Builder startedAt(Instant var1);

        public Builder dataSourceSchema(String var1);
    }
}

