/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.machinelearning.model.RedshiftDatabase;
import software.amazon.awssdk.services.machinelearning.transform.RedshiftMetadataMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RedshiftMetadata
implements StructuredPojo,
ToCopyableBuilder<Builder, RedshiftMetadata> {
    private final RedshiftDatabase redshiftDatabase;
    private final String databaseUserName;
    private final String selectSqlQuery;

    private RedshiftMetadata(BuilderImpl builder) {
        this.redshiftDatabase = builder.redshiftDatabase;
        this.databaseUserName = builder.databaseUserName;
        this.selectSqlQuery = builder.selectSqlQuery;
    }

    public RedshiftDatabase redshiftDatabase() {
        return this.redshiftDatabase;
    }

    public String databaseUserName() {
        return this.databaseUserName;
    }

    public String selectSqlQuery() {
        return this.selectSqlQuery;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.redshiftDatabase());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseUserName());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectSqlQuery());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftMetadata)) {
            return false;
        }
        RedshiftMetadata other = (RedshiftMetadata)obj;
        return Objects.equals(this.redshiftDatabase(), other.redshiftDatabase()) && Objects.equals(this.databaseUserName(), other.databaseUserName()) && Objects.equals(this.selectSqlQuery(), other.selectSqlQuery());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.redshiftDatabase() != null) {
            sb.append("RedshiftDatabase: ").append(this.redshiftDatabase()).append(",");
        }
        if (this.databaseUserName() != null) {
            sb.append("DatabaseUserName: ").append(this.databaseUserName()).append(",");
        }
        if (this.selectSqlQuery() != null) {
            sb.append("SelectSqlQuery: ").append(this.selectSqlQuery()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RedshiftDatabase": {
                return Optional.of(clazz.cast(this.redshiftDatabase()));
            }
            case "DatabaseUserName": {
                return Optional.of(clazz.cast(this.databaseUserName()));
            }
            case "SelectSqlQuery": {
                return Optional.of(clazz.cast(this.selectSqlQuery()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RedshiftMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private RedshiftDatabase redshiftDatabase;
        private String databaseUserName;
        private String selectSqlQuery;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftMetadata model) {
            this.redshiftDatabase(model.redshiftDatabase);
            this.databaseUserName(model.databaseUserName);
            this.selectSqlQuery(model.selectSqlQuery);
        }

        public final RedshiftDatabase.Builder getRedshiftDatabase() {
            return this.redshiftDatabase != null ? this.redshiftDatabase.toBuilder() : null;
        }

        @Override
        public final Builder redshiftDatabase(RedshiftDatabase redshiftDatabase) {
            this.redshiftDatabase = redshiftDatabase;
            return this;
        }

        public final void setRedshiftDatabase(RedshiftDatabase.BuilderImpl redshiftDatabase) {
            this.redshiftDatabase = redshiftDatabase != null ? redshiftDatabase.build() : null;
        }

        public final String getDatabaseUserName() {
            return this.databaseUserName;
        }

        @Override
        public final Builder databaseUserName(String databaseUserName) {
            this.databaseUserName = databaseUserName;
            return this;
        }

        public final void setDatabaseUserName(String databaseUserName) {
            this.databaseUserName = databaseUserName;
        }

        public final String getSelectSqlQuery() {
            return this.selectSqlQuery;
        }

        @Override
        public final Builder selectSqlQuery(String selectSqlQuery) {
            this.selectSqlQuery = selectSqlQuery;
            return this;
        }

        public final void setSelectSqlQuery(String selectSqlQuery) {
            this.selectSqlQuery = selectSqlQuery;
        }

        public RedshiftMetadata build() {
            return new RedshiftMetadata(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RedshiftMetadata> {
        public Builder redshiftDatabase(RedshiftDatabase var1);

        default public Builder redshiftDatabase(Consumer<RedshiftDatabase.Builder> redshiftDatabase) {
            return this.redshiftDatabase((RedshiftDatabase)((RedshiftDatabase.Builder)RedshiftDatabase.builder().apply(redshiftDatabase)).build());
        }

        public Builder databaseUserName(String var1);

        public Builder selectSqlQuery(String var1);
    }
}

