/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.machinelearning.model.MachineLearningRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteDataSourceRequest
extends MachineLearningRequest
implements ToCopyableBuilder<Builder, DeleteDataSourceRequest> {
    private final String dataSourceId;

    private DeleteDataSourceRequest(BuilderImpl builder) {
        super(builder);
        this.dataSourceId = builder.dataSourceId;
    }

    public String dataSourceId() {
        return this.dataSourceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDataSourceRequest)) {
            return false;
        }
        DeleteDataSourceRequest other = (DeleteDataSourceRequest)((Object)obj);
        return Objects.equals(this.dataSourceId(), other.dataSourceId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.dataSourceId() != null) {
            sb.append("DataSourceId: ").append(this.dataSourceId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSourceId": {
                return Optional.of(clazz.cast(this.dataSourceId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MachineLearningRequest.BuilderImpl
    implements Builder {
        private String dataSourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDataSourceRequest model) {
            this.dataSourceId(model.dataSourceId);
        }

        public final String getDataSourceId() {
            return this.dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteDataSourceRequest build() {
            return new DeleteDataSourceRequest(this);
        }
    }

    public static interface Builder
    extends MachineLearningRequest.Builder,
    CopyableBuilder<Builder, DeleteDataSourceRequest> {
        public Builder dataSourceId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

