/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.machinelearning.model.RDSMetadata;

@SdkInternalApi
public class RDSMetadataMarshaller {
    private static final MarshallingInfo<StructuredPojo> DATABASE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Database").build();
    private static final MarshallingInfo<String> DATABASEUSERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseUserName").build();
    private static final MarshallingInfo<String> SELECTSQLQUERY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SelectSqlQuery").build();
    private static final MarshallingInfo<String> RESOURCEROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceRole").build();
    private static final MarshallingInfo<String> SERVICEROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceRole").build();
    private static final MarshallingInfo<String> DATAPIPELINEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataPipelineId").build();
    private static final RDSMetadataMarshaller INSTANCE = new RDSMetadataMarshaller();

    public static RDSMetadataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RDSMetadata rdsMetadata, ProtocolMarshaller protocolMarshaller) {
        if (rdsMetadata == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)rdsMetadata.database(), DATABASE_BINDING);
            protocolMarshaller.marshall((Object)rdsMetadata.databaseUserName(), DATABASEUSERNAME_BINDING);
            protocolMarshaller.marshall((Object)rdsMetadata.selectSqlQuery(), SELECTSQLQUERY_BINDING);
            protocolMarshaller.marshall((Object)rdsMetadata.resourceRole(), RESOURCEROLE_BINDING);
            protocolMarshaller.marshall((Object)rdsMetadata.serviceRole(), SERVICEROLE_BINDING);
            protocolMarshaller.marshall((Object)rdsMetadata.dataPipelineId(), DATAPIPELINEID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

