/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.machinelearning.model.MachineLearningRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetDataSourceRequest
extends MachineLearningRequest
implements ToCopyableBuilder<Builder, GetDataSourceRequest> {
    private final String dataSourceId;
    private final Boolean verbose;

    private GetDataSourceRequest(BuilderImpl builder) {
        super(builder);
        this.dataSourceId = builder.dataSourceId;
        this.verbose = builder.verbose;
    }

    public String dataSourceId() {
        return this.dataSourceId;
    }

    public Boolean verbose() {
        return this.verbose;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.verbose());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataSourceRequest)) {
            return false;
        }
        GetDataSourceRequest other = (GetDataSourceRequest)((Object)obj);
        return Objects.equals(this.dataSourceId(), other.dataSourceId()) && Objects.equals(this.verbose(), other.verbose());
    }

    public String toString() {
        return ToString.builder((String)"GetDataSourceRequest").add("DataSourceId", (Object)this.dataSourceId()).add("Verbose", (Object)this.verbose()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSourceId": {
                return Optional.of(clazz.cast(this.dataSourceId()));
            }
            case "Verbose": {
                return Optional.of(clazz.cast(this.verbose()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MachineLearningRequest.BuilderImpl
    implements Builder {
        private String dataSourceId;
        private Boolean verbose;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataSourceRequest model) {
            super(model);
            this.dataSourceId(model.dataSourceId);
            this.verbose(model.verbose);
        }

        public final String getDataSourceId() {
            return this.dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        public final Boolean getVerbose() {
            return this.verbose;
        }

        @Override
        public final Builder verbose(Boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public final void setVerbose(Boolean verbose) {
            this.verbose = verbose;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetDataSourceRequest build() {
            return new GetDataSourceRequest(this);
        }
    }

    public static interface Builder
    extends MachineLearningRequest.Builder,
    CopyableBuilder<Builder, GetDataSourceRequest> {
        public Builder dataSourceId(String var1);

        public Builder verbose(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

