/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.machinelearning.model.RedshiftDatabase;

@SdkInternalApi
public class RedshiftDatabaseMarshaller {
    private static final MarshallingInfo<String> DATABASENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseName").build();
    private static final MarshallingInfo<String> CLUSTERIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterIdentifier").build();
    private static final RedshiftDatabaseMarshaller instance = new RedshiftDatabaseMarshaller();

    public static RedshiftDatabaseMarshaller getInstance() {
        return instance;
    }

    public void marshall(RedshiftDatabase redshiftDatabase, ProtocolMarshaller protocolMarshaller) {
        if (redshiftDatabase == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)redshiftDatabase.databaseName(), DATABASENAME_BINDING);
            protocolMarshaller.marshall((Object)redshiftDatabase.clusterIdentifier(), CLUSTERIDENTIFIER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

