/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.m2.model.BatchJobDefinition;
import software.amazon.awssdk.services.m2.model.BatchJobDefinitionsCopier;
import software.amazon.awssdk.services.m2.model.M2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBatchJobDefinitionsResponse
extends M2Response
implements ToCopyableBuilder<Builder, ListBatchJobDefinitionsResponse> {
    private static final SdkField<List<BatchJobDefinition>> BATCH_JOB_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("batchJobDefinitions").getter(ListBatchJobDefinitionsResponse.getter(ListBatchJobDefinitionsResponse::batchJobDefinitions)).setter(ListBatchJobDefinitionsResponse.setter(Builder::batchJobDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchJobDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchJobDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListBatchJobDefinitionsResponse.getter(ListBatchJobDefinitionsResponse::nextToken)).setter(ListBatchJobDefinitionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BATCH_JOB_DEFINITIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("batchJobDefinitions", BATCH_JOB_DEFINITIONS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<BatchJobDefinition> batchJobDefinitions;
    private final String nextToken;

    private ListBatchJobDefinitionsResponse(BuilderImpl builder) {
        super(builder);
        this.batchJobDefinitions = builder.batchJobDefinitions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasBatchJobDefinitions() {
        return this.batchJobDefinitions != null && !(this.batchJobDefinitions instanceof SdkAutoConstructList);
    }

    public final List<BatchJobDefinition> batchJobDefinitions() {
        return this.batchJobDefinitions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBatchJobDefinitions() ? this.batchJobDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBatchJobDefinitionsResponse)) {
            return false;
        }
        ListBatchJobDefinitionsResponse other = (ListBatchJobDefinitionsResponse)((Object)obj);
        return this.hasBatchJobDefinitions() == other.hasBatchJobDefinitions() && Objects.equals(this.batchJobDefinitions(), other.batchJobDefinitions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListBatchJobDefinitionsResponse").add("BatchJobDefinitions", this.hasBatchJobDefinitions() ? this.batchJobDefinitions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "batchJobDefinitions": {
                return Optional.ofNullable(clazz.cast(this.batchJobDefinitions()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListBatchJobDefinitionsResponse, T> g) {
        return obj -> g.apply((ListBatchJobDefinitionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends M2Response.BuilderImpl
    implements Builder {
        private List<BatchJobDefinition> batchJobDefinitions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBatchJobDefinitionsResponse model) {
            super(model);
            this.batchJobDefinitions(model.batchJobDefinitions);
            this.nextToken(model.nextToken);
        }

        public final List<BatchJobDefinition.Builder> getBatchJobDefinitions() {
            List<BatchJobDefinition.Builder> result = BatchJobDefinitionsCopier.copyToBuilder(this.batchJobDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBatchJobDefinitions(Collection<BatchJobDefinition.BuilderImpl> batchJobDefinitions) {
            this.batchJobDefinitions = BatchJobDefinitionsCopier.copyFromBuilder(batchJobDefinitions);
        }

        @Override
        public final Builder batchJobDefinitions(Collection<BatchJobDefinition> batchJobDefinitions) {
            this.batchJobDefinitions = BatchJobDefinitionsCopier.copy(batchJobDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder batchJobDefinitions(BatchJobDefinition ... batchJobDefinitions) {
            this.batchJobDefinitions(Arrays.asList(batchJobDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder batchJobDefinitions(Consumer<BatchJobDefinition.Builder> ... batchJobDefinitions) {
            this.batchJobDefinitions(Stream.of(batchJobDefinitions).map(c -> (BatchJobDefinition)((BatchJobDefinition.Builder)BatchJobDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBatchJobDefinitionsResponse build() {
            return new ListBatchJobDefinitionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends M2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBatchJobDefinitionsResponse> {
        public Builder batchJobDefinitions(Collection<BatchJobDefinition> var1);

        public Builder batchJobDefinitions(BatchJobDefinition ... var1);

        public Builder batchJobDefinitions(Consumer<BatchJobDefinition.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

