/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExternalLocation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExternalLocation> {
    private static final SdkField<String> S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3Location").getter(ExternalLocation.getter(ExternalLocation::s3Location)).setter(ExternalLocation.setter(Builder::s3Location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Location").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExternalLocation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String s3Location;
    private final Type type;

    private ExternalLocation(BuilderImpl builder) {
        this.s3Location = builder.s3Location;
        this.type = builder.type;
    }

    public final String s3Location() {
        return this.s3Location;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Location());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExternalLocation)) {
            return false;
        }
        ExternalLocation other = (ExternalLocation)obj;
        return Objects.equals(this.s3Location(), other.s3Location());
    }

    public final String toString() {
        return ToString.builder((String)"ExternalLocation").add("S3Location", (Object)this.s3Location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "s3Location": {
                return Optional.ofNullable(clazz.cast(this.s3Location()));
            }
        }
        return Optional.empty();
    }

    public static ExternalLocation fromS3Location(String s3Location) {
        return (ExternalLocation)ExternalLocation.builder().s3Location(s3Location).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("s3Location", S3_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExternalLocation, T> g) {
        return obj -> g.apply((ExternalLocation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        S3_LOCATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String s3Location;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ExternalLocation model) {
            this.s3Location(model.s3Location);
        }

        public final String getS3Location() {
            return this.s3Location;
        }

        public final void setS3Location(String s3Location) {
            String oldValue = this.s3Location;
            this.s3Location = s3Location;
            this.handleUnionValueChange(Type.S3_LOCATION, oldValue, this.s3Location);
        }

        @Override
        public final Builder s3Location(String s3Location) {
            String oldValue = this.s3Location;
            this.s3Location = s3Location;
            this.handleUnionValueChange(Type.S3_LOCATION, oldValue, this.s3Location);
            return this;
        }

        public ExternalLocation build() {
            return new ExternalLocation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExternalLocation> {
        public Builder s3Location(String var1);
    }
}

