/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.m2.DefaultM2AsyncClient;
import software.amazon.awssdk.services.m2.DefaultM2BaseClientBuilder;
import software.amazon.awssdk.services.m2.M2AsyncClient;
import software.amazon.awssdk.services.m2.M2AsyncClientBuilder;
import software.amazon.awssdk.services.m2.M2ServiceClientConfiguration;
import software.amazon.awssdk.services.m2.endpoints.M2EndpointProvider;

@SdkInternalApi
final class DefaultM2AsyncClientBuilder
extends DefaultM2BaseClientBuilder<M2AsyncClientBuilder, M2AsyncClient>
implements M2AsyncClientBuilder {
    DefaultM2AsyncClientBuilder() {
    }

    @Override
    public DefaultM2AsyncClientBuilder endpointProvider(M2EndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final M2AsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultM2AsyncClientBuilder.validateClientOptions(clientConfiguration);
        M2ServiceClientConfiguration serviceClientConfiguration = M2ServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultM2AsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

