/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.m2.DefaultM2AsyncClient;
import software.amazon.awssdk.services.m2.DefaultM2BaseClientBuilder;
import software.amazon.awssdk.services.m2.M2AsyncClient;
import software.amazon.awssdk.services.m2.M2AsyncClientBuilder;
import software.amazon.awssdk.services.m2.M2ServiceClientConfiguration;
import software.amazon.awssdk.services.m2.endpoints.M2EndpointProvider;

@SdkInternalApi
final class DefaultM2AsyncClientBuilder
extends DefaultM2BaseClientBuilder<M2AsyncClientBuilder, M2AsyncClient>
implements M2AsyncClientBuilder {
    DefaultM2AsyncClientBuilder() {
    }

    @Override
    public DefaultM2AsyncClientBuilder endpointProvider(M2EndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final M2AsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultM2AsyncClientBuilder.validateClientOptions(clientConfiguration);
        M2ServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultM2AsyncClient client = new DefaultM2AsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private M2ServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return M2ServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

