/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.m2.model.BatchJobExecutionStatus;
import software.amazon.awssdk.services.m2.model.BatchJobType;
import software.amazon.awssdk.services.m2.model.M2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBatchJobExecutionResponse
extends M2Response
implements ToCopyableBuilder<Builder, GetBatchJobExecutionResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(GetBatchJobExecutionResponse.getter(GetBatchJobExecutionResponse::applicationId)).setter(GetBatchJobExecutionResponse.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(GetBatchJobExecutionResponse.getter(GetBatchJobExecutionResponse::endTime)).setter(GetBatchJobExecutionResponse.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionId").getter(GetBatchJobExecutionResponse.getter(GetBatchJobExecutionResponse::executionId)).setter(GetBatchJobExecutionResponse.setter(Builder::executionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionId").build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(GetBatchJobExecutionResponse.getter(GetBatchJobExecutionResponse::jobId)).setter(GetBatchJobExecutionResponse.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobName").getter(GetBatchJobExecutionResponse.getter(GetBatchJobExecutionResponse::jobName)).setter(GetBatchJobExecutionResponse.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()}).build();
    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobType").getter(GetBatchJobExecutionResponse.getter(GetBatchJobExecutionResponse::jobTypeAsString)).setter(GetBatchJobExecutionResponse.setter(Builder::jobType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobType").build()}).build();
    private static final SdkField<String> JOB_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobUser").getter(GetBatchJobExecutionResponse.getter(GetBatchJobExecutionResponse::jobUser)).setter(GetBatchJobExecutionResponse.setter(Builder::jobUser)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobUser").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(GetBatchJobExecutionResponse.getter(GetBatchJobExecutionResponse::startTime)).setter(GetBatchJobExecutionResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetBatchJobExecutionResponse.getter(GetBatchJobExecutionResponse::statusAsString)).setter(GetBatchJobExecutionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(GetBatchJobExecutionResponse.getter(GetBatchJobExecutionResponse::statusReason)).setter(GetBatchJobExecutionResponse.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, END_TIME_FIELD, EXECUTION_ID_FIELD, JOB_ID_FIELD, JOB_NAME_FIELD, JOB_TYPE_FIELD, JOB_USER_FIELD, START_TIME_FIELD, STATUS_FIELD, STATUS_REASON_FIELD));
    private final String applicationId;
    private final Instant endTime;
    private final String executionId;
    private final String jobId;
    private final String jobName;
    private final String jobType;
    private final String jobUser;
    private final Instant startTime;
    private final String status;
    private final String statusReason;

    private GetBatchJobExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.endTime = builder.endTime;
        this.executionId = builder.executionId;
        this.jobId = builder.jobId;
        this.jobName = builder.jobName;
        this.jobType = builder.jobType;
        this.jobUser = builder.jobUser;
        this.startTime = builder.startTime;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String executionId() {
        return this.executionId;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final BatchJobType jobType() {
        return BatchJobType.fromValue(this.jobType);
    }

    public final String jobTypeAsString() {
        return this.jobType;
    }

    public final String jobUser() {
        return this.jobUser;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final BatchJobExecutionStatus status() {
        return BatchJobExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBatchJobExecutionResponse)) {
            return false;
        }
        GetBatchJobExecutionResponse other = (GetBatchJobExecutionResponse)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.executionId(), other.executionId()) && Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.jobTypeAsString(), other.jobTypeAsString()) && Objects.equals(this.jobUser(), other.jobUser()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason());
    }

    public final String toString() {
        return ToString.builder((String)"GetBatchJobExecutionResponse").add("ApplicationId", (Object)this.applicationId()).add("EndTime", (Object)this.endTime()).add("ExecutionId", (Object)this.executionId()).add("JobId", (Object)this.jobId()).add("JobName", (Object)this.jobName()).add("JobType", (Object)this.jobTypeAsString()).add("JobUser", (Object)this.jobUser()).add("StartTime", (Object)this.startTime()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "executionId": {
                return Optional.ofNullable(clazz.cast(this.executionId()));
            }
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "jobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "jobType": {
                return Optional.ofNullable(clazz.cast(this.jobTypeAsString()));
            }
            case "jobUser": {
                return Optional.ofNullable(clazz.cast(this.jobUser()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBatchJobExecutionResponse, T> g) {
        return obj -> g.apply((GetBatchJobExecutionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends M2Response.BuilderImpl
    implements Builder {
        private String applicationId;
        private Instant endTime;
        private String executionId;
        private String jobId;
        private String jobName;
        private String jobType;
        private String jobUser;
        private Instant startTime;
        private String status;
        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBatchJobExecutionResponse model) {
            super(model);
            this.applicationId(model.applicationId);
            this.endTime(model.endTime);
            this.executionId(model.executionId);
            this.jobId(model.jobId);
            this.jobName(model.jobName);
            this.jobType(model.jobType);
            this.jobUser(model.jobUser);
            this.startTime(model.startTime);
            this.status(model.status);
            this.statusReason(model.statusReason);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getExecutionId() {
            return this.executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobType() {
            return this.jobType;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(BatchJobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final String getJobUser() {
            return this.jobUser;
        }

        public final void setJobUser(String jobUser) {
            this.jobUser = jobUser;
        }

        @Override
        public final Builder jobUser(String jobUser) {
            this.jobUser = jobUser;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BatchJobExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        public GetBatchJobExecutionResponse build() {
            return new GetBatchJobExecutionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends M2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBatchJobExecutionResponse> {
        public Builder applicationId(String var1);

        public Builder endTime(Instant var1);

        public Builder executionId(String var1);

        public Builder jobId(String var1);

        public Builder jobName(String var1);

        public Builder jobType(String var1);

        public Builder jobType(BatchJobType var1);

        public Builder jobUser(String var1);

        public Builder startTime(Instant var1);

        public Builder status(String var1);

        public Builder status(BatchJobExecutionStatus var1);

        public Builder statusReason(String var1);
    }
}

