/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FileBatchJobDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FileBatchJobDefinition> {
    private static final SdkField<String> FILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fileName").getter(FileBatchJobDefinition.getter(FileBatchJobDefinition::fileName)).setter(FileBatchJobDefinition.setter(Builder::fileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileName").build()}).build();
    private static final SdkField<String> FOLDER_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("folderPath").getter(FileBatchJobDefinition.getter(FileBatchJobDefinition::folderPath)).setter(FileBatchJobDefinition.setter(Builder::folderPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("folderPath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_NAME_FIELD, FOLDER_PATH_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fileName;
    private final String folderPath;

    private FileBatchJobDefinition(BuilderImpl builder) {
        this.fileName = builder.fileName;
        this.folderPath = builder.folderPath;
    }

    public final String fileName() {
        return this.fileName;
    }

    public final String folderPath() {
        return this.folderPath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.folderPath());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileBatchJobDefinition)) {
            return false;
        }
        FileBatchJobDefinition other = (FileBatchJobDefinition)obj;
        return Objects.equals(this.fileName(), other.fileName()) && Objects.equals(this.folderPath(), other.folderPath());
    }

    public final String toString() {
        return ToString.builder((String)"FileBatchJobDefinition").add("FileName", (Object)this.fileName()).add("FolderPath", (Object)this.folderPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fileName": {
                return Optional.ofNullable(clazz.cast(this.fileName()));
            }
            case "folderPath": {
                return Optional.ofNullable(clazz.cast(this.folderPath()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FileBatchJobDefinition, T> g) {
        return obj -> g.apply((FileBatchJobDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fileName;
        private String folderPath;

        private BuilderImpl() {
        }

        private BuilderImpl(FileBatchJobDefinition model) {
            this.fileName(model.fileName);
            this.folderPath(model.folderPath);
        }

        public final String getFileName() {
            return this.fileName;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public final Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public final String getFolderPath() {
            return this.folderPath;
        }

        public final void setFolderPath(String folderPath) {
            this.folderPath = folderPath;
        }

        @Override
        public final Builder folderPath(String folderPath) {
            this.folderPath = folderPath;
            return this;
        }

        public FileBatchJobDefinition build() {
            return new FileBatchJobDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FileBatchJobDefinition> {
        public Builder fileName(String var1);

        public Builder folderPath(String var1);
    }
}

