/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutvision.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lookoutvision.model.LookoutVisionResponse;
import software.amazon.awssdk.services.lookoutvision.model.ModelPackagingJobMetadata;
import software.amazon.awssdk.services.lookoutvision.model.ModelPackagingJobsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListModelPackagingJobsResponse
extends LookoutVisionResponse
implements ToCopyableBuilder<Builder, ListModelPackagingJobsResponse> {
    private static final SdkField<List<ModelPackagingJobMetadata>> MODEL_PACKAGING_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ModelPackagingJobs").getter(ListModelPackagingJobsResponse.getter(ListModelPackagingJobsResponse::modelPackagingJobs)).setter(ListModelPackagingJobsResponse.setter(Builder::modelPackagingJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackagingJobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModelPackagingJobMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListModelPackagingJobsResponse.getter(ListModelPackagingJobsResponse::nextToken)).setter(ListModelPackagingJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_PACKAGING_JOBS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListModelPackagingJobsResponse.memberNameToFieldInitializer();
    private final List<ModelPackagingJobMetadata> modelPackagingJobs;
    private final String nextToken;

    private ListModelPackagingJobsResponse(BuilderImpl builder) {
        super(builder);
        this.modelPackagingJobs = builder.modelPackagingJobs;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasModelPackagingJobs() {
        return this.modelPackagingJobs != null && !(this.modelPackagingJobs instanceof SdkAutoConstructList);
    }

    public final List<ModelPackagingJobMetadata> modelPackagingJobs() {
        return this.modelPackagingJobs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModelPackagingJobs() ? this.modelPackagingJobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListModelPackagingJobsResponse)) {
            return false;
        }
        ListModelPackagingJobsResponse other = (ListModelPackagingJobsResponse)((Object)obj);
        return this.hasModelPackagingJobs() == other.hasModelPackagingJobs() && Objects.equals(this.modelPackagingJobs(), other.modelPackagingJobs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListModelPackagingJobsResponse").add("ModelPackagingJobs", this.hasModelPackagingJobs() ? this.modelPackagingJobs() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelPackagingJobs": {
                return Optional.ofNullable(clazz.cast(this.modelPackagingJobs()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ModelPackagingJobs", MODEL_PACKAGING_JOBS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListModelPackagingJobsResponse, T> g) {
        return obj -> g.apply((ListModelPackagingJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutVisionResponse.BuilderImpl
    implements Builder {
        private List<ModelPackagingJobMetadata> modelPackagingJobs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListModelPackagingJobsResponse model) {
            super(model);
            this.modelPackagingJobs(model.modelPackagingJobs);
            this.nextToken(model.nextToken);
        }

        public final List<ModelPackagingJobMetadata.Builder> getModelPackagingJobs() {
            List<ModelPackagingJobMetadata.Builder> result = ModelPackagingJobsListCopier.copyToBuilder(this.modelPackagingJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelPackagingJobs(Collection<ModelPackagingJobMetadata.BuilderImpl> modelPackagingJobs) {
            this.modelPackagingJobs = ModelPackagingJobsListCopier.copyFromBuilder(modelPackagingJobs);
        }

        @Override
        public final Builder modelPackagingJobs(Collection<ModelPackagingJobMetadata> modelPackagingJobs) {
            this.modelPackagingJobs = ModelPackagingJobsListCopier.copy(modelPackagingJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelPackagingJobs(ModelPackagingJobMetadata ... modelPackagingJobs) {
            this.modelPackagingJobs(Arrays.asList(modelPackagingJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelPackagingJobs(Consumer<ModelPackagingJobMetadata.Builder> ... modelPackagingJobs) {
            this.modelPackagingJobs(Stream.of(modelPackagingJobs).map(c -> (ModelPackagingJobMetadata)((ModelPackagingJobMetadata.Builder)ModelPackagingJobMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListModelPackagingJobsResponse build() {
            return new ListModelPackagingJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LookoutVisionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListModelPackagingJobsResponse> {
        public Builder modelPackagingJobs(Collection<ModelPackagingJobMetadata> var1);

        public Builder modelPackagingJobs(ModelPackagingJobMetadata ... var1);

        public Builder modelPackagingJobs(Consumer<ModelPackagingJobMetadata.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

