/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutvision.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutvision.model.PixelAnomaly;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Anomaly
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Anomaly> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Anomaly.getter(Anomaly::name)).setter(Anomaly.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<PixelAnomaly> PIXEL_ANOMALY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PixelAnomaly").getter(Anomaly.getter(Anomaly::pixelAnomaly)).setter(Anomaly.setter(Builder::pixelAnomaly)).constructor(PixelAnomaly::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PixelAnomaly").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, PIXEL_ANOMALY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Anomaly.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final PixelAnomaly pixelAnomaly;

    private Anomaly(BuilderImpl builder) {
        this.name = builder.name;
        this.pixelAnomaly = builder.pixelAnomaly;
    }

    public final String name() {
        return this.name;
    }

    public final PixelAnomaly pixelAnomaly() {
        return this.pixelAnomaly;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.pixelAnomaly());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Anomaly)) {
            return false;
        }
        Anomaly other = (Anomaly)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.pixelAnomaly(), other.pixelAnomaly());
    }

    public final String toString() {
        return ToString.builder((String)"Anomaly").add("Name", (Object)this.name()).add("PixelAnomaly", (Object)this.pixelAnomaly()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "PixelAnomaly": {
                return Optional.ofNullable(clazz.cast(this.pixelAnomaly()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("PixelAnomaly", PIXEL_ANOMALY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Anomaly, T> g) {
        return obj -> g.apply((Anomaly)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private PixelAnomaly pixelAnomaly;

        private BuilderImpl() {
        }

        private BuilderImpl(Anomaly model) {
            this.name(model.name);
            this.pixelAnomaly(model.pixelAnomaly);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final PixelAnomaly.Builder getPixelAnomaly() {
            return this.pixelAnomaly != null ? this.pixelAnomaly.toBuilder() : null;
        }

        public final void setPixelAnomaly(PixelAnomaly.BuilderImpl pixelAnomaly) {
            this.pixelAnomaly = pixelAnomaly != null ? pixelAnomaly.build() : null;
        }

        @Override
        public final Builder pixelAnomaly(PixelAnomaly pixelAnomaly) {
            this.pixelAnomaly = pixelAnomaly;
            return this;
        }

        public Anomaly build() {
            return new Anomaly(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Anomaly> {
        public Builder name(String var1);

        public Builder pixelAnomaly(PixelAnomaly var1);

        default public Builder pixelAnomaly(Consumer<PixelAnomaly.Builder> pixelAnomaly) {
            return this.pixelAnomaly((PixelAnomaly)((PixelAnomaly.Builder)PixelAnomaly.builder().applyMutation(pixelAnomaly)).build());
        }
    }
}

