/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutvision.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutvision.model.ModelPackagingConfiguration;
import software.amazon.awssdk.services.lookoutvision.model.ModelPackagingJobStatus;
import software.amazon.awssdk.services.lookoutvision.model.ModelPackagingOutputDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelPackagingDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelPackagingDescription> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobName").getter(ModelPackagingDescription.getter(ModelPackagingDescription::jobName)).setter(ModelPackagingDescription.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()}).build();
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectName").getter(ModelPackagingDescription.getter(ModelPackagingDescription::projectName)).setter(ModelPackagingDescription.setter(Builder::projectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectName").build()}).build();
    private static final SdkField<String> MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelVersion").getter(ModelPackagingDescription.getter(ModelPackagingDescription::modelVersion)).setter(ModelPackagingDescription.setter(Builder::modelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersion").build()}).build();
    private static final SdkField<ModelPackagingConfiguration> MODEL_PACKAGING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelPackagingConfiguration").getter(ModelPackagingDescription.getter(ModelPackagingDescription::modelPackagingConfiguration)).setter(ModelPackagingDescription.setter(Builder::modelPackagingConfiguration)).constructor(ModelPackagingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackagingConfiguration").build()}).build();
    private static final SdkField<String> MODEL_PACKAGING_JOB_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelPackagingJobDescription").getter(ModelPackagingDescription.getter(ModelPackagingDescription::modelPackagingJobDescription)).setter(ModelPackagingDescription.setter(Builder::modelPackagingJobDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackagingJobDescription").build()}).build();
    private static final SdkField<String> MODEL_PACKAGING_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelPackagingMethod").getter(ModelPackagingDescription.getter(ModelPackagingDescription::modelPackagingMethod)).setter(ModelPackagingDescription.setter(Builder::modelPackagingMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackagingMethod").build()}).build();
    private static final SdkField<ModelPackagingOutputDetails> MODEL_PACKAGING_OUTPUT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelPackagingOutputDetails").getter(ModelPackagingDescription.getter(ModelPackagingDescription::modelPackagingOutputDetails)).setter(ModelPackagingDescription.setter(Builder::modelPackagingOutputDetails)).constructor(ModelPackagingOutputDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackagingOutputDetails").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ModelPackagingDescription.getter(ModelPackagingDescription::statusAsString)).setter(ModelPackagingDescription.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(ModelPackagingDescription.getter(ModelPackagingDescription::statusMessage)).setter(ModelPackagingDescription.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTimestamp").getter(ModelPackagingDescription.getter(ModelPackagingDescription::creationTimestamp)).setter(ModelPackagingDescription.setter(Builder::creationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTimestamp").getter(ModelPackagingDescription.getter(ModelPackagingDescription::lastUpdatedTimestamp)).setter(ModelPackagingDescription.setter(Builder::lastUpdatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD, PROJECT_NAME_FIELD, MODEL_VERSION_FIELD, MODEL_PACKAGING_CONFIGURATION_FIELD, MODEL_PACKAGING_JOB_DESCRIPTION_FIELD, MODEL_PACKAGING_METHOD_FIELD, MODEL_PACKAGING_OUTPUT_DETAILS_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, CREATION_TIMESTAMP_FIELD, LAST_UPDATED_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModelPackagingDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String jobName;
    private final String projectName;
    private final String modelVersion;
    private final ModelPackagingConfiguration modelPackagingConfiguration;
    private final String modelPackagingJobDescription;
    private final String modelPackagingMethod;
    private final ModelPackagingOutputDetails modelPackagingOutputDetails;
    private final String status;
    private final String statusMessage;
    private final Instant creationTimestamp;
    private final Instant lastUpdatedTimestamp;

    private ModelPackagingDescription(BuilderImpl builder) {
        this.jobName = builder.jobName;
        this.projectName = builder.projectName;
        this.modelVersion = builder.modelVersion;
        this.modelPackagingConfiguration = builder.modelPackagingConfiguration;
        this.modelPackagingJobDescription = builder.modelPackagingJobDescription;
        this.modelPackagingMethod = builder.modelPackagingMethod;
        this.modelPackagingOutputDetails = builder.modelPackagingOutputDetails;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.creationTimestamp = builder.creationTimestamp;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final String projectName() {
        return this.projectName;
    }

    public final String modelVersion() {
        return this.modelVersion;
    }

    public final ModelPackagingConfiguration modelPackagingConfiguration() {
        return this.modelPackagingConfiguration;
    }

    public final String modelPackagingJobDescription() {
        return this.modelPackagingJobDescription;
    }

    public final String modelPackagingMethod() {
        return this.modelPackagingMethod;
    }

    public final ModelPackagingOutputDetails modelPackagingOutputDetails() {
        return this.modelPackagingOutputDetails;
    }

    public final ModelPackagingJobStatus status() {
        return ModelPackagingJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final Instant creationTimestamp() {
        return this.creationTimestamp;
    }

    public final Instant lastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackagingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackagingJobDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackagingMethod());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackagingOutputDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelPackagingDescription)) {
            return false;
        }
        ModelPackagingDescription other = (ModelPackagingDescription)obj;
        return Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.projectName(), other.projectName()) && Objects.equals(this.modelVersion(), other.modelVersion()) && Objects.equals(this.modelPackagingConfiguration(), other.modelPackagingConfiguration()) && Objects.equals(this.modelPackagingJobDescription(), other.modelPackagingJobDescription()) && Objects.equals(this.modelPackagingMethod(), other.modelPackagingMethod()) && Objects.equals(this.modelPackagingOutputDetails(), other.modelPackagingOutputDetails()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.creationTimestamp(), other.creationTimestamp()) && Objects.equals(this.lastUpdatedTimestamp(), other.lastUpdatedTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"ModelPackagingDescription").add("JobName", (Object)this.jobName()).add("ProjectName", (Object)this.projectName()).add("ModelVersion", (Object)this.modelVersion()).add("ModelPackagingConfiguration", (Object)this.modelPackagingConfiguration()).add("ModelPackagingJobDescription", (Object)this.modelPackagingJobDescription()).add("ModelPackagingMethod", (Object)this.modelPackagingMethod()).add("ModelPackagingOutputDetails", (Object)this.modelPackagingOutputDetails()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("CreationTimestamp", (Object)this.creationTimestamp()).add("LastUpdatedTimestamp", (Object)this.lastUpdatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "ProjectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "ModelVersion": {
                return Optional.ofNullable(clazz.cast(this.modelVersion()));
            }
            case "ModelPackagingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.modelPackagingConfiguration()));
            }
            case "ModelPackagingJobDescription": {
                return Optional.ofNullable(clazz.cast(this.modelPackagingJobDescription()));
            }
            case "ModelPackagingMethod": {
                return Optional.ofNullable(clazz.cast(this.modelPackagingMethod()));
            }
            case "ModelPackagingOutputDetails": {
                return Optional.ofNullable(clazz.cast(this.modelPackagingOutputDetails()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "CreationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.creationTimestamp()));
            }
            case "LastUpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("JobName", JOB_NAME_FIELD);
        map.put("ProjectName", PROJECT_NAME_FIELD);
        map.put("ModelVersion", MODEL_VERSION_FIELD);
        map.put("ModelPackagingConfiguration", MODEL_PACKAGING_CONFIGURATION_FIELD);
        map.put("ModelPackagingJobDescription", MODEL_PACKAGING_JOB_DESCRIPTION_FIELD);
        map.put("ModelPackagingMethod", MODEL_PACKAGING_METHOD_FIELD);
        map.put("ModelPackagingOutputDetails", MODEL_PACKAGING_OUTPUT_DETAILS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("CreationTimestamp", CREATION_TIMESTAMP_FIELD);
        map.put("LastUpdatedTimestamp", LAST_UPDATED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModelPackagingDescription, T> g) {
        return obj -> g.apply((ModelPackagingDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobName;
        private String projectName;
        private String modelVersion;
        private ModelPackagingConfiguration modelPackagingConfiguration;
        private String modelPackagingJobDescription;
        private String modelPackagingMethod;
        private ModelPackagingOutputDetails modelPackagingOutputDetails;
        private String status;
        private String statusMessage;
        private Instant creationTimestamp;
        private Instant lastUpdatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelPackagingDescription model) {
            this.jobName(model.jobName);
            this.projectName(model.projectName);
            this.modelVersion(model.modelVersion);
            this.modelPackagingConfiguration(model.modelPackagingConfiguration);
            this.modelPackagingJobDescription(model.modelPackagingJobDescription);
            this.modelPackagingMethod(model.modelPackagingMethod);
            this.modelPackagingOutputDetails(model.modelPackagingOutputDetails);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.creationTimestamp(model.creationTimestamp);
            this.lastUpdatedTimestamp(model.lastUpdatedTimestamp);
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getProjectName() {
            return this.projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getModelVersion() {
            return this.modelVersion;
        }

        public final void setModelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
        }

        @Override
        public final Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public final ModelPackagingConfiguration.Builder getModelPackagingConfiguration() {
            return this.modelPackagingConfiguration != null ? this.modelPackagingConfiguration.toBuilder() : null;
        }

        public final void setModelPackagingConfiguration(ModelPackagingConfiguration.BuilderImpl modelPackagingConfiguration) {
            this.modelPackagingConfiguration = modelPackagingConfiguration != null ? modelPackagingConfiguration.build() : null;
        }

        @Override
        public final Builder modelPackagingConfiguration(ModelPackagingConfiguration modelPackagingConfiguration) {
            this.modelPackagingConfiguration = modelPackagingConfiguration;
            return this;
        }

        public final String getModelPackagingJobDescription() {
            return this.modelPackagingJobDescription;
        }

        public final void setModelPackagingJobDescription(String modelPackagingJobDescription) {
            this.modelPackagingJobDescription = modelPackagingJobDescription;
        }

        @Override
        public final Builder modelPackagingJobDescription(String modelPackagingJobDescription) {
            this.modelPackagingJobDescription = modelPackagingJobDescription;
            return this;
        }

        public final String getModelPackagingMethod() {
            return this.modelPackagingMethod;
        }

        public final void setModelPackagingMethod(String modelPackagingMethod) {
            this.modelPackagingMethod = modelPackagingMethod;
        }

        @Override
        public final Builder modelPackagingMethod(String modelPackagingMethod) {
            this.modelPackagingMethod = modelPackagingMethod;
            return this;
        }

        public final ModelPackagingOutputDetails.Builder getModelPackagingOutputDetails() {
            return this.modelPackagingOutputDetails != null ? this.modelPackagingOutputDetails.toBuilder() : null;
        }

        public final void setModelPackagingOutputDetails(ModelPackagingOutputDetails.BuilderImpl modelPackagingOutputDetails) {
            this.modelPackagingOutputDetails = modelPackagingOutputDetails != null ? modelPackagingOutputDetails.build() : null;
        }

        @Override
        public final Builder modelPackagingOutputDetails(ModelPackagingOutputDetails modelPackagingOutputDetails) {
            this.modelPackagingOutputDetails = modelPackagingOutputDetails;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ModelPackagingJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Instant getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final Instant getLastUpdatedTimestamp() {
            return this.lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public ModelPackagingDescription build() {
            return new ModelPackagingDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelPackagingDescription> {
        public Builder jobName(String var1);

        public Builder projectName(String var1);

        public Builder modelVersion(String var1);

        public Builder modelPackagingConfiguration(ModelPackagingConfiguration var1);

        default public Builder modelPackagingConfiguration(Consumer<ModelPackagingConfiguration.Builder> modelPackagingConfiguration) {
            return this.modelPackagingConfiguration((ModelPackagingConfiguration)((ModelPackagingConfiguration.Builder)ModelPackagingConfiguration.builder().applyMutation(modelPackagingConfiguration)).build());
        }

        public Builder modelPackagingJobDescription(String var1);

        public Builder modelPackagingMethod(String var1);

        public Builder modelPackagingOutputDetails(ModelPackagingOutputDetails var1);

        default public Builder modelPackagingOutputDetails(Consumer<ModelPackagingOutputDetails.Builder> modelPackagingOutputDetails) {
            return this.modelPackagingOutputDetails((ModelPackagingOutputDetails)((ModelPackagingOutputDetails.Builder)ModelPackagingOutputDetails.builder().applyMutation(modelPackagingOutputDetails)).build());
        }

        public Builder status(String var1);

        public Builder status(ModelPackagingJobStatus var1);

        public Builder statusMessage(String var1);

        public Builder creationTimestamp(Instant var1);

        public Builder lastUpdatedTimestamp(Instant var1);
    }
}

