/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutvision.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutvision.model.LookoutVisionRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectAnomaliesRequest
extends LookoutVisionRequest
implements ToCopyableBuilder<Builder, DetectAnomaliesRequest> {
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectName").getter(DetectAnomaliesRequest.getter(DetectAnomaliesRequest::projectName)).setter(DetectAnomaliesRequest.setter(Builder::projectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("projectName").build()}).build();
    private static final SdkField<String> MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelVersion").getter(DetectAnomaliesRequest.getter(DetectAnomaliesRequest::modelVersion)).setter(DetectAnomaliesRequest.setter(Builder::modelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("modelVersion").build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentType").getter(DetectAnomaliesRequest.getter(DetectAnomaliesRequest::contentType)).setter(DetectAnomaliesRequest.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_NAME_FIELD, MODEL_VERSION_FIELD, CONTENT_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DetectAnomaliesRequest.memberNameToFieldInitializer();
    private final String projectName;
    private final String modelVersion;
    private final String contentType;

    private DetectAnomaliesRequest(BuilderImpl builder) {
        super(builder);
        this.projectName = builder.projectName;
        this.modelVersion = builder.modelVersion;
        this.contentType = builder.contentType;
    }

    public final String projectName() {
        return this.projectName;
    }

    public final String modelVersion() {
        return this.modelVersion;
    }

    public final String contentType() {
        return this.contentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectAnomaliesRequest)) {
            return false;
        }
        DetectAnomaliesRequest other = (DetectAnomaliesRequest)((Object)obj);
        return Objects.equals(this.projectName(), other.projectName()) && Objects.equals(this.modelVersion(), other.modelVersion()) && Objects.equals(this.contentType(), other.contentType());
    }

    public final String toString() {
        return ToString.builder((String)"DetectAnomaliesRequest").add("ProjectName", (Object)this.projectName()).add("ModelVersion", (Object)this.modelVersion()).add("ContentType", (Object)this.contentType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProjectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "ModelVersion": {
                return Optional.ofNullable(clazz.cast(this.modelVersion()));
            }
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("projectName", PROJECT_NAME_FIELD);
        map.put("modelVersion", MODEL_VERSION_FIELD);
        map.put("Content-Type", CONTENT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DetectAnomaliesRequest, T> g) {
        return obj -> g.apply((DetectAnomaliesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutVisionRequest.BuilderImpl
    implements Builder {
        private String projectName;
        private String modelVersion;
        private String contentType;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectAnomaliesRequest model) {
            super(model);
            this.projectName(model.projectName);
            this.modelVersion(model.modelVersion);
            this.contentType(model.contentType);
        }

        public final String getProjectName() {
            return this.projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getModelVersion() {
            return this.modelVersion;
        }

        public final void setModelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
        }

        @Override
        public final Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DetectAnomaliesRequest build() {
            return new DetectAnomaliesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LookoutVisionRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DetectAnomaliesRequest> {
        public Builder projectName(String var1);

        public Builder modelVersion(String var1);

        public Builder contentType(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

