/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutvision.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lookoutvision.model.Anomaly;
import software.amazon.awssdk.services.lookoutvision.model.AnomalyListCopier;
import software.amazon.awssdk.services.lookoutvision.model.ImageSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectAnomalyResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DetectAnomalyResult> {
    private static final SdkField<ImageSource> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Source").getter(DetectAnomalyResult.getter(DetectAnomalyResult::source)).setter(DetectAnomalyResult.setter(Builder::source)).constructor(ImageSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<Boolean> IS_ANOMALOUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsAnomalous").getter(DetectAnomalyResult.getter(DetectAnomalyResult::isAnomalous)).setter(DetectAnomalyResult.setter(Builder::isAnomalous)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsAnomalous").build()}).build();
    private static final SdkField<Float> CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Confidence").getter(DetectAnomalyResult.getter(DetectAnomalyResult::confidence)).setter(DetectAnomalyResult.setter(Builder::confidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()}).build();
    private static final SdkField<List<Anomaly>> ANOMALIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Anomalies").getter(DetectAnomalyResult.getter(DetectAnomalyResult::anomalies)).setter(DetectAnomalyResult.setter(Builder::anomalies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Anomalies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Anomaly::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SdkBytes> ANOMALY_MASK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("AnomalyMask").getter(DetectAnomalyResult.getter(DetectAnomalyResult::anomalyMask)).setter(DetectAnomalyResult.setter(Builder::anomalyMask)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyMask").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD, IS_ANOMALOUS_FIELD, CONFIDENCE_FIELD, ANOMALIES_FIELD, ANOMALY_MASK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DetectAnomalyResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ImageSource source;
    private final Boolean isAnomalous;
    private final Float confidence;
    private final List<Anomaly> anomalies;
    private final SdkBytes anomalyMask;

    private DetectAnomalyResult(BuilderImpl builder) {
        this.source = builder.source;
        this.isAnomalous = builder.isAnomalous;
        this.confidence = builder.confidence;
        this.anomalies = builder.anomalies;
        this.anomalyMask = builder.anomalyMask;
    }

    public final ImageSource source() {
        return this.source;
    }

    public final Boolean isAnomalous() {
        return this.isAnomalous;
    }

    public final Float confidence() {
        return this.confidence;
    }

    public final boolean hasAnomalies() {
        return this.anomalies != null && !(this.anomalies instanceof SdkAutoConstructList);
    }

    public final List<Anomaly> anomalies() {
        return this.anomalies;
    }

    public final SdkBytes anomalyMask() {
        return this.anomalyMask;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.isAnomalous());
        hashCode = 31 * hashCode + Objects.hashCode(this.confidence());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnomalies() ? this.anomalies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyMask());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectAnomalyResult)) {
            return false;
        }
        DetectAnomalyResult other = (DetectAnomalyResult)obj;
        return Objects.equals(this.source(), other.source()) && Objects.equals(this.isAnomalous(), other.isAnomalous()) && Objects.equals(this.confidence(), other.confidence()) && this.hasAnomalies() == other.hasAnomalies() && Objects.equals(this.anomalies(), other.anomalies()) && Objects.equals(this.anomalyMask(), other.anomalyMask());
    }

    public final String toString() {
        return ToString.builder((String)"DetectAnomalyResult").add("Source", (Object)this.source()).add("IsAnomalous", (Object)this.isAnomalous()).add("Confidence", (Object)this.confidence()).add("Anomalies", this.hasAnomalies() ? this.anomalies() : null).add("AnomalyMask", (Object)this.anomalyMask()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "IsAnomalous": {
                return Optional.ofNullable(clazz.cast(this.isAnomalous()));
            }
            case "Confidence": {
                return Optional.ofNullable(clazz.cast(this.confidence()));
            }
            case "Anomalies": {
                return Optional.ofNullable(clazz.cast(this.anomalies()));
            }
            case "AnomalyMask": {
                return Optional.ofNullable(clazz.cast(this.anomalyMask()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Source", SOURCE_FIELD);
        map.put("IsAnomalous", IS_ANOMALOUS_FIELD);
        map.put("Confidence", CONFIDENCE_FIELD);
        map.put("Anomalies", ANOMALIES_FIELD);
        map.put("AnomalyMask", ANOMALY_MASK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DetectAnomalyResult, T> g) {
        return obj -> g.apply((DetectAnomalyResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ImageSource source;
        private Boolean isAnomalous;
        private Float confidence;
        private List<Anomaly> anomalies = DefaultSdkAutoConstructList.getInstance();
        private SdkBytes anomalyMask;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectAnomalyResult model) {
            this.source(model.source);
            this.isAnomalous(model.isAnomalous);
            this.confidence(model.confidence);
            this.anomalies(model.anomalies);
            this.anomalyMask(model.anomalyMask);
        }

        public final ImageSource.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(ImageSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(ImageSource source) {
            this.source = source;
            return this;
        }

        public final Boolean getIsAnomalous() {
            return this.isAnomalous;
        }

        public final void setIsAnomalous(Boolean isAnomalous) {
            this.isAnomalous = isAnomalous;
        }

        @Override
        public final Builder isAnomalous(Boolean isAnomalous) {
            this.isAnomalous = isAnomalous;
            return this;
        }

        public final Float getConfidence() {
            return this.confidence;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final List<Anomaly.Builder> getAnomalies() {
            List<Anomaly.Builder> result = AnomalyListCopier.copyToBuilder(this.anomalies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnomalies(Collection<Anomaly.BuilderImpl> anomalies) {
            this.anomalies = AnomalyListCopier.copyFromBuilder(anomalies);
        }

        @Override
        public final Builder anomalies(Collection<Anomaly> anomalies) {
            this.anomalies = AnomalyListCopier.copy(anomalies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder anomalies(Anomaly ... anomalies) {
            this.anomalies(Arrays.asList(anomalies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder anomalies(Consumer<Anomaly.Builder> ... anomalies) {
            this.anomalies(Stream.of(anomalies).map(c -> (Anomaly)((Anomaly.Builder)Anomaly.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ByteBuffer getAnomalyMask() {
            return this.anomalyMask == null ? null : this.anomalyMask.asByteBuffer();
        }

        public final void setAnomalyMask(ByteBuffer anomalyMask) {
            this.anomalyMask(anomalyMask == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)anomalyMask));
        }

        @Override
        public final Builder anomalyMask(SdkBytes anomalyMask) {
            this.anomalyMask = anomalyMask;
            return this;
        }

        public DetectAnomalyResult build() {
            return new DetectAnomalyResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DetectAnomalyResult> {
        public Builder source(ImageSource var1);

        default public Builder source(Consumer<ImageSource.Builder> source) {
            return this.source((ImageSource)((ImageSource.Builder)ImageSource.builder().applyMutation(source)).build());
        }

        public Builder isAnomalous(Boolean var1);

        public Builder confidence(Float var1);

        public Builder anomalies(Collection<Anomaly> var1);

        public Builder anomalies(Anomaly ... var1);

        public Builder anomalies(Consumer<Anomaly.Builder> ... var1);

        public Builder anomalyMask(SdkBytes var1);
    }
}

