/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutvision.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lookoutvision.model.DatasetMetadata;
import software.amazon.awssdk.services.lookoutvision.model.DatasetMetadataListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProjectDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProjectDescription> {
    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectArn").getter(ProjectDescription.getter(ProjectDescription::projectArn)).setter(ProjectDescription.setter(Builder::projectArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectArn").build()}).build();
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectName").getter(ProjectDescription.getter(ProjectDescription::projectName)).setter(ProjectDescription.setter(Builder::projectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectName").build()}).build();
    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTimestamp").getter(ProjectDescription.getter(ProjectDescription::creationTimestamp)).setter(ProjectDescription.setter(Builder::creationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").build()}).build();
    private static final SdkField<List<DatasetMetadata>> DATASETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Datasets").getter(ProjectDescription.getter(ProjectDescription::datasets)).setter(ProjectDescription.setter(Builder::datasets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Datasets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DatasetMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ARN_FIELD, PROJECT_NAME_FIELD, CREATION_TIMESTAMP_FIELD, DATASETS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ProjectArn", PROJECT_ARN_FIELD);
            this.put("ProjectName", PROJECT_NAME_FIELD);
            this.put("CreationTimestamp", CREATION_TIMESTAMP_FIELD);
            this.put("Datasets", DATASETS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String projectArn;
    private final String projectName;
    private final Instant creationTimestamp;
    private final List<DatasetMetadata> datasets;

    private ProjectDescription(BuilderImpl builder) {
        this.projectArn = builder.projectArn;
        this.projectName = builder.projectName;
        this.creationTimestamp = builder.creationTimestamp;
        this.datasets = builder.datasets;
    }

    public final String projectArn() {
        return this.projectArn;
    }

    public final String projectName() {
        return this.projectName;
    }

    public final Instant creationTimestamp() {
        return this.creationTimestamp;
    }

    public final boolean hasDatasets() {
        return this.datasets != null && !(this.datasets instanceof SdkAutoConstructList);
    }

    public final List<DatasetMetadata> datasets() {
        return this.datasets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDatasets() ? this.datasets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectDescription)) {
            return false;
        }
        ProjectDescription other = (ProjectDescription)obj;
        return Objects.equals(this.projectArn(), other.projectArn()) && Objects.equals(this.projectName(), other.projectName()) && Objects.equals(this.creationTimestamp(), other.creationTimestamp()) && this.hasDatasets() == other.hasDatasets() && Objects.equals(this.datasets(), other.datasets());
    }

    public final String toString() {
        return ToString.builder((String)"ProjectDescription").add("ProjectArn", (Object)this.projectArn()).add("ProjectName", (Object)this.projectName()).add("CreationTimestamp", (Object)this.creationTimestamp()).add("Datasets", this.hasDatasets() ? this.datasets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProjectArn": {
                return Optional.ofNullable(clazz.cast(this.projectArn()));
            }
            case "ProjectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "CreationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.creationTimestamp()));
            }
            case "Datasets": {
                return Optional.ofNullable(clazz.cast(this.datasets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ProjectDescription, T> g) {
        return obj -> g.apply((ProjectDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String projectArn;
        private String projectName;
        private Instant creationTimestamp;
        private List<DatasetMetadata> datasets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectDescription model) {
            this.projectArn(model.projectArn);
            this.projectName(model.projectName);
            this.creationTimestamp(model.creationTimestamp);
            this.datasets(model.datasets);
        }

        public final String getProjectArn() {
            return this.projectArn;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final String getProjectName() {
            return this.projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final Instant getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final List<DatasetMetadata.Builder> getDatasets() {
            List<DatasetMetadata.Builder> result = DatasetMetadataListCopier.copyToBuilder(this.datasets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDatasets(Collection<DatasetMetadata.BuilderImpl> datasets) {
            this.datasets = DatasetMetadataListCopier.copyFromBuilder(datasets);
        }

        @Override
        public final Builder datasets(Collection<DatasetMetadata> datasets) {
            this.datasets = DatasetMetadataListCopier.copy(datasets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasets(DatasetMetadata ... datasets) {
            this.datasets(Arrays.asList(datasets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasets(Consumer<DatasetMetadata.Builder> ... datasets) {
            this.datasets(Stream.of(datasets).map(c -> (DatasetMetadata)((DatasetMetadata.Builder)DatasetMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ProjectDescription build() {
            return new ProjectDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProjectDescription> {
        public Builder projectArn(String var1);

        public Builder projectName(String var1);

        public Builder creationTimestamp(Instant var1);

        public Builder datasets(Collection<DatasetMetadata> var1);

        public Builder datasets(DatasetMetadata ... var1);

        public Builder datasets(Consumer<DatasetMetadata.Builder> ... var1);
    }
}

