/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutvision.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelPerformance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelPerformance> {
    private static final SdkField<Float> F1_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("F1Score").getter(ModelPerformance.getter(ModelPerformance::f1Score)).setter(ModelPerformance.setter(Builder::f1Score)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("F1Score").build()}).build();
    private static final SdkField<Float> RECALL_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Recall").getter(ModelPerformance.getter(ModelPerformance::recall)).setter(ModelPerformance.setter(Builder::recall)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recall").build()}).build();
    private static final SdkField<Float> PRECISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Precision").getter(ModelPerformance.getter(ModelPerformance::precision)).setter(ModelPerformance.setter(Builder::precision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Precision").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(F1_SCORE_FIELD, RECALL_FIELD, PRECISION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("F1Score", F1_SCORE_FIELD);
            this.put("Recall", RECALL_FIELD);
            this.put("Precision", PRECISION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Float f1Score;
    private final Float recall;
    private final Float precision;

    private ModelPerformance(BuilderImpl builder) {
        this.f1Score = builder.f1Score;
        this.recall = builder.recall;
        this.precision = builder.precision;
    }

    public final Float f1Score() {
        return this.f1Score;
    }

    public final Float recall() {
        return this.recall;
    }

    public final Float precision() {
        return this.precision;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.f1Score());
        hashCode = 31 * hashCode + Objects.hashCode(this.recall());
        hashCode = 31 * hashCode + Objects.hashCode(this.precision());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelPerformance)) {
            return false;
        }
        ModelPerformance other = (ModelPerformance)obj;
        return Objects.equals(this.f1Score(), other.f1Score()) && Objects.equals(this.recall(), other.recall()) && Objects.equals(this.precision(), other.precision());
    }

    public final String toString() {
        return ToString.builder((String)"ModelPerformance").add("F1Score", (Object)this.f1Score()).add("Recall", (Object)this.recall()).add("Precision", (Object)this.precision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "F1Score": {
                return Optional.ofNullable(clazz.cast(this.f1Score()));
            }
            case "Recall": {
                return Optional.ofNullable(clazz.cast(this.recall()));
            }
            case "Precision": {
                return Optional.ofNullable(clazz.cast(this.precision()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ModelPerformance, T> g) {
        return obj -> g.apply((ModelPerformance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Float f1Score;
        private Float recall;
        private Float precision;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelPerformance model) {
            this.f1Score(model.f1Score);
            this.recall(model.recall);
            this.precision(model.precision);
        }

        public final Float getF1Score() {
            return this.f1Score;
        }

        public final void setF1Score(Float f1Score) {
            this.f1Score = f1Score;
        }

        @Override
        public final Builder f1Score(Float f1Score) {
            this.f1Score = f1Score;
            return this;
        }

        public final Float getRecall() {
            return this.recall;
        }

        public final void setRecall(Float recall) {
            this.recall = recall;
        }

        @Override
        public final Builder recall(Float recall) {
            this.recall = recall;
            return this;
        }

        public final Float getPrecision() {
            return this.precision;
        }

        public final void setPrecision(Float precision) {
            this.precision = precision;
        }

        @Override
        public final Builder precision(Float precision) {
            this.precision = precision;
            return this;
        }

        public ModelPerformance build() {
            return new ModelPerformance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelPerformance> {
        public Builder f1Score(Float var1);

        public Builder recall(Float var1);

        public Builder precision(Float var1);
    }
}

