/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutvision.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lookoutvision.LookoutVisionAsyncClient;
import software.amazon.awssdk.services.lookoutvision.internal.UserAgentUtils;
import software.amazon.awssdk.services.lookoutvision.model.ListModelPackagingJobsRequest;
import software.amazon.awssdk.services.lookoutvision.model.ListModelPackagingJobsResponse;
import software.amazon.awssdk.services.lookoutvision.model.ModelPackagingJobMetadata;

public class ListModelPackagingJobsPublisher
implements SdkPublisher<ListModelPackagingJobsResponse> {
    private final LookoutVisionAsyncClient client;
    private final ListModelPackagingJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListModelPackagingJobsPublisher(LookoutVisionAsyncClient client, ListModelPackagingJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListModelPackagingJobsPublisher(LookoutVisionAsyncClient client, ListModelPackagingJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListModelPackagingJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListModelPackagingJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ModelPackagingJobMetadata> modelPackagingJobs() {
        Function<ListModelPackagingJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.modelPackagingJobs() != null) {
                return response.modelPackagingJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListModelPackagingJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListModelPackagingJobsResponseFetcher
    implements AsyncPageFetcher<ListModelPackagingJobsResponse> {
        private ListModelPackagingJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListModelPackagingJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListModelPackagingJobsResponse> nextPage(ListModelPackagingJobsResponse previousPage) {
            if (previousPage == null) {
                return ListModelPackagingJobsPublisher.this.client.listModelPackagingJobs(ListModelPackagingJobsPublisher.this.firstRequest);
            }
            return ListModelPackagingJobsPublisher.this.client.listModelPackagingJobs((ListModelPackagingJobsRequest)((Object)ListModelPackagingJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

