/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutvision.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an Amazon Lookout for Vision model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelDescription.Builder, ModelDescription> {
    private static final SdkField<String> MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelVersion").getter(getter(ModelDescription::modelVersion)).setter(setter(Builder::modelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersion").build()).build();

    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelArn").getter(getter(ModelDescription::modelArn)).setter(setter(Builder::modelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelArn").build()).build();

    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimestamp").getter(getter(ModelDescription::creationTimestamp))
            .setter(setter(Builder::creationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ModelDescription::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ModelDescription::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(ModelDescription::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<ModelPerformance> PERFORMANCE_FIELD = SdkField
            .<ModelPerformance> builder(MarshallingType.SDK_POJO).memberName("Performance")
            .getter(getter(ModelDescription::performance)).setter(setter(Builder::performance))
            .constructor(ModelPerformance::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Performance").build()).build();

    private static final SdkField<OutputConfig> OUTPUT_CONFIG_FIELD = SdkField.<OutputConfig> builder(MarshallingType.SDK_POJO)
            .memberName("OutputConfig").getter(getter(ModelDescription::outputConfig)).setter(setter(Builder::outputConfig))
            .constructor(OutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()).build();

    private static final SdkField<OutputS3Object> EVALUATION_MANIFEST_FIELD = SdkField
            .<OutputS3Object> builder(MarshallingType.SDK_POJO).memberName("EvaluationManifest")
            .getter(getter(ModelDescription::evaluationManifest)).setter(setter(Builder::evaluationManifest))
            .constructor(OutputS3Object::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationManifest").build())
            .build();

    private static final SdkField<OutputS3Object> EVALUATION_RESULT_FIELD = SdkField
            .<OutputS3Object> builder(MarshallingType.SDK_POJO).memberName("EvaluationResult")
            .getter(getter(ModelDescription::evaluationResult)).setter(setter(Builder::evaluationResult))
            .constructor(OutputS3Object::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationResult").build()).build();

    private static final SdkField<Instant> EVALUATION_END_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EvaluationEndTimestamp").getter(getter(ModelDescription::evaluationEndTimestamp))
            .setter(setter(Builder::evaluationEndTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationEndTimestamp").build())
            .build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(ModelDescription::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<Integer> MIN_INFERENCE_UNITS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinInferenceUnits").getter(getter(ModelDescription::minInferenceUnits))
            .setter(setter(Builder::minInferenceUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinInferenceUnits").build()).build();

    private static final SdkField<Integer> MAX_INFERENCE_UNITS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxInferenceUnits").getter(getter(ModelDescription::maxInferenceUnits))
            .setter(setter(Builder::maxInferenceUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxInferenceUnits").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_VERSION_FIELD,
            MODEL_ARN_FIELD, CREATION_TIMESTAMP_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, PERFORMANCE_FIELD,
            OUTPUT_CONFIG_FIELD, EVALUATION_MANIFEST_FIELD, EVALUATION_RESULT_FIELD, EVALUATION_END_TIMESTAMP_FIELD,
            KMS_KEY_ID_FIELD, MIN_INFERENCE_UNITS_FIELD, MAX_INFERENCE_UNITS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String modelVersion;

    private final String modelArn;

    private final Instant creationTimestamp;

    private final String description;

    private final String status;

    private final String statusMessage;

    private final ModelPerformance performance;

    private final OutputConfig outputConfig;

    private final OutputS3Object evaluationManifest;

    private final OutputS3Object evaluationResult;

    private final Instant evaluationEndTimestamp;

    private final String kmsKeyId;

    private final Integer minInferenceUnits;

    private final Integer maxInferenceUnits;

    private ModelDescription(BuilderImpl builder) {
        this.modelVersion = builder.modelVersion;
        this.modelArn = builder.modelArn;
        this.creationTimestamp = builder.creationTimestamp;
        this.description = builder.description;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.performance = builder.performance;
        this.outputConfig = builder.outputConfig;
        this.evaluationManifest = builder.evaluationManifest;
        this.evaluationResult = builder.evaluationResult;
        this.evaluationEndTimestamp = builder.evaluationEndTimestamp;
        this.kmsKeyId = builder.kmsKeyId;
        this.minInferenceUnits = builder.minInferenceUnits;
        this.maxInferenceUnits = builder.maxInferenceUnits;
    }

    /**
     * <p>
     * The version of the model
     * </p>
     * 
     * @return The version of the model
     */
    public final String modelVersion() {
        return modelVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the model.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the model.
     */
    public final String modelArn() {
        return modelArn;
    }

    /**
     * <p>
     * The unix timestamp for the date and time that the model was created.
     * </p>
     * 
     * @return The unix timestamp for the date and time that the model was created.
     */
    public final Instant creationTimestamp() {
        return creationTimestamp;
    }

    /**
     * <p>
     * The description for the model.
     * </p>
     * 
     * @return The description for the model.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The status of the model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ModelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the model.
     * @see ModelStatus
     */
    public final ModelStatus status() {
        return ModelStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ModelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the model.
     * @see ModelStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The status message for the model.
     * </p>
     * 
     * @return The status message for the model.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * Performance metrics for the model. Created during training.
     * </p>
     * 
     * @return Performance metrics for the model. Created during training.
     */
    public final ModelPerformance performance() {
        return performance;
    }

    /**
     * <p>
     * The S3 location where Amazon Lookout for Vision saves model training files.
     * </p>
     * 
     * @return The S3 location where Amazon Lookout for Vision saves model training files.
     */
    public final OutputConfig outputConfig() {
        return outputConfig;
    }

    /**
     * <p>
     * The S3 location where Amazon Lookout for Vision saves the manifest file that was used to test the trained model
     * and generate the performance scores.
     * </p>
     * 
     * @return The S3 location where Amazon Lookout for Vision saves the manifest file that was used to test the trained
     *         model and generate the performance scores.
     */
    public final OutputS3Object evaluationManifest() {
        return evaluationManifest;
    }

    /**
     * <p>
     * The S3 location where Amazon Lookout for Vision saves the performance metrics.
     * </p>
     * 
     * @return The S3 location where Amazon Lookout for Vision saves the performance metrics.
     */
    public final OutputS3Object evaluationResult() {
        return evaluationResult;
    }

    /**
     * <p>
     * The unix timestamp for the date and time that the evaluation ended.
     * </p>
     * 
     * @return The unix timestamp for the date and time that the evaluation ended.
     */
    public final Instant evaluationEndTimestamp() {
        return evaluationEndTimestamp;
    }

    /**
     * <p>
     * The identifer for the AWS Key Management Service (AWS KMS) key that was used to encrypt the model during
     * training.
     * </p>
     * 
     * @return The identifer for the AWS Key Management Service (AWS KMS) key that was used to encrypt the model during
     *         training.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The minimum number of inference units used by the model. For more information, see <a>StartModel</a>
     * </p>
     * 
     * @return The minimum number of inference units used by the model. For more information, see <a>StartModel</a>
     */
    public final Integer minInferenceUnits() {
        return minInferenceUnits;
    }

    /**
     * <p>
     * The maximum number of inference units Amazon Lookout for Vision uses to auto-scale the model. For more
     * information, see <a>StartModel</a>.
     * </p>
     * 
     * @return The maximum number of inference units Amazon Lookout for Vision uses to auto-scale the model. For more
     *         information, see <a>StartModel</a>.
     */
    public final Integer maxInferenceUnits() {
        return maxInferenceUnits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(performance());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationManifest());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationResult());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationEndTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(minInferenceUnits());
        hashCode = 31 * hashCode + Objects.hashCode(maxInferenceUnits());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelDescription)) {
            return false;
        }
        ModelDescription other = (ModelDescription) obj;
        return Objects.equals(modelVersion(), other.modelVersion()) && Objects.equals(modelArn(), other.modelArn())
                && Objects.equals(creationTimestamp(), other.creationTimestamp())
                && Objects.equals(description(), other.description()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(performance(), other.performance())
                && Objects.equals(outputConfig(), other.outputConfig())
                && Objects.equals(evaluationManifest(), other.evaluationManifest())
                && Objects.equals(evaluationResult(), other.evaluationResult())
                && Objects.equals(evaluationEndTimestamp(), other.evaluationEndTimestamp())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(minInferenceUnits(), other.minInferenceUnits())
                && Objects.equals(maxInferenceUnits(), other.maxInferenceUnits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelDescription").add("ModelVersion", modelVersion()).add("ModelArn", modelArn())
                .add("CreationTimestamp", creationTimestamp()).add("Description", description()).add("Status", statusAsString())
                .add("StatusMessage", statusMessage()).add("Performance", performance()).add("OutputConfig", outputConfig())
                .add("EvaluationManifest", evaluationManifest()).add("EvaluationResult", evaluationResult())
                .add("EvaluationEndTimestamp", evaluationEndTimestamp()).add("KmsKeyId", kmsKeyId())
                .add("MinInferenceUnits", minInferenceUnits()).add("MaxInferenceUnits", maxInferenceUnits()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelVersion":
            return Optional.ofNullable(clazz.cast(modelVersion()));
        case "ModelArn":
            return Optional.ofNullable(clazz.cast(modelArn()));
        case "CreationTimestamp":
            return Optional.ofNullable(clazz.cast(creationTimestamp()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "Performance":
            return Optional.ofNullable(clazz.cast(performance()));
        case "OutputConfig":
            return Optional.ofNullable(clazz.cast(outputConfig()));
        case "EvaluationManifest":
            return Optional.ofNullable(clazz.cast(evaluationManifest()));
        case "EvaluationResult":
            return Optional.ofNullable(clazz.cast(evaluationResult()));
        case "EvaluationEndTimestamp":
            return Optional.ofNullable(clazz.cast(evaluationEndTimestamp()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "MinInferenceUnits":
            return Optional.ofNullable(clazz.cast(minInferenceUnits()));
        case "MaxInferenceUnits":
            return Optional.ofNullable(clazz.cast(maxInferenceUnits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelDescription, T> g) {
        return obj -> g.apply((ModelDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelDescription> {
        /**
         * <p>
         * The version of the model
         * </p>
         * 
         * @param modelVersion
         *        The version of the model
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVersion(String modelVersion);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the model.
         * </p>
         * 
         * @param modelArn
         *        The Amazon Resource Name (ARN) of the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelArn(String modelArn);

        /**
         * <p>
         * The unix timestamp for the date and time that the model was created.
         * </p>
         * 
         * @param creationTimestamp
         *        The unix timestamp for the date and time that the model was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimestamp(Instant creationTimestamp);

        /**
         * <p>
         * The description for the model.
         * </p>
         * 
         * @param description
         *        The description for the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The status of the model.
         * </p>
         * 
         * @param status
         *        The status of the model.
         * @see ModelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the model.
         * </p>
         * 
         * @param status
         *        The status of the model.
         * @see ModelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelStatus
         */
        Builder status(ModelStatus status);

        /**
         * <p>
         * The status message for the model.
         * </p>
         * 
         * @param statusMessage
         *        The status message for the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * Performance metrics for the model. Created during training.
         * </p>
         * 
         * @param performance
         *        Performance metrics for the model. Created during training.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performance(ModelPerformance performance);

        /**
         * <p>
         * Performance metrics for the model. Created during training.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelPerformance.Builder} avoiding the
         * need to create one manually via {@link ModelPerformance#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelPerformance.Builder#build()} is called immediately and its
         * result is passed to {@link #performance(ModelPerformance)}.
         * 
         * @param performance
         *        a consumer that will call methods on {@link ModelPerformance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #performance(ModelPerformance)
         */
        default Builder performance(Consumer<ModelPerformance.Builder> performance) {
            return performance(ModelPerformance.builder().applyMutation(performance).build());
        }

        /**
         * <p>
         * The S3 location where Amazon Lookout for Vision saves model training files.
         * </p>
         * 
         * @param outputConfig
         *        The S3 location where Amazon Lookout for Vision saves model training files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfig(OutputConfig outputConfig);

        /**
         * <p>
         * The S3 location where Amazon Lookout for Vision saves model training files.
         * </p>
         * This is a convenience method that creates an instance of the {@link OutputConfig.Builder} avoiding the need
         * to create one manually via {@link OutputConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutputConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #outputConfig(OutputConfig)}.
         * 
         * @param outputConfig
         *        a consumer that will call methods on {@link OutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfig(OutputConfig)
         */
        default Builder outputConfig(Consumer<OutputConfig.Builder> outputConfig) {
            return outputConfig(OutputConfig.builder().applyMutation(outputConfig).build());
        }

        /**
         * <p>
         * The S3 location where Amazon Lookout for Vision saves the manifest file that was used to test the trained
         * model and generate the performance scores.
         * </p>
         * 
         * @param evaluationManifest
         *        The S3 location where Amazon Lookout for Vision saves the manifest file that was used to test the
         *        trained model and generate the performance scores.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationManifest(OutputS3Object evaluationManifest);

        /**
         * <p>
         * The S3 location where Amazon Lookout for Vision saves the manifest file that was used to test the trained
         * model and generate the performance scores.
         * </p>
         * This is a convenience method that creates an instance of the {@link OutputS3Object.Builder} avoiding the need
         * to create one manually via {@link OutputS3Object#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutputS3Object.Builder#build()} is called immediately and its
         * result is passed to {@link #evaluationManifest(OutputS3Object)}.
         * 
         * @param evaluationManifest
         *        a consumer that will call methods on {@link OutputS3Object.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluationManifest(OutputS3Object)
         */
        default Builder evaluationManifest(Consumer<OutputS3Object.Builder> evaluationManifest) {
            return evaluationManifest(OutputS3Object.builder().applyMutation(evaluationManifest).build());
        }

        /**
         * <p>
         * The S3 location where Amazon Lookout for Vision saves the performance metrics.
         * </p>
         * 
         * @param evaluationResult
         *        The S3 location where Amazon Lookout for Vision saves the performance metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationResult(OutputS3Object evaluationResult);

        /**
         * <p>
         * The S3 location where Amazon Lookout for Vision saves the performance metrics.
         * </p>
         * This is a convenience method that creates an instance of the {@link OutputS3Object.Builder} avoiding the need
         * to create one manually via {@link OutputS3Object#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutputS3Object.Builder#build()} is called immediately and its
         * result is passed to {@link #evaluationResult(OutputS3Object)}.
         * 
         * @param evaluationResult
         *        a consumer that will call methods on {@link OutputS3Object.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluationResult(OutputS3Object)
         */
        default Builder evaluationResult(Consumer<OutputS3Object.Builder> evaluationResult) {
            return evaluationResult(OutputS3Object.builder().applyMutation(evaluationResult).build());
        }

        /**
         * <p>
         * The unix timestamp for the date and time that the evaluation ended.
         * </p>
         * 
         * @param evaluationEndTimestamp
         *        The unix timestamp for the date and time that the evaluation ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationEndTimestamp(Instant evaluationEndTimestamp);

        /**
         * <p>
         * The identifer for the AWS Key Management Service (AWS KMS) key that was used to encrypt the model during
         * training.
         * </p>
         * 
         * @param kmsKeyId
         *        The identifer for the AWS Key Management Service (AWS KMS) key that was used to encrypt the model
         *        during training.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The minimum number of inference units used by the model. For more information, see <a>StartModel</a>
         * </p>
         * 
         * @param minInferenceUnits
         *        The minimum number of inference units used by the model. For more information, see <a>StartModel</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minInferenceUnits(Integer minInferenceUnits);

        /**
         * <p>
         * The maximum number of inference units Amazon Lookout for Vision uses to auto-scale the model. For more
         * information, see <a>StartModel</a>.
         * </p>
         * 
         * @param maxInferenceUnits
         *        The maximum number of inference units Amazon Lookout for Vision uses to auto-scale the model. For more
         *        information, see <a>StartModel</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxInferenceUnits(Integer maxInferenceUnits);
    }

    static final class BuilderImpl implements Builder {
        private String modelVersion;

        private String modelArn;

        private Instant creationTimestamp;

        private String description;

        private String status;

        private String statusMessage;

        private ModelPerformance performance;

        private OutputConfig outputConfig;

        private OutputS3Object evaluationManifest;

        private OutputS3Object evaluationResult;

        private Instant evaluationEndTimestamp;

        private String kmsKeyId;

        private Integer minInferenceUnits;

        private Integer maxInferenceUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelDescription model) {
            modelVersion(model.modelVersion);
            modelArn(model.modelArn);
            creationTimestamp(model.creationTimestamp);
            description(model.description);
            status(model.status);
            statusMessage(model.statusMessage);
            performance(model.performance);
            outputConfig(model.outputConfig);
            evaluationManifest(model.evaluationManifest);
            evaluationResult(model.evaluationResult);
            evaluationEndTimestamp(model.evaluationEndTimestamp);
            kmsKeyId(model.kmsKeyId);
            minInferenceUnits(model.minInferenceUnits);
            maxInferenceUnits(model.maxInferenceUnits);
        }

        public final String getModelVersion() {
            return modelVersion;
        }

        public final void setModelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
        }

        @Override
        public final Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public final String getModelArn() {
            return modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final Instant getCreationTimestamp() {
            return creationTimestamp;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ModelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final ModelPerformance.Builder getPerformance() {
            return performance != null ? performance.toBuilder() : null;
        }

        public final void setPerformance(ModelPerformance.BuilderImpl performance) {
            this.performance = performance != null ? performance.build() : null;
        }

        @Override
        public final Builder performance(ModelPerformance performance) {
            this.performance = performance;
            return this;
        }

        public final OutputConfig.Builder getOutputConfig() {
            return outputConfig != null ? outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(OutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(OutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final OutputS3Object.Builder getEvaluationManifest() {
            return evaluationManifest != null ? evaluationManifest.toBuilder() : null;
        }

        public final void setEvaluationManifest(OutputS3Object.BuilderImpl evaluationManifest) {
            this.evaluationManifest = evaluationManifest != null ? evaluationManifest.build() : null;
        }

        @Override
        public final Builder evaluationManifest(OutputS3Object evaluationManifest) {
            this.evaluationManifest = evaluationManifest;
            return this;
        }

        public final OutputS3Object.Builder getEvaluationResult() {
            return evaluationResult != null ? evaluationResult.toBuilder() : null;
        }

        public final void setEvaluationResult(OutputS3Object.BuilderImpl evaluationResult) {
            this.evaluationResult = evaluationResult != null ? evaluationResult.build() : null;
        }

        @Override
        public final Builder evaluationResult(OutputS3Object evaluationResult) {
            this.evaluationResult = evaluationResult;
            return this;
        }

        public final Instant getEvaluationEndTimestamp() {
            return evaluationEndTimestamp;
        }

        public final void setEvaluationEndTimestamp(Instant evaluationEndTimestamp) {
            this.evaluationEndTimestamp = evaluationEndTimestamp;
        }

        @Override
        public final Builder evaluationEndTimestamp(Instant evaluationEndTimestamp) {
            this.evaluationEndTimestamp = evaluationEndTimestamp;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Integer getMinInferenceUnits() {
            return minInferenceUnits;
        }

        public final void setMinInferenceUnits(Integer minInferenceUnits) {
            this.minInferenceUnits = minInferenceUnits;
        }

        @Override
        public final Builder minInferenceUnits(Integer minInferenceUnits) {
            this.minInferenceUnits = minInferenceUnits;
            return this;
        }

        public final Integer getMaxInferenceUnits() {
            return maxInferenceUnits;
        }

        public final void setMaxInferenceUnits(Integer maxInferenceUnits) {
            this.maxInferenceUnits = maxInferenceUnits;
        }

        @Override
        public final Builder maxInferenceUnits(Integer maxInferenceUnits) {
            this.maxInferenceUnits = maxInferenceUnits;
            return this;
        }

        @Override
        public ModelDescription build() {
            return new ModelDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
