/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutvision.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ModelHostingStatus {
    STARTING_HOSTING("STARTING_HOSTING"),
    HOSTED("HOSTED"),
    HOSTING_FAILED("HOSTING_FAILED"),
    STOPPING_HOSTING("STOPPING_HOSTING"),
    SYSTEM_UPDATING("SYSTEM_UPDATING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ModelHostingStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ModelHostingStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ModelHostingStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ModelHostingStatus> knownValues() {
        return Stream.of(ModelHostingStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

