/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutvision.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutvision.model.ImageSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectAnomalyResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DetectAnomalyResult> {
    private static final SdkField<ImageSource> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Source").getter(DetectAnomalyResult.getter(DetectAnomalyResult::source)).setter(DetectAnomalyResult.setter(Builder::source)).constructor(ImageSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<Boolean> IS_ANOMALOUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsAnomalous").getter(DetectAnomalyResult.getter(DetectAnomalyResult::isAnomalous)).setter(DetectAnomalyResult.setter(Builder::isAnomalous)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsAnomalous").build()}).build();
    private static final SdkField<Float> CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Confidence").getter(DetectAnomalyResult.getter(DetectAnomalyResult::confidence)).setter(DetectAnomalyResult.setter(Builder::confidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD, IS_ANOMALOUS_FIELD, CONFIDENCE_FIELD));
    private static final long serialVersionUID = 1L;
    private final ImageSource source;
    private final Boolean isAnomalous;
    private final Float confidence;

    private DetectAnomalyResult(BuilderImpl builder) {
        this.source = builder.source;
        this.isAnomalous = builder.isAnomalous;
        this.confidence = builder.confidence;
    }

    public final ImageSource source() {
        return this.source;
    }

    public final Boolean isAnomalous() {
        return this.isAnomalous;
    }

    public final Float confidence() {
        return this.confidence;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.isAnomalous());
        hashCode = 31 * hashCode + Objects.hashCode(this.confidence());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectAnomalyResult)) {
            return false;
        }
        DetectAnomalyResult other = (DetectAnomalyResult)obj;
        return Objects.equals(this.source(), other.source()) && Objects.equals(this.isAnomalous(), other.isAnomalous()) && Objects.equals(this.confidence(), other.confidence());
    }

    public final String toString() {
        return ToString.builder((String)"DetectAnomalyResult").add("Source", (Object)this.source()).add("IsAnomalous", (Object)this.isAnomalous()).add("Confidence", (Object)this.confidence()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "IsAnomalous": {
                return Optional.ofNullable(clazz.cast(this.isAnomalous()));
            }
            case "Confidence": {
                return Optional.ofNullable(clazz.cast(this.confidence()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectAnomalyResult, T> g) {
        return obj -> g.apply((DetectAnomalyResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ImageSource source;
        private Boolean isAnomalous;
        private Float confidence;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectAnomalyResult model) {
            this.source(model.source);
            this.isAnomalous(model.isAnomalous);
            this.confidence(model.confidence);
        }

        public final ImageSource.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        @Override
        public final Builder source(ImageSource source) {
            this.source = source;
            return this;
        }

        public final void setSource(ImageSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        public final Boolean getIsAnomalous() {
            return this.isAnomalous;
        }

        @Override
        public final Builder isAnomalous(Boolean isAnomalous) {
            this.isAnomalous = isAnomalous;
            return this;
        }

        public final void setIsAnomalous(Boolean isAnomalous) {
            this.isAnomalous = isAnomalous;
        }

        public final Float getConfidence() {
            return this.confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        public DetectAnomalyResult build() {
            return new DetectAnomalyResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DetectAnomalyResult> {
        public Builder source(ImageSource var1);

        default public Builder source(Consumer<ImageSource.Builder> source) {
            return this.source((ImageSource)((ImageSource.Builder)ImageSource.builder().applyMutation(source)).build());
        }

        public Builder isAnomalous(Boolean var1);

        public Builder confidence(Float var1);
    }
}

