/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.location.model.LocationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMapResponse
extends LocationResponse
implements ToCopyableBuilder<Builder, CreateMapResponse> {
    private static final SdkField<String> MAP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MapName").getter(CreateMapResponse.getter(CreateMapResponse::mapName)).setter(CreateMapResponse.setter(Builder::mapName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapName").build()}).build();
    private static final SdkField<String> MAP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MapArn").getter(CreateMapResponse.getter(CreateMapResponse::mapArn)).setter(CreateMapResponse.setter(Builder::mapArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapArn").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(CreateMapResponse.getter(CreateMapResponse::createTime)).setter(CreateMapResponse.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAP_NAME_FIELD, MAP_ARN_FIELD, CREATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateMapResponse.memberNameToFieldInitializer();
    private final String mapName;
    private final String mapArn;
    private final Instant createTime;

    private CreateMapResponse(BuilderImpl builder) {
        super(builder);
        this.mapName = builder.mapName;
        this.mapArn = builder.mapArn;
        this.createTime = builder.createTime;
    }

    public final String mapName() {
        return this.mapName;
    }

    public final String mapArn() {
        return this.mapArn;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.mapName());
        hashCode = 31 * hashCode + Objects.hashCode(this.mapArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMapResponse)) {
            return false;
        }
        CreateMapResponse other = (CreateMapResponse)((Object)obj);
        return Objects.equals(this.mapName(), other.mapName()) && Objects.equals(this.mapArn(), other.mapArn()) && Objects.equals(this.createTime(), other.createTime());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMapResponse").add("MapName", (Object)this.mapName()).add("MapArn", (Object)this.mapArn()).add("CreateTime", (Object)(this.createTime() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MapName": {
                return Optional.ofNullable(clazz.cast(this.mapName()));
            }
            case "MapArn": {
                return Optional.ofNullable(clazz.cast(this.mapArn()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MapName", MAP_NAME_FIELD);
        map.put("MapArn", MAP_ARN_FIELD);
        map.put("CreateTime", CREATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMapResponse, T> g) {
        return obj -> g.apply((CreateMapResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationResponse.BuilderImpl
    implements Builder {
        private String mapName;
        private String mapArn;
        private Instant createTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMapResponse model) {
            super(model);
            this.mapName(model.mapName);
            this.mapArn(model.mapArn);
            this.createTime(model.createTime);
        }

        public final String getMapName() {
            return this.mapName;
        }

        public final void setMapName(String mapName) {
            this.mapName = mapName;
        }

        @Override
        public final Builder mapName(String mapName) {
            this.mapName = mapName;
            return this;
        }

        public final String getMapArn() {
            return this.mapArn;
        }

        public final void setMapArn(String mapArn) {
            this.mapArn = mapArn;
        }

        @Override
        public final Builder mapArn(String mapArn) {
            this.mapArn = mapArn;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        @Override
        public CreateMapResponse build() {
            return new CreateMapResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LocationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMapResponse> {
        public Builder mapName(String var1);

        public Builder mapArn(String var1);

        public Builder createTime(Instant var1);
    }
}

