/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ForecastedGeofenceEventType {
    ENTER("ENTER"),
    EXIT("EXIT"),
    IDLE("IDLE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ForecastedGeofenceEventType> VALUE_MAP;
    private final String value;

    private ForecastedGeofenceEventType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ForecastedGeofenceEventType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ForecastedGeofenceEventType> knownValues() {
        EnumSet<ForecastedGeofenceEventType> knownValues = EnumSet.allOf(ForecastedGeofenceEventType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ForecastedGeofenceEventType.class, ForecastedGeofenceEventType::toString);
    }
}

