/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.location.model.LocationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMapTileRequest
extends LocationRequest
implements ToCopyableBuilder<Builder, GetMapTileRequest> {
    private static final SdkField<String> MAP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MapName").getter(GetMapTileRequest.getter(GetMapTileRequest::mapName)).setter(GetMapTileRequest.setter(Builder::mapName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("MapName").build()}).build();
    private static final SdkField<String> Z_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Z").getter(GetMapTileRequest.getter(GetMapTileRequest::z)).setter(GetMapTileRequest.setter(Builder::z)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Z").build()}).build();
    private static final SdkField<String> X_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("X").getter(GetMapTileRequest.getter(GetMapTileRequest::x)).setter(GetMapTileRequest.setter(Builder::x)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("X").build()}).build();
    private static final SdkField<String> Y_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Y").getter(GetMapTileRequest.getter(GetMapTileRequest::y)).setter(GetMapTileRequest.setter(Builder::y)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Y").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Key").getter(GetMapTileRequest.getter(GetMapTileRequest::key)).setter(GetMapTileRequest.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("key").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAP_NAME_FIELD, Z_FIELD, X_FIELD, Y_FIELD, KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetMapTileRequest.memberNameToFieldInitializer();
    private final String mapName;
    private final String z;
    private final String x;
    private final String y;
    private final String key;

    private GetMapTileRequest(BuilderImpl builder) {
        super(builder);
        this.mapName = builder.mapName;
        this.z = builder.z;
        this.x = builder.x;
        this.y = builder.y;
        this.key = builder.key;
    }

    public final String mapName() {
        return this.mapName;
    }

    public final String z() {
        return this.z;
    }

    public final String x() {
        return this.x;
    }

    public final String y() {
        return this.y;
    }

    public final String key() {
        return this.key;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.mapName());
        hashCode = 31 * hashCode + Objects.hashCode(this.z());
        hashCode = 31 * hashCode + Objects.hashCode(this.x());
        hashCode = 31 * hashCode + Objects.hashCode(this.y());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMapTileRequest)) {
            return false;
        }
        GetMapTileRequest other = (GetMapTileRequest)((Object)obj);
        return Objects.equals(this.mapName(), other.mapName()) && Objects.equals(this.z(), other.z()) && Objects.equals(this.x(), other.x()) && Objects.equals(this.y(), other.y()) && Objects.equals(this.key(), other.key());
    }

    public final String toString() {
        return ToString.builder((String)"GetMapTileRequest").add("MapName", (Object)this.mapName()).add("Z", (Object)this.z()).add("X", (Object)this.x()).add("Y", (Object)this.y()).add("Key", (Object)(this.key() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MapName": {
                return Optional.ofNullable(clazz.cast(this.mapName()));
            }
            case "Z": {
                return Optional.ofNullable(clazz.cast(this.z()));
            }
            case "X": {
                return Optional.ofNullable(clazz.cast(this.x()));
            }
            case "Y": {
                return Optional.ofNullable(clazz.cast(this.y()));
            }
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("MapName", MAP_NAME_FIELD);
        map.put("Z", Z_FIELD);
        map.put("X", X_FIELD);
        map.put("Y", Y_FIELD);
        map.put("key", KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMapTileRequest, T> g) {
        return obj -> g.apply((GetMapTileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationRequest.BuilderImpl
    implements Builder {
        private String mapName;
        private String z;
        private String x;
        private String y;
        private String key;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMapTileRequest model) {
            super(model);
            this.mapName(model.mapName);
            this.z(model.z);
            this.x(model.x);
            this.y(model.y);
            this.key(model.key);
        }

        public final String getMapName() {
            return this.mapName;
        }

        public final void setMapName(String mapName) {
            this.mapName = mapName;
        }

        @Override
        public final Builder mapName(String mapName) {
            this.mapName = mapName;
            return this;
        }

        public final String getZ() {
            return this.z;
        }

        public final void setZ(String z) {
            this.z = z;
        }

        @Override
        public final Builder z(String z) {
            this.z = z;
            return this;
        }

        public final String getX() {
            return this.x;
        }

        public final void setX(String x) {
            this.x = x;
        }

        @Override
        public final Builder x(String x) {
            this.x = x;
            return this;
        }

        public final String getY() {
            return this.y;
        }

        public final void setY(String y) {
            this.y = y;
        }

        @Override
        public final Builder y(String y) {
            this.y = y;
            return this;
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMapTileRequest build() {
            return new GetMapTileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LocationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMapTileRequest> {
        public Builder mapName(String var1);

        public Builder z(String var1);

        public Builder x(String var1);

        public Builder y(String var1);

        public Builder key(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

