/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.location.model.LocationResponse;
import software.amazon.awssdk.services.location.model.PricingPlan;
import software.amazon.awssdk.services.location.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeGeofenceCollectionResponse
extends LocationResponse
implements ToCopyableBuilder<Builder, DescribeGeofenceCollectionResponse> {
    private static final SdkField<String> COLLECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CollectionName").getter(DescribeGeofenceCollectionResponse.getter(DescribeGeofenceCollectionResponse::collectionName)).setter(DescribeGeofenceCollectionResponse.setter(Builder::collectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionName").build()}).build();
    private static final SdkField<String> COLLECTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CollectionArn").getter(DescribeGeofenceCollectionResponse.getter(DescribeGeofenceCollectionResponse::collectionArn)).setter(DescribeGeofenceCollectionResponse.setter(Builder::collectionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribeGeofenceCollectionResponse.getter(DescribeGeofenceCollectionResponse::description)).setter(DescribeGeofenceCollectionResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> PRICING_PLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PricingPlan").getter(DescribeGeofenceCollectionResponse.getter(DescribeGeofenceCollectionResponse::pricingPlanAsString)).setter(DescribeGeofenceCollectionResponse.setter(Builder::pricingPlan)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlan").build()}).build();
    private static final SdkField<String> PRICING_PLAN_DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PricingPlanDataSource").getter(DescribeGeofenceCollectionResponse.getter(DescribeGeofenceCollectionResponse::pricingPlanDataSource)).setter(DescribeGeofenceCollectionResponse.setter(Builder::pricingPlanDataSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlanDataSource").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(DescribeGeofenceCollectionResponse.getter(DescribeGeofenceCollectionResponse::kmsKeyId)).setter(DescribeGeofenceCollectionResponse.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(DescribeGeofenceCollectionResponse.getter(DescribeGeofenceCollectionResponse::tags)).setter(DescribeGeofenceCollectionResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(DescribeGeofenceCollectionResponse.getter(DescribeGeofenceCollectionResponse::createTime)).setter(DescribeGeofenceCollectionResponse.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdateTime").getter(DescribeGeofenceCollectionResponse.getter(DescribeGeofenceCollectionResponse::updateTime)).setter(DescribeGeofenceCollectionResponse.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Integer> GEOFENCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("GeofenceCount").getter(DescribeGeofenceCollectionResponse.getter(DescribeGeofenceCollectionResponse::geofenceCount)).setter(DescribeGeofenceCollectionResponse.setter(Builder::geofenceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeofenceCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_NAME_FIELD, COLLECTION_ARN_FIELD, DESCRIPTION_FIELD, PRICING_PLAN_FIELD, PRICING_PLAN_DATA_SOURCE_FIELD, KMS_KEY_ID_FIELD, TAGS_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD, GEOFENCE_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeGeofenceCollectionResponse.memberNameToFieldInitializer();
    private final String collectionName;
    private final String collectionArn;
    private final String description;
    private final String pricingPlan;
    private final String pricingPlanDataSource;
    private final String kmsKeyId;
    private final Map<String, String> tags;
    private final Instant createTime;
    private final Instant updateTime;
    private final Integer geofenceCount;

    private DescribeGeofenceCollectionResponse(BuilderImpl builder) {
        super(builder);
        this.collectionName = builder.collectionName;
        this.collectionArn = builder.collectionArn;
        this.description = builder.description;
        this.pricingPlan = builder.pricingPlan;
        this.pricingPlanDataSource = builder.pricingPlanDataSource;
        this.kmsKeyId = builder.kmsKeyId;
        this.tags = builder.tags;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.geofenceCount = builder.geofenceCount;
    }

    public final String collectionName() {
        return this.collectionName;
    }

    public final String collectionArn() {
        return this.collectionArn;
    }

    public final String description() {
        return this.description;
    }

    @Deprecated
    public final PricingPlan pricingPlan() {
        return PricingPlan.fromValue(this.pricingPlan);
    }

    @Deprecated
    public final String pricingPlanAsString() {
        return this.pricingPlan;
    }

    @Deprecated
    public final String pricingPlanDataSource() {
        return this.pricingPlanDataSource;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public final Integer geofenceCount() {
        return this.geofenceCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.pricingPlanAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pricingPlanDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.geofenceCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGeofenceCollectionResponse)) {
            return false;
        }
        DescribeGeofenceCollectionResponse other = (DescribeGeofenceCollectionResponse)((Object)obj);
        return Objects.equals(this.collectionName(), other.collectionName()) && Objects.equals(this.collectionArn(), other.collectionArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.pricingPlanAsString(), other.pricingPlanAsString()) && Objects.equals(this.pricingPlanDataSource(), other.pricingPlanDataSource()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime()) && Objects.equals(this.geofenceCount(), other.geofenceCount());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeGeofenceCollectionResponse").add("CollectionName", (Object)this.collectionName()).add("CollectionArn", (Object)this.collectionArn()).add("Description", (Object)this.description()).add("PricingPlan", (Object)this.pricingPlanAsString()).add("PricingPlanDataSource", (Object)this.pricingPlanDataSource()).add("KmsKeyId", (Object)this.kmsKeyId()).add("Tags", this.hasTags() ? this.tags() : null).add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).add("GeofenceCount", (Object)this.geofenceCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CollectionName": {
                return Optional.ofNullable(clazz.cast(this.collectionName()));
            }
            case "CollectionArn": {
                return Optional.ofNullable(clazz.cast(this.collectionArn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "PricingPlan": {
                return Optional.ofNullable(clazz.cast(this.pricingPlanAsString()));
            }
            case "PricingPlanDataSource": {
                return Optional.ofNullable(clazz.cast(this.pricingPlanDataSource()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "UpdateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "GeofenceCount": {
                return Optional.ofNullable(clazz.cast(this.geofenceCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CollectionName", COLLECTION_NAME_FIELD);
        map.put("CollectionArn", COLLECTION_ARN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("PricingPlan", PRICING_PLAN_FIELD);
        map.put("PricingPlanDataSource", PRICING_PLAN_DATA_SOURCE_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("CreateTime", CREATE_TIME_FIELD);
        map.put("UpdateTime", UPDATE_TIME_FIELD);
        map.put("GeofenceCount", GEOFENCE_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeGeofenceCollectionResponse, T> g) {
        return obj -> g.apply((DescribeGeofenceCollectionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationResponse.BuilderImpl
    implements Builder {
        private String collectionName;
        private String collectionArn;
        private String description;
        private String pricingPlan;
        private String pricingPlanDataSource;
        private String kmsKeyId;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Instant createTime;
        private Instant updateTime;
        private Integer geofenceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGeofenceCollectionResponse model) {
            super(model);
            this.collectionName(model.collectionName);
            this.collectionArn(model.collectionArn);
            this.description(model.description);
            this.pricingPlan(model.pricingPlan);
            this.pricingPlanDataSource(model.pricingPlanDataSource);
            this.kmsKeyId(model.kmsKeyId);
            this.tags(model.tags);
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
            this.geofenceCount(model.geofenceCount);
        }

        public final String getCollectionName() {
            return this.collectionName;
        }

        public final void setCollectionName(String collectionName) {
            this.collectionName = collectionName;
        }

        @Override
        public final Builder collectionName(String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        public final String getCollectionArn() {
            return this.collectionArn;
        }

        public final void setCollectionArn(String collectionArn) {
            this.collectionArn = collectionArn;
        }

        @Override
        public final Builder collectionArn(String collectionArn) {
            this.collectionArn = collectionArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Deprecated
        public final String getPricingPlan() {
            return this.pricingPlan;
        }

        @Deprecated
        public final void setPricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
        }

        @Override
        @Deprecated
        public final Builder pricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
            return this;
        }

        @Override
        @Deprecated
        public final Builder pricingPlan(PricingPlan pricingPlan) {
            this.pricingPlan(pricingPlan == null ? null : pricingPlan.toString());
            return this;
        }

        @Deprecated
        public final String getPricingPlanDataSource() {
            return this.pricingPlanDataSource;
        }

        @Deprecated
        public final void setPricingPlanDataSource(String pricingPlanDataSource) {
            this.pricingPlanDataSource = pricingPlanDataSource;
        }

        @Override
        @Deprecated
        public final Builder pricingPlanDataSource(String pricingPlanDataSource) {
            this.pricingPlanDataSource = pricingPlanDataSource;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final Integer getGeofenceCount() {
            return this.geofenceCount;
        }

        public final void setGeofenceCount(Integer geofenceCount) {
            this.geofenceCount = geofenceCount;
        }

        @Override
        public final Builder geofenceCount(Integer geofenceCount) {
            this.geofenceCount = geofenceCount;
            return this;
        }

        @Override
        public DescribeGeofenceCollectionResponse build() {
            return new DescribeGeofenceCollectionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LocationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeGeofenceCollectionResponse> {
        public Builder collectionName(String var1);

        public Builder collectionArn(String var1);

        public Builder description(String var1);

        @Deprecated
        public Builder pricingPlan(String var1);

        @Deprecated
        public Builder pricingPlan(PricingPlan var1);

        @Deprecated
        public Builder pricingPlanDataSource(String var1);

        public Builder kmsKeyId(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder geofenceCount(Integer var1);
    }
}

