/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.location.LocationClient;
import software.amazon.awssdk.services.location.internal.UserAgentUtils;
import software.amazon.awssdk.services.location.model.ListGeofenceCollectionsRequest;
import software.amazon.awssdk.services.location.model.ListGeofenceCollectionsResponse;
import software.amazon.awssdk.services.location.model.ListGeofenceCollectionsResponseEntry;

public class ListGeofenceCollectionsIterable
implements SdkIterable<ListGeofenceCollectionsResponse> {
    private final LocationClient client;
    private final ListGeofenceCollectionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListGeofenceCollectionsIterable(LocationClient client, ListGeofenceCollectionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListGeofenceCollectionsResponseFetcher();
    }

    public Iterator<ListGeofenceCollectionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListGeofenceCollectionsResponseEntry> entries() {
        Function<ListGeofenceCollectionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.entries() != null) {
                return response.entries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListGeofenceCollectionsResponseFetcher
    implements SyncPageFetcher<ListGeofenceCollectionsResponse> {
        private ListGeofenceCollectionsResponseFetcher() {
        }

        public boolean hasNextPage(ListGeofenceCollectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListGeofenceCollectionsResponse nextPage(ListGeofenceCollectionsResponse previousPage) {
            if (previousPage == null) {
                return ListGeofenceCollectionsIterable.this.client.listGeofenceCollections(ListGeofenceCollectionsIterable.this.firstRequest);
            }
            return ListGeofenceCollectionsIterable.this.client.listGeofenceCollections((ListGeofenceCollectionsRequest)((Object)ListGeofenceCollectionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

