/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.location.LocationAsyncClient;
import software.amazon.awssdk.services.location.internal.UserAgentUtils;
import software.amazon.awssdk.services.location.model.ForecastGeofenceEventsRequest;
import software.amazon.awssdk.services.location.model.ForecastGeofenceEventsResponse;
import software.amazon.awssdk.services.location.model.ForecastedEvent;

public class ForecastGeofenceEventsPublisher
implements SdkPublisher<ForecastGeofenceEventsResponse> {
    private final LocationAsyncClient client;
    private final ForecastGeofenceEventsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ForecastGeofenceEventsPublisher(LocationAsyncClient client, ForecastGeofenceEventsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ForecastGeofenceEventsPublisher(LocationAsyncClient client, ForecastGeofenceEventsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ForecastGeofenceEventsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ForecastGeofenceEventsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ForecastedEvent> forecastedEvents() {
        Function<ForecastGeofenceEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.forecastedEvents() != null) {
                return response.forecastedEvents().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ForecastGeofenceEventsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ForecastGeofenceEventsResponseFetcher
    implements AsyncPageFetcher<ForecastGeofenceEventsResponse> {
        private ForecastGeofenceEventsResponseFetcher() {
        }

        public boolean hasNextPage(ForecastGeofenceEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ForecastGeofenceEventsResponse> nextPage(ForecastGeofenceEventsResponse previousPage) {
            if (previousPage == null) {
                return ForecastGeofenceEventsPublisher.this.client.forecastGeofenceEvents(ForecastGeofenceEventsPublisher.this.firstRequest);
            }
            return ForecastGeofenceEventsPublisher.this.client.forecastGeofenceEvents((ForecastGeofenceEventsRequest)((Object)ForecastGeofenceEventsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

