/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.location.model.LocationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMapSpritesResponse
extends LocationResponse
implements ToCopyableBuilder<Builder, GetMapSpritesResponse> {
    private static final SdkField<SdkBytes> BLOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("Blob").getter(GetMapSpritesResponse.getter(GetMapSpritesResponse::blob)).setter(GetMapSpritesResponse.setter(Builder::blob)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Blob").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentType").getter(GetMapSpritesResponse.getter(GetMapSpritesResponse::contentType)).setter(GetMapSpritesResponse.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()}).build();
    private static final SdkField<String> CACHE_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CacheControl").getter(GetMapSpritesResponse.getter(GetMapSpritesResponse::cacheControl)).setter(GetMapSpritesResponse.setter(Builder::cacheControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Cache-Control").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOB_FIELD, CONTENT_TYPE_FIELD, CACHE_CONTROL_FIELD));
    private final SdkBytes blob;
    private final String contentType;
    private final String cacheControl;

    private GetMapSpritesResponse(BuilderImpl builder) {
        super(builder);
        this.blob = builder.blob;
        this.contentType = builder.contentType;
        this.cacheControl = builder.cacheControl;
    }

    public final SdkBytes blob() {
        return this.blob;
    }

    public final String contentType() {
        return this.contentType;
    }

    public final String cacheControl() {
        return this.cacheControl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.blob());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheControl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMapSpritesResponse)) {
            return false;
        }
        GetMapSpritesResponse other = (GetMapSpritesResponse)((Object)obj);
        return Objects.equals(this.blob(), other.blob()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.cacheControl(), other.cacheControl());
    }

    public final String toString() {
        return ToString.builder((String)"GetMapSpritesResponse").add("Blob", (Object)this.blob()).add("ContentType", (Object)this.contentType()).add("CacheControl", (Object)this.cacheControl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Blob": {
                return Optional.ofNullable(clazz.cast(this.blob()));
            }
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "CacheControl": {
                return Optional.ofNullable(clazz.cast(this.cacheControl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMapSpritesResponse, T> g) {
        return obj -> g.apply((GetMapSpritesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationResponse.BuilderImpl
    implements Builder {
        private SdkBytes blob;
        private String contentType;
        private String cacheControl;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMapSpritesResponse model) {
            super(model);
            this.blob(model.blob);
            this.contentType(model.contentType);
            this.cacheControl(model.cacheControl);
        }

        public final ByteBuffer getBlob() {
            return this.blob == null ? null : this.blob.asByteBuffer();
        }

        public final void setBlob(ByteBuffer blob) {
            this.blob(blob == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)blob));
        }

        @Override
        public final Builder blob(SdkBytes blob) {
            this.blob = blob;
            return this;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getCacheControl() {
            return this.cacheControl;
        }

        public final void setCacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
        }

        @Override
        public final Builder cacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
            return this;
        }

        @Override
        public GetMapSpritesResponse build() {
            return new GetMapSpritesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LocationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMapSpritesResponse> {
        public Builder blob(SdkBytes var1);

        public Builder contentType(String var1);

        public Builder cacheControl(String var1);
    }
}

