/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.location.model.LocationResponse;
import software.amazon.awssdk.services.location.model.PositionFiltering;
import software.amazon.awssdk.services.location.model.PricingPlan;
import software.amazon.awssdk.services.location.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTrackerResponse
extends LocationResponse
implements ToCopyableBuilder<Builder, DescribeTrackerResponse> {
    private static final SdkField<String> TRACKER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrackerName").getter(DescribeTrackerResponse.getter(DescribeTrackerResponse::trackerName)).setter(DescribeTrackerResponse.setter(Builder::trackerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackerName").build()}).build();
    private static final SdkField<String> TRACKER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrackerArn").getter(DescribeTrackerResponse.getter(DescribeTrackerResponse::trackerArn)).setter(DescribeTrackerResponse.setter(Builder::trackerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackerArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribeTrackerResponse.getter(DescribeTrackerResponse::description)).setter(DescribeTrackerResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> PRICING_PLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PricingPlan").getter(DescribeTrackerResponse.getter(DescribeTrackerResponse::pricingPlanAsString)).setter(DescribeTrackerResponse.setter(Builder::pricingPlan)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlan").build()}).build();
    private static final SdkField<String> PRICING_PLAN_DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PricingPlanDataSource").getter(DescribeTrackerResponse.getter(DescribeTrackerResponse::pricingPlanDataSource)).setter(DescribeTrackerResponse.setter(Builder::pricingPlanDataSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlanDataSource").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(DescribeTrackerResponse.getter(DescribeTrackerResponse::tags)).setter(DescribeTrackerResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(DescribeTrackerResponse.getter(DescribeTrackerResponse::createTime)).setter(DescribeTrackerResponse.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdateTime").getter(DescribeTrackerResponse.getter(DescribeTrackerResponse::updateTime)).setter(DescribeTrackerResponse.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(DescribeTrackerResponse.getter(DescribeTrackerResponse::kmsKeyId)).setter(DescribeTrackerResponse.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> POSITION_FILTERING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PositionFiltering").getter(DescribeTrackerResponse.getter(DescribeTrackerResponse::positionFilteringAsString)).setter(DescribeTrackerResponse.setter(Builder::positionFiltering)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PositionFiltering").build()}).build();
    private static final SdkField<Boolean> EVENT_BRIDGE_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EventBridgeEnabled").getter(DescribeTrackerResponse.getter(DescribeTrackerResponse::eventBridgeEnabled)).setter(DescribeTrackerResponse.setter(Builder::eventBridgeEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBridgeEnabled").build()}).build();
    private static final SdkField<Boolean> KMS_KEY_ENABLE_GEOSPATIAL_QUERIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("KmsKeyEnableGeospatialQueries").getter(DescribeTrackerResponse.getter(DescribeTrackerResponse::kmsKeyEnableGeospatialQueries)).setter(DescribeTrackerResponse.setter(Builder::kmsKeyEnableGeospatialQueries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyEnableGeospatialQueries").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACKER_NAME_FIELD, TRACKER_ARN_FIELD, DESCRIPTION_FIELD, PRICING_PLAN_FIELD, PRICING_PLAN_DATA_SOURCE_FIELD, TAGS_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD, KMS_KEY_ID_FIELD, POSITION_FILTERING_FIELD, EVENT_BRIDGE_ENABLED_FIELD, KMS_KEY_ENABLE_GEOSPATIAL_QUERIES_FIELD));
    private final String trackerName;
    private final String trackerArn;
    private final String description;
    private final String pricingPlan;
    private final String pricingPlanDataSource;
    private final Map<String, String> tags;
    private final Instant createTime;
    private final Instant updateTime;
    private final String kmsKeyId;
    private final String positionFiltering;
    private final Boolean eventBridgeEnabled;
    private final Boolean kmsKeyEnableGeospatialQueries;

    private DescribeTrackerResponse(BuilderImpl builder) {
        super(builder);
        this.trackerName = builder.trackerName;
        this.trackerArn = builder.trackerArn;
        this.description = builder.description;
        this.pricingPlan = builder.pricingPlan;
        this.pricingPlanDataSource = builder.pricingPlanDataSource;
        this.tags = builder.tags;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.kmsKeyId = builder.kmsKeyId;
        this.positionFiltering = builder.positionFiltering;
        this.eventBridgeEnabled = builder.eventBridgeEnabled;
        this.kmsKeyEnableGeospatialQueries = builder.kmsKeyEnableGeospatialQueries;
    }

    public final String trackerName() {
        return this.trackerName;
    }

    public final String trackerArn() {
        return this.trackerArn;
    }

    public final String description() {
        return this.description;
    }

    @Deprecated
    public final PricingPlan pricingPlan() {
        return PricingPlan.fromValue(this.pricingPlan);
    }

    @Deprecated
    public final String pricingPlanAsString() {
        return this.pricingPlan;
    }

    @Deprecated
    public final String pricingPlanDataSource() {
        return this.pricingPlanDataSource;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final PositionFiltering positionFiltering() {
        return PositionFiltering.fromValue(this.positionFiltering);
    }

    public final String positionFilteringAsString() {
        return this.positionFiltering;
    }

    public final Boolean eventBridgeEnabled() {
        return this.eventBridgeEnabled;
    }

    public final Boolean kmsKeyEnableGeospatialQueries() {
        return this.kmsKeyEnableGeospatialQueries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trackerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.trackerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.pricingPlanAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pricingPlanDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.positionFilteringAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventBridgeEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyEnableGeospatialQueries());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrackerResponse)) {
            return false;
        }
        DescribeTrackerResponse other = (DescribeTrackerResponse)((Object)obj);
        return Objects.equals(this.trackerName(), other.trackerName()) && Objects.equals(this.trackerArn(), other.trackerArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.pricingPlanAsString(), other.pricingPlanAsString()) && Objects.equals(this.pricingPlanDataSource(), other.pricingPlanDataSource()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.positionFilteringAsString(), other.positionFilteringAsString()) && Objects.equals(this.eventBridgeEnabled(), other.eventBridgeEnabled()) && Objects.equals(this.kmsKeyEnableGeospatialQueries(), other.kmsKeyEnableGeospatialQueries());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTrackerResponse").add("TrackerName", (Object)this.trackerName()).add("TrackerArn", (Object)this.trackerArn()).add("Description", (Object)this.description()).add("PricingPlan", (Object)this.pricingPlanAsString()).add("PricingPlanDataSource", (Object)this.pricingPlanDataSource()).add("Tags", this.hasTags() ? this.tags() : null).add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).add("KmsKeyId", (Object)this.kmsKeyId()).add("PositionFiltering", (Object)this.positionFilteringAsString()).add("EventBridgeEnabled", (Object)this.eventBridgeEnabled()).add("KmsKeyEnableGeospatialQueries", (Object)this.kmsKeyEnableGeospatialQueries()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrackerName": {
                return Optional.ofNullable(clazz.cast(this.trackerName()));
            }
            case "TrackerArn": {
                return Optional.ofNullable(clazz.cast(this.trackerArn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "PricingPlan": {
                return Optional.ofNullable(clazz.cast(this.pricingPlanAsString()));
            }
            case "PricingPlanDataSource": {
                return Optional.ofNullable(clazz.cast(this.pricingPlanDataSource()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "UpdateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "PositionFiltering": {
                return Optional.ofNullable(clazz.cast(this.positionFilteringAsString()));
            }
            case "EventBridgeEnabled": {
                return Optional.ofNullable(clazz.cast(this.eventBridgeEnabled()));
            }
            case "KmsKeyEnableGeospatialQueries": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyEnableGeospatialQueries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrackerResponse, T> g) {
        return obj -> g.apply((DescribeTrackerResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationResponse.BuilderImpl
    implements Builder {
        private String trackerName;
        private String trackerArn;
        private String description;
        private String pricingPlan;
        private String pricingPlanDataSource;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Instant createTime;
        private Instant updateTime;
        private String kmsKeyId;
        private String positionFiltering;
        private Boolean eventBridgeEnabled;
        private Boolean kmsKeyEnableGeospatialQueries;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrackerResponse model) {
            super(model);
            this.trackerName(model.trackerName);
            this.trackerArn(model.trackerArn);
            this.description(model.description);
            this.pricingPlan(model.pricingPlan);
            this.pricingPlanDataSource(model.pricingPlanDataSource);
            this.tags(model.tags);
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
            this.kmsKeyId(model.kmsKeyId);
            this.positionFiltering(model.positionFiltering);
            this.eventBridgeEnabled(model.eventBridgeEnabled);
            this.kmsKeyEnableGeospatialQueries(model.kmsKeyEnableGeospatialQueries);
        }

        public final String getTrackerName() {
            return this.trackerName;
        }

        public final void setTrackerName(String trackerName) {
            this.trackerName = trackerName;
        }

        @Override
        public final Builder trackerName(String trackerName) {
            this.trackerName = trackerName;
            return this;
        }

        public final String getTrackerArn() {
            return this.trackerArn;
        }

        public final void setTrackerArn(String trackerArn) {
            this.trackerArn = trackerArn;
        }

        @Override
        public final Builder trackerArn(String trackerArn) {
            this.trackerArn = trackerArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Deprecated
        public final String getPricingPlan() {
            return this.pricingPlan;
        }

        @Deprecated
        public final void setPricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
        }

        @Override
        @Deprecated
        public final Builder pricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
            return this;
        }

        @Override
        @Deprecated
        public final Builder pricingPlan(PricingPlan pricingPlan) {
            this.pricingPlan(pricingPlan == null ? null : pricingPlan.toString());
            return this;
        }

        @Deprecated
        public final String getPricingPlanDataSource() {
            return this.pricingPlanDataSource;
        }

        @Deprecated
        public final void setPricingPlanDataSource(String pricingPlanDataSource) {
            this.pricingPlanDataSource = pricingPlanDataSource;
        }

        @Override
        @Deprecated
        public final Builder pricingPlanDataSource(String pricingPlanDataSource) {
            this.pricingPlanDataSource = pricingPlanDataSource;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getPositionFiltering() {
            return this.positionFiltering;
        }

        public final void setPositionFiltering(String positionFiltering) {
            this.positionFiltering = positionFiltering;
        }

        @Override
        public final Builder positionFiltering(String positionFiltering) {
            this.positionFiltering = positionFiltering;
            return this;
        }

        @Override
        public final Builder positionFiltering(PositionFiltering positionFiltering) {
            this.positionFiltering(positionFiltering == null ? null : positionFiltering.toString());
            return this;
        }

        public final Boolean getEventBridgeEnabled() {
            return this.eventBridgeEnabled;
        }

        public final void setEventBridgeEnabled(Boolean eventBridgeEnabled) {
            this.eventBridgeEnabled = eventBridgeEnabled;
        }

        @Override
        public final Builder eventBridgeEnabled(Boolean eventBridgeEnabled) {
            this.eventBridgeEnabled = eventBridgeEnabled;
            return this;
        }

        public final Boolean getKmsKeyEnableGeospatialQueries() {
            return this.kmsKeyEnableGeospatialQueries;
        }

        public final void setKmsKeyEnableGeospatialQueries(Boolean kmsKeyEnableGeospatialQueries) {
            this.kmsKeyEnableGeospatialQueries = kmsKeyEnableGeospatialQueries;
        }

        @Override
        public final Builder kmsKeyEnableGeospatialQueries(Boolean kmsKeyEnableGeospatialQueries) {
            this.kmsKeyEnableGeospatialQueries = kmsKeyEnableGeospatialQueries;
            return this;
        }

        @Override
        public DescribeTrackerResponse build() {
            return new DescribeTrackerResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LocationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTrackerResponse> {
        public Builder trackerName(String var1);

        public Builder trackerArn(String var1);

        public Builder description(String var1);

        @Deprecated
        public Builder pricingPlan(String var1);

        @Deprecated
        public Builder pricingPlan(PricingPlan var1);

        @Deprecated
        public Builder pricingPlanDataSource(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder kmsKeyId(String var1);

        public Builder positionFiltering(String var1);

        public Builder positionFiltering(PositionFiltering var1);

        public Builder eventBridgeEnabled(Boolean var1);

        public Builder kmsKeyEnableGeospatialQueries(Boolean var1);
    }
}

