/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.endpoints.internal;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsExecutionAttribute;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.awscore.endpoints.authscheme.EndpointAuthScheme;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4AuthScheme;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4aAuthScheme;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SelectedAuthScheme;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4aHttpSigner;
import software.amazon.awssdk.http.auth.aws.signer.RegionSet;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.identity.spi.Identity;
import software.amazon.awssdk.services.location.endpoints.LocationEndpointParams;
import software.amazon.awssdk.services.location.endpoints.LocationEndpointProvider;
import software.amazon.awssdk.services.location.endpoints.internal.AwsEndpointProviderUtils;

@SdkInternalApi
public final class LocationResolveEndpointInterceptor
implements ExecutionInterceptor {
    public SdkRequest modifyRequest(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        SdkRequest result = context.request();
        if (AwsEndpointProviderUtils.endpointIsDiscovered(executionAttributes)) {
            return result;
        }
        LocationEndpointProvider provider = (LocationEndpointProvider)executionAttributes.getAttribute(SdkInternalExecutionAttribute.ENDPOINT_PROVIDER);
        try {
            Optional<String> hostPrefix;
            long resolveEndpointStart = System.nanoTime();
            Endpoint endpoint = provider.resolveEndpoint(LocationResolveEndpointInterceptor.ruleParams(result, executionAttributes)).join();
            Duration resolveEndpointDuration = Duration.ofNanos(System.nanoTime() - resolveEndpointStart);
            Optional metricCollector = executionAttributes.getOptionalAttribute(SdkExecutionAttribute.API_CALL_METRIC_COLLECTOR);
            metricCollector.ifPresent(mc -> mc.reportMetric(CoreMetric.ENDPOINT_RESOLVE_DURATION, (Object)resolveEndpointDuration));
            if (!AwsEndpointProviderUtils.disableHostPrefixInjection(executionAttributes) && (hostPrefix = LocationResolveEndpointInterceptor.hostPrefix((String)executionAttributes.getAttribute(SdkExecutionAttribute.OPERATION_NAME), result)).isPresent()) {
                endpoint = AwsEndpointProviderUtils.addHostPrefix(endpoint, hostPrefix.get());
            }
            List endpointAuthSchemes = (List)endpoint.attribute(AwsEndpointAttribute.AUTH_SCHEMES);
            SelectedAuthScheme selectedAuthScheme = (SelectedAuthScheme)executionAttributes.getAttribute(SdkInternalExecutionAttribute.SELECTED_AUTH_SCHEME);
            if (endpointAuthSchemes != null && selectedAuthScheme != null) {
                selectedAuthScheme = this.authSchemeWithEndpointSignerProperties(endpointAuthSchemes, selectedAuthScheme);
                executionAttributes.putAttribute(SdkInternalExecutionAttribute.SELECTED_AUTH_SCHEME, selectedAuthScheme);
            }
            executionAttributes.putAttribute(SdkInternalExecutionAttribute.RESOLVED_ENDPOINT, (Object)endpoint);
            return result;
        }
        catch (CompletionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SdkClientException) {
                throw (SdkClientException)cause;
            }
            throw SdkClientException.create((String)"Endpoint resolution failed", (Throwable)cause);
        }
    }

    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        Endpoint resolvedEndpoint = (Endpoint)executionAttributes.getAttribute(SdkInternalExecutionAttribute.RESOLVED_ENDPOINT);
        if (resolvedEndpoint.headers().isEmpty()) {
            return context.httpRequest();
        }
        SdkHttpRequest.Builder httpRequestBuilder = (SdkHttpRequest.Builder)context.httpRequest().toBuilder();
        resolvedEndpoint.headers().forEach((name, values) -> values.forEach(v -> httpRequestBuilder.appendHeader(name, v)));
        return (SdkHttpRequest)httpRequestBuilder.build();
    }

    public static LocationEndpointParams ruleParams(SdkRequest request, ExecutionAttributes executionAttributes) {
        LocationEndpointParams.Builder builder = LocationEndpointParams.builder();
        builder.region(AwsEndpointProviderUtils.regionBuiltIn(executionAttributes));
        builder.useDualStack(AwsEndpointProviderUtils.dualStackEnabledBuiltIn(executionAttributes));
        builder.useFips(AwsEndpointProviderUtils.fipsEnabledBuiltIn(executionAttributes));
        builder.endpoint(AwsEndpointProviderUtils.endpointBuiltIn(executionAttributes));
        LocationResolveEndpointInterceptor.setContextParams(builder, (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME), request);
        LocationResolveEndpointInterceptor.setStaticContextParams(builder, (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME));
        LocationResolveEndpointInterceptor.setOperationContextParams(builder, (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME), request);
        return builder.build();
    }

    private static void setContextParams(LocationEndpointParams.Builder params, String operationName, SdkRequest request) {
    }

    private static void setStaticContextParams(LocationEndpointParams.Builder params, String operationName) {
    }

    private <T extends Identity> SelectedAuthScheme<T> authSchemeWithEndpointSignerProperties(List<EndpointAuthScheme> endpointAuthSchemes, SelectedAuthScheme<T> selectedAuthScheme) {
        for (EndpointAuthScheme endpointAuthScheme : endpointAuthSchemes) {
            if (!endpointAuthScheme.schemeId().equals(selectedAuthScheme.authSchemeOption().schemeId())) continue;
            AuthSchemeOption.Builder option = (AuthSchemeOption.Builder)selectedAuthScheme.authSchemeOption().toBuilder();
            if (endpointAuthScheme instanceof SigV4AuthScheme) {
                SigV4AuthScheme v4AuthScheme = (SigV4AuthScheme)endpointAuthScheme;
                if (v4AuthScheme.isDisableDoubleEncodingSet()) {
                    option.putSignerProperty(AwsV4HttpSigner.DOUBLE_URL_ENCODE, (Object)(!v4AuthScheme.disableDoubleEncoding() ? 1 : 0));
                }
                if (v4AuthScheme.signingRegion() != null) {
                    option.putSignerProperty(AwsV4HttpSigner.REGION_NAME, (Object)v4AuthScheme.signingRegion());
                }
                if (v4AuthScheme.signingName() != null) {
                    option.putSignerProperty(AwsV4HttpSigner.SERVICE_SIGNING_NAME, (Object)v4AuthScheme.signingName());
                }
                return new SelectedAuthScheme(selectedAuthScheme.identity(), selectedAuthScheme.signer(), (AuthSchemeOption)option.build());
            }
            if (endpointAuthScheme instanceof SigV4aAuthScheme) {
                SigV4aAuthScheme v4aAuthScheme = (SigV4aAuthScheme)endpointAuthScheme;
                if (v4aAuthScheme.isDisableDoubleEncodingSet()) {
                    option.putSignerProperty(AwsV4aHttpSigner.DOUBLE_URL_ENCODE, (Object)(!v4aAuthScheme.disableDoubleEncoding() ? 1 : 0));
                }
                if (v4aAuthScheme.signingRegionSet() != null) {
                    RegionSet regionSet = RegionSet.create((Collection)v4aAuthScheme.signingRegionSet());
                    option.putSignerProperty(AwsV4aHttpSigner.REGION_SET, (Object)regionSet);
                }
                if (v4aAuthScheme.signingName() != null) {
                    option.putSignerProperty(AwsV4aHttpSigner.SERVICE_SIGNING_NAME, (Object)v4aAuthScheme.signingName());
                }
                return new SelectedAuthScheme(selectedAuthScheme.identity(), selectedAuthScheme.signer(), (AuthSchemeOption)option.build());
            }
            throw new IllegalArgumentException("Endpoint auth scheme '" + endpointAuthScheme.name() + "' cannot be mapped to the SDK auth scheme. Was it declared in the service's model?");
        }
        return selectedAuthScheme;
    }

    private static void setOperationContextParams(LocationEndpointParams.Builder params, String operationName, SdkRequest request) {
    }

    private static Optional<String> hostPrefix(String operationName, SdkRequest request) {
        switch (operationName) {
            case "AssociateTrackerConsumer": {
                return Optional.of("cp.tracking.");
            }
            case "BatchDeleteDevicePositionHistory": {
                return Optional.of("tracking.");
            }
            case "BatchDeleteGeofence": {
                return Optional.of("geofencing.");
            }
            case "BatchEvaluateGeofences": {
                return Optional.of("geofencing.");
            }
            case "BatchGetDevicePosition": {
                return Optional.of("tracking.");
            }
            case "BatchPutGeofence": {
                return Optional.of("geofencing.");
            }
            case "BatchUpdateDevicePosition": {
                return Optional.of("tracking.");
            }
            case "CalculateRoute": {
                return Optional.of("routes.");
            }
            case "CalculateRouteMatrix": {
                return Optional.of("routes.");
            }
            case "CreateGeofenceCollection": {
                return Optional.of("cp.geofencing.");
            }
            case "CreateKey": {
                return Optional.of("cp.metadata.");
            }
            case "CreateMap": {
                return Optional.of("cp.maps.");
            }
            case "CreatePlaceIndex": {
                return Optional.of("cp.places.");
            }
            case "CreateRouteCalculator": {
                return Optional.of("cp.routes.");
            }
            case "CreateTracker": {
                return Optional.of("cp.tracking.");
            }
            case "DeleteGeofenceCollection": {
                return Optional.of("cp.geofencing.");
            }
            case "DeleteKey": {
                return Optional.of("cp.metadata.");
            }
            case "DeleteMap": {
                return Optional.of("cp.maps.");
            }
            case "DeletePlaceIndex": {
                return Optional.of("cp.places.");
            }
            case "DeleteRouteCalculator": {
                return Optional.of("cp.routes.");
            }
            case "DeleteTracker": {
                return Optional.of("cp.tracking.");
            }
            case "DescribeGeofenceCollection": {
                return Optional.of("cp.geofencing.");
            }
            case "DescribeKey": {
                return Optional.of("cp.metadata.");
            }
            case "DescribeMap": {
                return Optional.of("cp.maps.");
            }
            case "DescribePlaceIndex": {
                return Optional.of("cp.places.");
            }
            case "DescribeRouteCalculator": {
                return Optional.of("cp.routes.");
            }
            case "DescribeTracker": {
                return Optional.of("cp.tracking.");
            }
            case "DisassociateTrackerConsumer": {
                return Optional.of("cp.tracking.");
            }
            case "GetDevicePosition": {
                return Optional.of("tracking.");
            }
            case "GetDevicePositionHistory": {
                return Optional.of("tracking.");
            }
            case "GetGeofence": {
                return Optional.of("geofencing.");
            }
            case "GetMapGlyphs": {
                return Optional.of("maps.");
            }
            case "GetMapSprites": {
                return Optional.of("maps.");
            }
            case "GetMapStyleDescriptor": {
                return Optional.of("maps.");
            }
            case "GetMapTile": {
                return Optional.of("maps.");
            }
            case "GetPlace": {
                return Optional.of("places.");
            }
            case "ListDevicePositions": {
                return Optional.of("tracking.");
            }
            case "ListGeofenceCollections": {
                return Optional.of("cp.geofencing.");
            }
            case "ListGeofences": {
                return Optional.of("geofencing.");
            }
            case "ListKeys": {
                return Optional.of("cp.metadata.");
            }
            case "ListMaps": {
                return Optional.of("cp.maps.");
            }
            case "ListPlaceIndexes": {
                return Optional.of("cp.places.");
            }
            case "ListRouteCalculators": {
                return Optional.of("cp.routes.");
            }
            case "ListTagsForResource": {
                return Optional.of("cp.metadata.");
            }
            case "ListTrackerConsumers": {
                return Optional.of("cp.tracking.");
            }
            case "ListTrackers": {
                return Optional.of("cp.tracking.");
            }
            case "PutGeofence": {
                return Optional.of("geofencing.");
            }
            case "SearchPlaceIndexForPosition": {
                return Optional.of("places.");
            }
            case "SearchPlaceIndexForSuggestions": {
                return Optional.of("places.");
            }
            case "SearchPlaceIndexForText": {
                return Optional.of("places.");
            }
            case "TagResource": {
                return Optional.of("cp.metadata.");
            }
            case "UntagResource": {
                return Optional.of("cp.metadata.");
            }
            case "UpdateGeofenceCollection": {
                return Optional.of("cp.geofencing.");
            }
            case "UpdateKey": {
                return Optional.of("cp.metadata.");
            }
            case "UpdateMap": {
                return Optional.of("cp.maps.");
            }
            case "UpdatePlaceIndex": {
                return Optional.of("cp.places.");
            }
            case "UpdateRouteCalculator": {
                return Optional.of("cp.routes.");
            }
            case "UpdateTracker": {
                return Optional.of("cp.tracking.");
            }
        }
        return Optional.empty();
    }
}

