/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.location.model.LocationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMapResponse
extends LocationResponse
implements ToCopyableBuilder<Builder, UpdateMapResponse> {
    private static final SdkField<String> MAP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MapArn").getter(UpdateMapResponse.getter(UpdateMapResponse::mapArn)).setter(UpdateMapResponse.setter(Builder::mapArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapArn").build()}).build();
    private static final SdkField<String> MAP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MapName").getter(UpdateMapResponse.getter(UpdateMapResponse::mapName)).setter(UpdateMapResponse.setter(Builder::mapName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapName").build()}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdateTime").getter(UpdateMapResponse.getter(UpdateMapResponse::updateTime)).setter(UpdateMapResponse.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAP_ARN_FIELD, MAP_NAME_FIELD, UPDATE_TIME_FIELD));
    private final String mapArn;
    private final String mapName;
    private final Instant updateTime;

    private UpdateMapResponse(BuilderImpl builder) {
        super(builder);
        this.mapArn = builder.mapArn;
        this.mapName = builder.mapName;
        this.updateTime = builder.updateTime;
    }

    public final String mapArn() {
        return this.mapArn;
    }

    public final String mapName() {
        return this.mapName;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.mapArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.mapName());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMapResponse)) {
            return false;
        }
        UpdateMapResponse other = (UpdateMapResponse)((Object)obj);
        return Objects.equals(this.mapArn(), other.mapArn()) && Objects.equals(this.mapName(), other.mapName()) && Objects.equals(this.updateTime(), other.updateTime());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateMapResponse").add("MapArn", (Object)this.mapArn()).add("MapName", (Object)this.mapName()).add("UpdateTime", (Object)this.updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MapArn": {
                return Optional.ofNullable(clazz.cast(this.mapArn()));
            }
            case "MapName": {
                return Optional.ofNullable(clazz.cast(this.mapName()));
            }
            case "UpdateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMapResponse, T> g) {
        return obj -> g.apply((UpdateMapResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationResponse.BuilderImpl
    implements Builder {
        private String mapArn;
        private String mapName;
        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMapResponse model) {
            super(model);
            this.mapArn(model.mapArn);
            this.mapName(model.mapName);
            this.updateTime(model.updateTime);
        }

        public final String getMapArn() {
            return this.mapArn;
        }

        public final void setMapArn(String mapArn) {
            this.mapArn = mapArn;
        }

        @Override
        public final Builder mapArn(String mapArn) {
            this.mapArn = mapArn;
            return this;
        }

        public final String getMapName() {
            return this.mapName;
        }

        public final void setMapName(String mapName) {
            this.mapName = mapName;
        }

        @Override
        public final Builder mapName(String mapName) {
            this.mapName = mapName;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Override
        public UpdateMapResponse build() {
            return new UpdateMapResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LocationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMapResponse> {
        public Builder mapArn(String var1);

        public Builder mapName(String var1);

        public Builder updateTime(Instant var1);
    }
}

