/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.location.LocationClient;
import software.amazon.awssdk.services.location.model.ListDevicePositionsRequest;
import software.amazon.awssdk.services.location.model.ListDevicePositionsResponse;
import software.amazon.awssdk.services.location.model.ListDevicePositionsResponseEntry;

public class ListDevicePositionsIterable
implements SdkIterable<ListDevicePositionsResponse> {
    private final LocationClient client;
    private final ListDevicePositionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDevicePositionsIterable(LocationClient client, ListDevicePositionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDevicePositionsResponseFetcher();
    }

    public Iterator<ListDevicePositionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListDevicePositionsResponseEntry> entries() {
        Function<ListDevicePositionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.entries() != null) {
                return response.entries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDevicePositionsResponseFetcher
    implements SyncPageFetcher<ListDevicePositionsResponse> {
        private ListDevicePositionsResponseFetcher() {
        }

        public boolean hasNextPage(ListDevicePositionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDevicePositionsResponse nextPage(ListDevicePositionsResponse previousPage) {
            if (previousPage == null) {
                return ListDevicePositionsIterable.this.client.listDevicePositions(ListDevicePositionsIterable.this.firstRequest);
            }
            return ListDevicePositionsIterable.this.client.listDevicePositions((ListDevicePositionsRequest)((Object)ListDevicePositionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

