/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.location.LocationClient;
import software.amazon.awssdk.services.location.model.AccessDeniedException;
import software.amazon.awssdk.services.location.model.AssociateTrackerConsumerRequest;
import software.amazon.awssdk.services.location.model.AssociateTrackerConsumerResponse;
import software.amazon.awssdk.services.location.model.BatchDeleteDevicePositionHistoryRequest;
import software.amazon.awssdk.services.location.model.BatchDeleteDevicePositionHistoryResponse;
import software.amazon.awssdk.services.location.model.BatchDeleteGeofenceRequest;
import software.amazon.awssdk.services.location.model.BatchDeleteGeofenceResponse;
import software.amazon.awssdk.services.location.model.BatchEvaluateGeofencesRequest;
import software.amazon.awssdk.services.location.model.BatchEvaluateGeofencesResponse;
import software.amazon.awssdk.services.location.model.BatchGetDevicePositionRequest;
import software.amazon.awssdk.services.location.model.BatchGetDevicePositionResponse;
import software.amazon.awssdk.services.location.model.BatchPutGeofenceRequest;
import software.amazon.awssdk.services.location.model.BatchPutGeofenceResponse;
import software.amazon.awssdk.services.location.model.BatchUpdateDevicePositionRequest;
import software.amazon.awssdk.services.location.model.BatchUpdateDevicePositionResponse;
import software.amazon.awssdk.services.location.model.CalculateRouteRequest;
import software.amazon.awssdk.services.location.model.CalculateRouteResponse;
import software.amazon.awssdk.services.location.model.ConflictException;
import software.amazon.awssdk.services.location.model.CreateGeofenceCollectionRequest;
import software.amazon.awssdk.services.location.model.CreateGeofenceCollectionResponse;
import software.amazon.awssdk.services.location.model.CreateMapRequest;
import software.amazon.awssdk.services.location.model.CreateMapResponse;
import software.amazon.awssdk.services.location.model.CreatePlaceIndexRequest;
import software.amazon.awssdk.services.location.model.CreatePlaceIndexResponse;
import software.amazon.awssdk.services.location.model.CreateRouteCalculatorRequest;
import software.amazon.awssdk.services.location.model.CreateRouteCalculatorResponse;
import software.amazon.awssdk.services.location.model.CreateTrackerRequest;
import software.amazon.awssdk.services.location.model.CreateTrackerResponse;
import software.amazon.awssdk.services.location.model.DeleteGeofenceCollectionRequest;
import software.amazon.awssdk.services.location.model.DeleteGeofenceCollectionResponse;
import software.amazon.awssdk.services.location.model.DeleteMapRequest;
import software.amazon.awssdk.services.location.model.DeleteMapResponse;
import software.amazon.awssdk.services.location.model.DeletePlaceIndexRequest;
import software.amazon.awssdk.services.location.model.DeletePlaceIndexResponse;
import software.amazon.awssdk.services.location.model.DeleteRouteCalculatorRequest;
import software.amazon.awssdk.services.location.model.DeleteRouteCalculatorResponse;
import software.amazon.awssdk.services.location.model.DeleteTrackerRequest;
import software.amazon.awssdk.services.location.model.DeleteTrackerResponse;
import software.amazon.awssdk.services.location.model.DescribeGeofenceCollectionRequest;
import software.amazon.awssdk.services.location.model.DescribeGeofenceCollectionResponse;
import software.amazon.awssdk.services.location.model.DescribeMapRequest;
import software.amazon.awssdk.services.location.model.DescribeMapResponse;
import software.amazon.awssdk.services.location.model.DescribePlaceIndexRequest;
import software.amazon.awssdk.services.location.model.DescribePlaceIndexResponse;
import software.amazon.awssdk.services.location.model.DescribeRouteCalculatorRequest;
import software.amazon.awssdk.services.location.model.DescribeRouteCalculatorResponse;
import software.amazon.awssdk.services.location.model.DescribeTrackerRequest;
import software.amazon.awssdk.services.location.model.DescribeTrackerResponse;
import software.amazon.awssdk.services.location.model.DisassociateTrackerConsumerRequest;
import software.amazon.awssdk.services.location.model.DisassociateTrackerConsumerResponse;
import software.amazon.awssdk.services.location.model.GetDevicePositionHistoryRequest;
import software.amazon.awssdk.services.location.model.GetDevicePositionHistoryResponse;
import software.amazon.awssdk.services.location.model.GetDevicePositionRequest;
import software.amazon.awssdk.services.location.model.GetDevicePositionResponse;
import software.amazon.awssdk.services.location.model.GetGeofenceRequest;
import software.amazon.awssdk.services.location.model.GetGeofenceResponse;
import software.amazon.awssdk.services.location.model.GetMapGlyphsRequest;
import software.amazon.awssdk.services.location.model.GetMapGlyphsResponse;
import software.amazon.awssdk.services.location.model.GetMapSpritesRequest;
import software.amazon.awssdk.services.location.model.GetMapSpritesResponse;
import software.amazon.awssdk.services.location.model.GetMapStyleDescriptorRequest;
import software.amazon.awssdk.services.location.model.GetMapStyleDescriptorResponse;
import software.amazon.awssdk.services.location.model.GetMapTileRequest;
import software.amazon.awssdk.services.location.model.GetMapTileResponse;
import software.amazon.awssdk.services.location.model.InternalServerException;
import software.amazon.awssdk.services.location.model.ListDevicePositionsRequest;
import software.amazon.awssdk.services.location.model.ListDevicePositionsResponse;
import software.amazon.awssdk.services.location.model.ListGeofenceCollectionsRequest;
import software.amazon.awssdk.services.location.model.ListGeofenceCollectionsResponse;
import software.amazon.awssdk.services.location.model.ListGeofencesRequest;
import software.amazon.awssdk.services.location.model.ListGeofencesResponse;
import software.amazon.awssdk.services.location.model.ListMapsRequest;
import software.amazon.awssdk.services.location.model.ListMapsResponse;
import software.amazon.awssdk.services.location.model.ListPlaceIndexesRequest;
import software.amazon.awssdk.services.location.model.ListPlaceIndexesResponse;
import software.amazon.awssdk.services.location.model.ListRouteCalculatorsRequest;
import software.amazon.awssdk.services.location.model.ListRouteCalculatorsResponse;
import software.amazon.awssdk.services.location.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.location.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.location.model.ListTrackerConsumersRequest;
import software.amazon.awssdk.services.location.model.ListTrackerConsumersResponse;
import software.amazon.awssdk.services.location.model.ListTrackersRequest;
import software.amazon.awssdk.services.location.model.ListTrackersResponse;
import software.amazon.awssdk.services.location.model.LocationException;
import software.amazon.awssdk.services.location.model.LocationRequest;
import software.amazon.awssdk.services.location.model.PutGeofenceRequest;
import software.amazon.awssdk.services.location.model.PutGeofenceResponse;
import software.amazon.awssdk.services.location.model.ResourceNotFoundException;
import software.amazon.awssdk.services.location.model.SearchPlaceIndexForPositionRequest;
import software.amazon.awssdk.services.location.model.SearchPlaceIndexForPositionResponse;
import software.amazon.awssdk.services.location.model.SearchPlaceIndexForTextRequest;
import software.amazon.awssdk.services.location.model.SearchPlaceIndexForTextResponse;
import software.amazon.awssdk.services.location.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.location.model.TagResourceRequest;
import software.amazon.awssdk.services.location.model.TagResourceResponse;
import software.amazon.awssdk.services.location.model.ThrottlingException;
import software.amazon.awssdk.services.location.model.UntagResourceRequest;
import software.amazon.awssdk.services.location.model.UntagResourceResponse;
import software.amazon.awssdk.services.location.model.UpdateGeofenceCollectionRequest;
import software.amazon.awssdk.services.location.model.UpdateGeofenceCollectionResponse;
import software.amazon.awssdk.services.location.model.UpdateMapRequest;
import software.amazon.awssdk.services.location.model.UpdateMapResponse;
import software.amazon.awssdk.services.location.model.UpdatePlaceIndexRequest;
import software.amazon.awssdk.services.location.model.UpdatePlaceIndexResponse;
import software.amazon.awssdk.services.location.model.UpdateRouteCalculatorRequest;
import software.amazon.awssdk.services.location.model.UpdateRouteCalculatorResponse;
import software.amazon.awssdk.services.location.model.UpdateTrackerRequest;
import software.amazon.awssdk.services.location.model.UpdateTrackerResponse;
import software.amazon.awssdk.services.location.model.ValidationException;
import software.amazon.awssdk.services.location.paginators.GetDevicePositionHistoryIterable;
import software.amazon.awssdk.services.location.paginators.ListDevicePositionsIterable;
import software.amazon.awssdk.services.location.paginators.ListGeofenceCollectionsIterable;
import software.amazon.awssdk.services.location.paginators.ListGeofencesIterable;
import software.amazon.awssdk.services.location.paginators.ListMapsIterable;
import software.amazon.awssdk.services.location.paginators.ListPlaceIndexesIterable;
import software.amazon.awssdk.services.location.paginators.ListRouteCalculatorsIterable;
import software.amazon.awssdk.services.location.paginators.ListTrackerConsumersIterable;
import software.amazon.awssdk.services.location.paginators.ListTrackersIterable;
import software.amazon.awssdk.services.location.transform.AssociateTrackerConsumerRequestMarshaller;
import software.amazon.awssdk.services.location.transform.BatchDeleteDevicePositionHistoryRequestMarshaller;
import software.amazon.awssdk.services.location.transform.BatchDeleteGeofenceRequestMarshaller;
import software.amazon.awssdk.services.location.transform.BatchEvaluateGeofencesRequestMarshaller;
import software.amazon.awssdk.services.location.transform.BatchGetDevicePositionRequestMarshaller;
import software.amazon.awssdk.services.location.transform.BatchPutGeofenceRequestMarshaller;
import software.amazon.awssdk.services.location.transform.BatchUpdateDevicePositionRequestMarshaller;
import software.amazon.awssdk.services.location.transform.CalculateRouteRequestMarshaller;
import software.amazon.awssdk.services.location.transform.CreateGeofenceCollectionRequestMarshaller;
import software.amazon.awssdk.services.location.transform.CreateMapRequestMarshaller;
import software.amazon.awssdk.services.location.transform.CreatePlaceIndexRequestMarshaller;
import software.amazon.awssdk.services.location.transform.CreateRouteCalculatorRequestMarshaller;
import software.amazon.awssdk.services.location.transform.CreateTrackerRequestMarshaller;
import software.amazon.awssdk.services.location.transform.DeleteGeofenceCollectionRequestMarshaller;
import software.amazon.awssdk.services.location.transform.DeleteMapRequestMarshaller;
import software.amazon.awssdk.services.location.transform.DeletePlaceIndexRequestMarshaller;
import software.amazon.awssdk.services.location.transform.DeleteRouteCalculatorRequestMarshaller;
import software.amazon.awssdk.services.location.transform.DeleteTrackerRequestMarshaller;
import software.amazon.awssdk.services.location.transform.DescribeGeofenceCollectionRequestMarshaller;
import software.amazon.awssdk.services.location.transform.DescribeMapRequestMarshaller;
import software.amazon.awssdk.services.location.transform.DescribePlaceIndexRequestMarshaller;
import software.amazon.awssdk.services.location.transform.DescribeRouteCalculatorRequestMarshaller;
import software.amazon.awssdk.services.location.transform.DescribeTrackerRequestMarshaller;
import software.amazon.awssdk.services.location.transform.DisassociateTrackerConsumerRequestMarshaller;
import software.amazon.awssdk.services.location.transform.GetDevicePositionHistoryRequestMarshaller;
import software.amazon.awssdk.services.location.transform.GetDevicePositionRequestMarshaller;
import software.amazon.awssdk.services.location.transform.GetGeofenceRequestMarshaller;
import software.amazon.awssdk.services.location.transform.GetMapGlyphsRequestMarshaller;
import software.amazon.awssdk.services.location.transform.GetMapSpritesRequestMarshaller;
import software.amazon.awssdk.services.location.transform.GetMapStyleDescriptorRequestMarshaller;
import software.amazon.awssdk.services.location.transform.GetMapTileRequestMarshaller;
import software.amazon.awssdk.services.location.transform.ListDevicePositionsRequestMarshaller;
import software.amazon.awssdk.services.location.transform.ListGeofenceCollectionsRequestMarshaller;
import software.amazon.awssdk.services.location.transform.ListGeofencesRequestMarshaller;
import software.amazon.awssdk.services.location.transform.ListMapsRequestMarshaller;
import software.amazon.awssdk.services.location.transform.ListPlaceIndexesRequestMarshaller;
import software.amazon.awssdk.services.location.transform.ListRouteCalculatorsRequestMarshaller;
import software.amazon.awssdk.services.location.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.location.transform.ListTrackerConsumersRequestMarshaller;
import software.amazon.awssdk.services.location.transform.ListTrackersRequestMarshaller;
import software.amazon.awssdk.services.location.transform.PutGeofenceRequestMarshaller;
import software.amazon.awssdk.services.location.transform.SearchPlaceIndexForPositionRequestMarshaller;
import software.amazon.awssdk.services.location.transform.SearchPlaceIndexForTextRequestMarshaller;
import software.amazon.awssdk.services.location.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.location.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.location.transform.UpdateGeofenceCollectionRequestMarshaller;
import software.amazon.awssdk.services.location.transform.UpdateMapRequestMarshaller;
import software.amazon.awssdk.services.location.transform.UpdatePlaceIndexRequestMarshaller;
import software.amazon.awssdk.services.location.transform.UpdateRouteCalculatorRequestMarshaller;
import software.amazon.awssdk.services.location.transform.UpdateTrackerRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultLocationClient
implements LocationClient {
    private static final Logger log = Logger.loggerFor(DefaultLocationClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultLocationClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "geo";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateTrackerConsumerResponse associateTrackerConsumer(AssociateTrackerConsumerRequest associateTrackerConsumerRequest) throws InternalServerException, ResourceNotFoundException, ConflictException, AccessDeniedException, ValidationException, ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateTrackerConsumerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, associateTrackerConsumerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateTrackerConsumer");
            String hostPrefix = "tracking.";
            String resolvedHostExpression = "tracking.";
            AssociateTrackerConsumerResponse associateTrackerConsumerResponse = (AssociateTrackerConsumerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateTrackerConsumer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)associateTrackerConsumerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateTrackerConsumerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateTrackerConsumerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$associateTrackerConsumer$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchDeleteDevicePositionHistoryResponse batchDeleteDevicePositionHistory(BatchDeleteDevicePositionHistoryRequest batchDeleteDevicePositionHistoryRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDeleteDevicePositionHistoryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, batchDeleteDevicePositionHistoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDeleteDevicePositionHistory");
            String hostPrefix = "tracking.";
            String resolvedHostExpression = "tracking.";
            BatchDeleteDevicePositionHistoryResponse batchDeleteDevicePositionHistoryResponse = (BatchDeleteDevicePositionHistoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDeleteDevicePositionHistory").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)batchDeleteDevicePositionHistoryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchDeleteDevicePositionHistoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchDeleteDevicePositionHistoryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$batchDeleteDevicePositionHistory$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchDeleteGeofenceResponse batchDeleteGeofence(BatchDeleteGeofenceRequest batchDeleteGeofenceRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDeleteGeofenceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, batchDeleteGeofenceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDeleteGeofence");
            String hostPrefix = "geofencing.";
            String resolvedHostExpression = "geofencing.";
            BatchDeleteGeofenceResponse batchDeleteGeofenceResponse = (BatchDeleteGeofenceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDeleteGeofence").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)batchDeleteGeofenceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchDeleteGeofenceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchDeleteGeofenceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$batchDeleteGeofence$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchEvaluateGeofencesResponse batchEvaluateGeofences(BatchEvaluateGeofencesRequest batchEvaluateGeofencesRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchEvaluateGeofencesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, batchEvaluateGeofencesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchEvaluateGeofences");
            String hostPrefix = "geofencing.";
            String resolvedHostExpression = "geofencing.";
            BatchEvaluateGeofencesResponse batchEvaluateGeofencesResponse = (BatchEvaluateGeofencesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchEvaluateGeofences").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)batchEvaluateGeofencesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchEvaluateGeofencesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchEvaluateGeofencesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$batchEvaluateGeofences$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGetDevicePositionResponse batchGetDevicePosition(BatchGetDevicePositionRequest batchGetDevicePositionRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetDevicePositionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, batchGetDevicePositionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetDevicePosition");
            String hostPrefix = "tracking.";
            String resolvedHostExpression = "tracking.";
            BatchGetDevicePositionResponse batchGetDevicePositionResponse = (BatchGetDevicePositionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetDevicePosition").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)batchGetDevicePositionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchGetDevicePositionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchGetDevicePositionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$batchGetDevicePosition$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchPutGeofenceResponse batchPutGeofence(BatchPutGeofenceRequest batchPutGeofenceRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchPutGeofenceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, batchPutGeofenceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchPutGeofence");
            String hostPrefix = "geofencing.";
            String resolvedHostExpression = "geofencing.";
            BatchPutGeofenceResponse batchPutGeofenceResponse = (BatchPutGeofenceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchPutGeofence").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)batchPutGeofenceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchPutGeofenceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchPutGeofenceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$batchPutGeofence$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchUpdateDevicePositionResponse batchUpdateDevicePosition(BatchUpdateDevicePositionRequest batchUpdateDevicePositionRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchUpdateDevicePositionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, batchUpdateDevicePositionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchUpdateDevicePosition");
            String hostPrefix = "tracking.";
            String resolvedHostExpression = "tracking.";
            BatchUpdateDevicePositionResponse batchUpdateDevicePositionResponse = (BatchUpdateDevicePositionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchUpdateDevicePosition").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)batchUpdateDevicePositionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchUpdateDevicePositionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchUpdateDevicePositionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$batchUpdateDevicePosition$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CalculateRouteResponse calculateRoute(CalculateRouteRequest calculateRouteRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CalculateRouteResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, calculateRouteRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CalculateRoute");
            String hostPrefix = "routes.";
            String resolvedHostExpression = "routes.";
            CalculateRouteResponse calculateRouteResponse = (CalculateRouteResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CalculateRoute").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)calculateRouteRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CalculateRouteRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return calculateRouteResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$calculateRoute$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateGeofenceCollectionResponse createGeofenceCollection(CreateGeofenceCollectionRequest createGeofenceCollectionRequest) throws InternalServerException, ConflictException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGeofenceCollectionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, createGeofenceCollectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateGeofenceCollection");
            String hostPrefix = "geofencing.";
            String resolvedHostExpression = "geofencing.";
            CreateGeofenceCollectionResponse createGeofenceCollectionResponse = (CreateGeofenceCollectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateGeofenceCollection").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)createGeofenceCollectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateGeofenceCollectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createGeofenceCollectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$createGeofenceCollection$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateMapResponse createMap(CreateMapRequest createMapRequest) throws InternalServerException, ConflictException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateMapResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, createMapRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateMap");
            String hostPrefix = "maps.";
            String resolvedHostExpression = "maps.";
            CreateMapResponse createMapResponse = (CreateMapResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMap").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)createMapRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateMapRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createMapResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$createMap$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePlaceIndexResponse createPlaceIndex(CreatePlaceIndexRequest createPlaceIndexRequest) throws InternalServerException, ConflictException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePlaceIndexResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, createPlaceIndexRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePlaceIndex");
            String hostPrefix = "places.";
            String resolvedHostExpression = "places.";
            CreatePlaceIndexResponse createPlaceIndexResponse = (CreatePlaceIndexResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePlaceIndex").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)createPlaceIndexRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreatePlaceIndexRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createPlaceIndexResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$createPlaceIndex$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateRouteCalculatorResponse createRouteCalculator(CreateRouteCalculatorRequest createRouteCalculatorRequest) throws InternalServerException, ConflictException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRouteCalculatorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, createRouteCalculatorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRouteCalculator");
            String hostPrefix = "routes.";
            String resolvedHostExpression = "routes.";
            CreateRouteCalculatorResponse createRouteCalculatorResponse = (CreateRouteCalculatorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRouteCalculator").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)createRouteCalculatorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateRouteCalculatorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createRouteCalculatorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$createRouteCalculator$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTrackerResponse createTracker(CreateTrackerRequest createTrackerRequest) throws InternalServerException, ConflictException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTrackerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, createTrackerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTracker");
            String hostPrefix = "tracking.";
            String resolvedHostExpression = "tracking.";
            CreateTrackerResponse createTrackerResponse = (CreateTrackerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTracker").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)createTrackerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateTrackerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createTrackerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$createTracker$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteGeofenceCollectionResponse deleteGeofenceCollection(DeleteGeofenceCollectionRequest deleteGeofenceCollectionRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteGeofenceCollectionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, deleteGeofenceCollectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteGeofenceCollection");
            String hostPrefix = "geofencing.";
            String resolvedHostExpression = "geofencing.";
            DeleteGeofenceCollectionResponse deleteGeofenceCollectionResponse = (DeleteGeofenceCollectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteGeofenceCollection").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)deleteGeofenceCollectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteGeofenceCollectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteGeofenceCollectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$deleteGeofenceCollection$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteMapResponse deleteMap(DeleteMapRequest deleteMapRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteMapResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, deleteMapRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteMap");
            String hostPrefix = "maps.";
            String resolvedHostExpression = "maps.";
            DeleteMapResponse deleteMapResponse = (DeleteMapResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteMap").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)deleteMapRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteMapRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteMapResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$deleteMap$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePlaceIndexResponse deletePlaceIndex(DeletePlaceIndexRequest deletePlaceIndexRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePlaceIndexResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, deletePlaceIndexRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePlaceIndex");
            String hostPrefix = "places.";
            String resolvedHostExpression = "places.";
            DeletePlaceIndexResponse deletePlaceIndexResponse = (DeletePlaceIndexResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePlaceIndex").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)deletePlaceIndexRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeletePlaceIndexRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deletePlaceIndexResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$deletePlaceIndex$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteRouteCalculatorResponse deleteRouteCalculator(DeleteRouteCalculatorRequest deleteRouteCalculatorRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRouteCalculatorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, deleteRouteCalculatorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRouteCalculator");
            String hostPrefix = "routes.";
            String resolvedHostExpression = "routes.";
            DeleteRouteCalculatorResponse deleteRouteCalculatorResponse = (DeleteRouteCalculatorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRouteCalculator").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)deleteRouteCalculatorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteRouteCalculatorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteRouteCalculatorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$deleteRouteCalculator$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTrackerResponse deleteTracker(DeleteTrackerRequest deleteTrackerRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTrackerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, deleteTrackerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTracker");
            String hostPrefix = "tracking.";
            String resolvedHostExpression = "tracking.";
            DeleteTrackerResponse deleteTrackerResponse = (DeleteTrackerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTracker").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)deleteTrackerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTrackerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteTrackerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$deleteTracker$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeGeofenceCollectionResponse describeGeofenceCollection(DescribeGeofenceCollectionRequest describeGeofenceCollectionRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeGeofenceCollectionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, describeGeofenceCollectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeGeofenceCollection");
            String hostPrefix = "geofencing.";
            String resolvedHostExpression = "geofencing.";
            DescribeGeofenceCollectionResponse describeGeofenceCollectionResponse = (DescribeGeofenceCollectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeGeofenceCollection").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)describeGeofenceCollectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeGeofenceCollectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeGeofenceCollectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$describeGeofenceCollection$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeMapResponse describeMap(DescribeMapRequest describeMapRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeMapResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, describeMapRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeMap");
            String hostPrefix = "maps.";
            String resolvedHostExpression = "maps.";
            DescribeMapResponse describeMapResponse = (DescribeMapResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMap").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)describeMapRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeMapRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeMapResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$describeMap$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribePlaceIndexResponse describePlaceIndex(DescribePlaceIndexRequest describePlaceIndexRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribePlaceIndexResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, describePlaceIndexRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribePlaceIndex");
            String hostPrefix = "places.";
            String resolvedHostExpression = "places.";
            DescribePlaceIndexResponse describePlaceIndexResponse = (DescribePlaceIndexResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePlaceIndex").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)describePlaceIndexRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribePlaceIndexRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describePlaceIndexResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$describePlaceIndex$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeRouteCalculatorResponse describeRouteCalculator(DescribeRouteCalculatorRequest describeRouteCalculatorRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRouteCalculatorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, describeRouteCalculatorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRouteCalculator");
            String hostPrefix = "routes.";
            String resolvedHostExpression = "routes.";
            DescribeRouteCalculatorResponse describeRouteCalculatorResponse = (DescribeRouteCalculatorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRouteCalculator").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)describeRouteCalculatorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeRouteCalculatorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeRouteCalculatorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$describeRouteCalculator$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTrackerResponse describeTracker(DescribeTrackerRequest describeTrackerRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTrackerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, describeTrackerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTracker");
            String hostPrefix = "tracking.";
            String resolvedHostExpression = "tracking.";
            DescribeTrackerResponse describeTrackerResponse = (DescribeTrackerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTracker").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)describeTrackerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeTrackerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeTrackerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$describeTracker$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateTrackerConsumerResponse disassociateTrackerConsumer(DisassociateTrackerConsumerRequest disassociateTrackerConsumerRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateTrackerConsumerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, disassociateTrackerConsumerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateTrackerConsumer");
            String hostPrefix = "tracking.";
            String resolvedHostExpression = "tracking.";
            DisassociateTrackerConsumerResponse disassociateTrackerConsumerResponse = (DisassociateTrackerConsumerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateTrackerConsumer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)disassociateTrackerConsumerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateTrackerConsumerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateTrackerConsumerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$disassociateTrackerConsumer$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDevicePositionResponse getDevicePosition(GetDevicePositionRequest getDevicePositionRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDevicePositionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, getDevicePositionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDevicePosition");
            String hostPrefix = "tracking.";
            String resolvedHostExpression = "tracking.";
            GetDevicePositionResponse getDevicePositionResponse = (GetDevicePositionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDevicePosition").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getDevicePositionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDevicePositionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDevicePositionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$getDevicePosition$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDevicePositionHistoryResponse getDevicePositionHistory(GetDevicePositionHistoryRequest getDevicePositionHistoryRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDevicePositionHistoryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, getDevicePositionHistoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDevicePositionHistory");
            String hostPrefix = "tracking.";
            String resolvedHostExpression = "tracking.";
            GetDevicePositionHistoryResponse getDevicePositionHistoryResponse = (GetDevicePositionHistoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDevicePositionHistory").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getDevicePositionHistoryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDevicePositionHistoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDevicePositionHistoryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$getDevicePositionHistory$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public GetDevicePositionHistoryIterable getDevicePositionHistoryPaginator(GetDevicePositionHistoryRequest getDevicePositionHistoryRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        return new GetDevicePositionHistoryIterable(this, this.applyPaginatorUserAgent(getDevicePositionHistoryRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetGeofenceResponse getGeofence(GetGeofenceRequest getGeofenceRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetGeofenceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, getGeofenceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetGeofence");
            String hostPrefix = "geofencing.";
            String resolvedHostExpression = "geofencing.";
            GetGeofenceResponse getGeofenceResponse = (GetGeofenceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetGeofence").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getGeofenceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetGeofenceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getGeofenceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$getGeofence$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetMapGlyphsResponse getMapGlyphs(GetMapGlyphsRequest getMapGlyphsRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(false).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMapGlyphsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, getMapGlyphsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMapGlyphs");
            String hostPrefix = "maps.";
            String resolvedHostExpression = "maps.";
            GetMapGlyphsResponse getMapGlyphsResponse = (GetMapGlyphsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMapGlyphs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getMapGlyphsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetMapGlyphsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getMapGlyphsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$getMapGlyphs$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetMapSpritesResponse getMapSprites(GetMapSpritesRequest getMapSpritesRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(false).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMapSpritesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, getMapSpritesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMapSprites");
            String hostPrefix = "maps.";
            String resolvedHostExpression = "maps.";
            GetMapSpritesResponse getMapSpritesResponse = (GetMapSpritesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMapSprites").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getMapSpritesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetMapSpritesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getMapSpritesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$getMapSprites$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetMapStyleDescriptorResponse getMapStyleDescriptor(GetMapStyleDescriptorRequest getMapStyleDescriptorRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(false).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMapStyleDescriptorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, getMapStyleDescriptorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMapStyleDescriptor");
            String hostPrefix = "maps.";
            String resolvedHostExpression = "maps.";
            GetMapStyleDescriptorResponse getMapStyleDescriptorResponse = (GetMapStyleDescriptorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMapStyleDescriptor").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getMapStyleDescriptorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetMapStyleDescriptorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getMapStyleDescriptorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$getMapStyleDescriptor$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetMapTileResponse getMapTile(GetMapTileRequest getMapTileRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(false).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMapTileResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, getMapTileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMapTile");
            String hostPrefix = "maps.";
            String resolvedHostExpression = "maps.";
            GetMapTileResponse getMapTileResponse = (GetMapTileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMapTile").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getMapTileRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetMapTileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getMapTileResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$getMapTile$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDevicePositionsResponse listDevicePositions(ListDevicePositionsRequest listDevicePositionsRequest) throws InternalServerException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDevicePositionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, listDevicePositionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDevicePositions");
            String hostPrefix = "tracking.";
            String resolvedHostExpression = "tracking.";
            ListDevicePositionsResponse listDevicePositionsResponse = (ListDevicePositionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDevicePositions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listDevicePositionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDevicePositionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDevicePositionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$listDevicePositions$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListDevicePositionsIterable listDevicePositionsPaginator(ListDevicePositionsRequest listDevicePositionsRequest) throws InternalServerException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        return new ListDevicePositionsIterable(this, this.applyPaginatorUserAgent(listDevicePositionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListGeofenceCollectionsResponse listGeofenceCollections(ListGeofenceCollectionsRequest listGeofenceCollectionsRequest) throws InternalServerException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListGeofenceCollectionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, listGeofenceCollectionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListGeofenceCollections");
            String hostPrefix = "geofencing.";
            String resolvedHostExpression = "geofencing.";
            ListGeofenceCollectionsResponse listGeofenceCollectionsResponse = (ListGeofenceCollectionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListGeofenceCollections").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listGeofenceCollectionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListGeofenceCollectionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listGeofenceCollectionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$listGeofenceCollections$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListGeofenceCollectionsIterable listGeofenceCollectionsPaginator(ListGeofenceCollectionsRequest listGeofenceCollectionsRequest) throws InternalServerException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        return new ListGeofenceCollectionsIterable(this, this.applyPaginatorUserAgent(listGeofenceCollectionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListGeofencesResponse listGeofences(ListGeofencesRequest listGeofencesRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListGeofencesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, listGeofencesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListGeofences");
            String hostPrefix = "geofencing.";
            String resolvedHostExpression = "geofencing.";
            ListGeofencesResponse listGeofencesResponse = (ListGeofencesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListGeofences").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listGeofencesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListGeofencesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listGeofencesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$listGeofences$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListGeofencesIterable listGeofencesPaginator(ListGeofencesRequest listGeofencesRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        return new ListGeofencesIterable(this, this.applyPaginatorUserAgent(listGeofencesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListMapsResponse listMaps(ListMapsRequest listMapsRequest) throws InternalServerException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMapsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, listMapsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMaps");
            String hostPrefix = "maps.";
            String resolvedHostExpression = "maps.";
            ListMapsResponse listMapsResponse = (ListMapsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMaps").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listMapsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListMapsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listMapsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$listMaps$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListMapsIterable listMapsPaginator(ListMapsRequest listMapsRequest) throws InternalServerException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        return new ListMapsIterable(this, this.applyPaginatorUserAgent(listMapsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPlaceIndexesResponse listPlaceIndexes(ListPlaceIndexesRequest listPlaceIndexesRequest) throws InternalServerException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPlaceIndexesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, listPlaceIndexesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPlaceIndexes");
            String hostPrefix = "places.";
            String resolvedHostExpression = "places.";
            ListPlaceIndexesResponse listPlaceIndexesResponse = (ListPlaceIndexesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPlaceIndexes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listPlaceIndexesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPlaceIndexesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPlaceIndexesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$listPlaceIndexes$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListPlaceIndexesIterable listPlaceIndexesPaginator(ListPlaceIndexesRequest listPlaceIndexesRequest) throws InternalServerException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        return new ListPlaceIndexesIterable(this, this.applyPaginatorUserAgent(listPlaceIndexesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRouteCalculatorsResponse listRouteCalculators(ListRouteCalculatorsRequest listRouteCalculatorsRequest) throws InternalServerException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRouteCalculatorsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, listRouteCalculatorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRouteCalculators");
            String hostPrefix = "routes.";
            String resolvedHostExpression = "routes.";
            ListRouteCalculatorsResponse listRouteCalculatorsResponse = (ListRouteCalculatorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRouteCalculators").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listRouteCalculatorsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRouteCalculatorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRouteCalculatorsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$listRouteCalculators$36((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListRouteCalculatorsIterable listRouteCalculatorsPaginator(ListRouteCalculatorsRequest listRouteCalculatorsRequest) throws InternalServerException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        return new ListRouteCalculatorsIterable(this, this.applyPaginatorUserAgent(listRouteCalculatorsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            String hostPrefix = "metadata.";
            String resolvedHostExpression = "metadata.";
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$listTagsForResource$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTrackerConsumersResponse listTrackerConsumers(ListTrackerConsumersRequest listTrackerConsumersRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTrackerConsumersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, listTrackerConsumersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTrackerConsumers");
            String hostPrefix = "tracking.";
            String resolvedHostExpression = "tracking.";
            ListTrackerConsumersResponse listTrackerConsumersResponse = (ListTrackerConsumersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTrackerConsumers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listTrackerConsumersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTrackerConsumersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTrackerConsumersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$listTrackerConsumers$38((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListTrackerConsumersIterable listTrackerConsumersPaginator(ListTrackerConsumersRequest listTrackerConsumersRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        return new ListTrackerConsumersIterable(this, this.applyPaginatorUserAgent(listTrackerConsumersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTrackersResponse listTrackers(ListTrackersRequest listTrackersRequest) throws InternalServerException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTrackersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, listTrackersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTrackers");
            String hostPrefix = "tracking.";
            String resolvedHostExpression = "tracking.";
            ListTrackersResponse listTrackersResponse = (ListTrackersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTrackers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listTrackersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTrackersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTrackersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$listTrackers$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListTrackersIterable listTrackersPaginator(ListTrackersRequest listTrackersRequest) throws InternalServerException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        return new ListTrackersIterable(this, this.applyPaginatorUserAgent(listTrackersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutGeofenceResponse putGeofence(PutGeofenceRequest putGeofenceRequest) throws InternalServerException, ResourceNotFoundException, ConflictException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutGeofenceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, putGeofenceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutGeofence");
            String hostPrefix = "geofencing.";
            String resolvedHostExpression = "geofencing.";
            PutGeofenceResponse putGeofenceResponse = (PutGeofenceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutGeofence").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)putGeofenceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutGeofenceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putGeofenceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$putGeofence$40((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchPlaceIndexForPositionResponse searchPlaceIndexForPosition(SearchPlaceIndexForPositionRequest searchPlaceIndexForPositionRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchPlaceIndexForPositionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, searchPlaceIndexForPositionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SearchPlaceIndexForPosition");
            String hostPrefix = "places.";
            String resolvedHostExpression = "places.";
            SearchPlaceIndexForPositionResponse searchPlaceIndexForPositionResponse = (SearchPlaceIndexForPositionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchPlaceIndexForPosition").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)searchPlaceIndexForPositionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SearchPlaceIndexForPositionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return searchPlaceIndexForPositionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$searchPlaceIndexForPosition$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchPlaceIndexForTextResponse searchPlaceIndexForText(SearchPlaceIndexForTextRequest searchPlaceIndexForTextRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchPlaceIndexForTextResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, searchPlaceIndexForTextRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SearchPlaceIndexForText");
            String hostPrefix = "places.";
            String resolvedHostExpression = "places.";
            SearchPlaceIndexForTextResponse searchPlaceIndexForTextResponse = (SearchPlaceIndexForTextResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchPlaceIndexForText").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)searchPlaceIndexForTextRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SearchPlaceIndexForTextRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return searchPlaceIndexForTextResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$searchPlaceIndexForText$42((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            String hostPrefix = "metadata.";
            String resolvedHostExpression = "metadata.";
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$tagResource$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            String hostPrefix = "metadata.";
            String resolvedHostExpression = "metadata.";
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$untagResource$44((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateGeofenceCollectionResponse updateGeofenceCollection(UpdateGeofenceCollectionRequest updateGeofenceCollectionRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateGeofenceCollectionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, updateGeofenceCollectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateGeofenceCollection");
            String hostPrefix = "geofencing.";
            String resolvedHostExpression = "geofencing.";
            UpdateGeofenceCollectionResponse updateGeofenceCollectionResponse = (UpdateGeofenceCollectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateGeofenceCollection").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)updateGeofenceCollectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateGeofenceCollectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateGeofenceCollectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$updateGeofenceCollection$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateMapResponse updateMap(UpdateMapRequest updateMapRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateMapResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, updateMapRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateMap");
            String hostPrefix = "maps.";
            String resolvedHostExpression = "maps.";
            UpdateMapResponse updateMapResponse = (UpdateMapResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateMap").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)updateMapRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateMapRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateMapResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$updateMap$46((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdatePlaceIndexResponse updatePlaceIndex(UpdatePlaceIndexRequest updatePlaceIndexRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePlaceIndexResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, updatePlaceIndexRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdatePlaceIndex");
            String hostPrefix = "places.";
            String resolvedHostExpression = "places.";
            UpdatePlaceIndexResponse updatePlaceIndexResponse = (UpdatePlaceIndexResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePlaceIndex").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)updatePlaceIndexRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdatePlaceIndexRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updatePlaceIndexResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$updatePlaceIndex$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateRouteCalculatorResponse updateRouteCalculator(UpdateRouteCalculatorRequest updateRouteCalculatorRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRouteCalculatorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, updateRouteCalculatorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRouteCalculator");
            String hostPrefix = "routes.";
            String resolvedHostExpression = "routes.";
            UpdateRouteCalculatorResponse updateRouteCalculatorResponse = (UpdateRouteCalculatorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRouteCalculator").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)updateRouteCalculatorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateRouteCalculatorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateRouteCalculatorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$updateRouteCalculator$48((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateTrackerResponse updateTracker(UpdateTrackerRequest updateTrackerRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, LocationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTrackerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLocationClient.resolveMetricPublishers(this.clientConfiguration, updateTrackerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Location");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTracker");
            String hostPrefix = "tracking.";
            String resolvedHostExpression = "tracking.";
            UpdateTrackerResponse updateTrackerResponse = (UpdateTrackerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTracker").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)updateTrackerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateTrackerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateTrackerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLocationClient.lambda$updateTracker$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(LocationException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends LocationRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.17.91").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((LocationRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$updateTracker$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateRouteCalculator$48(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updatePlaceIndex$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateMap$46(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateGeofenceCollection$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$searchPlaceIndexForText$42(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$searchPlaceIndexForPosition$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putGeofence$40(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTrackers$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTrackerConsumers$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRouteCalculators$36(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPlaceIndexes$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listMaps$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listGeofences$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listGeofenceCollections$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDevicePositions$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMapTile$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMapStyleDescriptor$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMapSprites$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMapGlyphs$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getGeofence$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDevicePositionHistory$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDevicePosition$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateTrackerConsumer$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTracker$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeRouteCalculator$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describePlaceIndex$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeMap$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeGeofenceCollection$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTracker$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRouteCalculator$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePlaceIndex$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteMap$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteGeofenceCollection$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTracker$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRouteCalculator$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPlaceIndex$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createMap$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createGeofenceCollection$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$calculateRoute$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchUpdateDevicePosition$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchPutGeofence$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchGetDevicePosition$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchEvaluateGeofences$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDeleteGeofence$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDeleteDevicePositionHistory$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateTrackerConsumer$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

