/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.location.model.ArnListCopier;
import software.amazon.awssdk.services.location.model.LocationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTrackerConsumersResponse
extends LocationResponse
implements ToCopyableBuilder<Builder, ListTrackerConsumersResponse> {
    private static final SdkField<List<String>> CONSUMER_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConsumerArns").getter(ListTrackerConsumersResponse.getter(ListTrackerConsumersResponse::consumerArns)).setter(ListTrackerConsumersResponse.setter(Builder::consumerArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumerArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTrackerConsumersResponse.getter(ListTrackerConsumersResponse::nextToken)).setter(ListTrackerConsumersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSUMER_ARNS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> consumerArns;
    private final String nextToken;

    private ListTrackerConsumersResponse(BuilderImpl builder) {
        super(builder);
        this.consumerArns = builder.consumerArns;
        this.nextToken = builder.nextToken;
    }

    public boolean hasConsumerArns() {
        return this.consumerArns != null && !(this.consumerArns instanceof SdkAutoConstructList);
    }

    public List<String> consumerArns() {
        return this.consumerArns;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConsumerArns() ? this.consumerArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrackerConsumersResponse)) {
            return false;
        }
        ListTrackerConsumersResponse other = (ListTrackerConsumersResponse)((Object)obj);
        return this.hasConsumerArns() == other.hasConsumerArns() && Objects.equals(this.consumerArns(), other.consumerArns()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListTrackerConsumersResponse").add("ConsumerArns", this.hasConsumerArns() ? this.consumerArns() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConsumerArns": {
                return Optional.ofNullable(clazz.cast(this.consumerArns()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTrackerConsumersResponse, T> g) {
        return obj -> g.apply((ListTrackerConsumersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationResponse.BuilderImpl
    implements Builder {
        private List<String> consumerArns = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrackerConsumersResponse model) {
            super(model);
            this.consumerArns(model.consumerArns);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getConsumerArns() {
            if (this.consumerArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.consumerArns;
        }

        @Override
        public final Builder consumerArns(Collection<String> consumerArns) {
            this.consumerArns = ArnListCopier.copy(consumerArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumerArns(String ... consumerArns) {
            this.consumerArns(Arrays.asList(consumerArns));
            return this;
        }

        public final void setConsumerArns(Collection<String> consumerArns) {
            this.consumerArns = ArnListCopier.copy(consumerArns);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTrackerConsumersResponse build() {
            return new ListTrackerConsumersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LocationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTrackerConsumersResponse> {
        public Builder consumerArns(Collection<String> var1);

        public Builder consumerArns(String ... var1);

        public Builder nextToken(String var1);
    }
}

