/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.location.model.LocationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDevicePositionHistoryRequest
extends LocationRequest
implements ToCopyableBuilder<Builder, GetDevicePositionHistoryRequest> {
    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceId").getter(GetDevicePositionHistoryRequest.getter(GetDevicePositionHistoryRequest::deviceId)).setter(GetDevicePositionHistoryRequest.setter(Builder::deviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DeviceId").build()}).build();
    private static final SdkField<Instant> END_TIME_EXCLUSIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTimeExclusive").getter(GetDevicePositionHistoryRequest.getter(GetDevicePositionHistoryRequest::endTimeExclusive)).setter(GetDevicePositionHistoryRequest.setter(Builder::endTimeExclusive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTimeExclusive").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetDevicePositionHistoryRequest.getter(GetDevicePositionHistoryRequest::nextToken)).setter(GetDevicePositionHistoryRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Instant> START_TIME_INCLUSIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTimeInclusive").getter(GetDevicePositionHistoryRequest.getter(GetDevicePositionHistoryRequest::startTimeInclusive)).setter(GetDevicePositionHistoryRequest.setter(Builder::startTimeInclusive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimeInclusive").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> TRACKER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrackerName").getter(GetDevicePositionHistoryRequest.getter(GetDevicePositionHistoryRequest::trackerName)).setter(GetDevicePositionHistoryRequest.setter(Builder::trackerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("TrackerName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_ID_FIELD, END_TIME_EXCLUSIVE_FIELD, NEXT_TOKEN_FIELD, START_TIME_INCLUSIVE_FIELD, TRACKER_NAME_FIELD));
    private final String deviceId;
    private final Instant endTimeExclusive;
    private final String nextToken;
    private final Instant startTimeInclusive;
    private final String trackerName;

    private GetDevicePositionHistoryRequest(BuilderImpl builder) {
        super(builder);
        this.deviceId = builder.deviceId;
        this.endTimeExclusive = builder.endTimeExclusive;
        this.nextToken = builder.nextToken;
        this.startTimeInclusive = builder.startTimeInclusive;
        this.trackerName = builder.trackerName;
    }

    public String deviceId() {
        return this.deviceId;
    }

    public Instant endTimeExclusive() {
        return this.endTimeExclusive;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Instant startTimeInclusive() {
        return this.startTimeInclusive;
    }

    public String trackerName() {
        return this.trackerName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTimeExclusive());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimeInclusive());
        hashCode = 31 * hashCode + Objects.hashCode(this.trackerName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDevicePositionHistoryRequest)) {
            return false;
        }
        GetDevicePositionHistoryRequest other = (GetDevicePositionHistoryRequest)((Object)obj);
        return Objects.equals(this.deviceId(), other.deviceId()) && Objects.equals(this.endTimeExclusive(), other.endTimeExclusive()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.startTimeInclusive(), other.startTimeInclusive()) && Objects.equals(this.trackerName(), other.trackerName());
    }

    public String toString() {
        return ToString.builder((String)"GetDevicePositionHistoryRequest").add("DeviceId", (Object)this.deviceId()).add("EndTimeExclusive", (Object)this.endTimeExclusive()).add("NextToken", (Object)this.nextToken()).add("StartTimeInclusive", (Object)this.startTimeInclusive()).add("TrackerName", (Object)this.trackerName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceId": {
                return Optional.ofNullable(clazz.cast(this.deviceId()));
            }
            case "EndTimeExclusive": {
                return Optional.ofNullable(clazz.cast(this.endTimeExclusive()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "StartTimeInclusive": {
                return Optional.ofNullable(clazz.cast(this.startTimeInclusive()));
            }
            case "TrackerName": {
                return Optional.ofNullable(clazz.cast(this.trackerName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDevicePositionHistoryRequest, T> g) {
        return obj -> g.apply((GetDevicePositionHistoryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationRequest.BuilderImpl
    implements Builder {
        private String deviceId;
        private Instant endTimeExclusive;
        private String nextToken;
        private Instant startTimeInclusive;
        private String trackerName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDevicePositionHistoryRequest model) {
            super(model);
            this.deviceId(model.deviceId);
            this.endTimeExclusive(model.endTimeExclusive);
            this.nextToken(model.nextToken);
            this.startTimeInclusive(model.startTimeInclusive);
            this.trackerName(model.trackerName);
        }

        public final String getDeviceId() {
            return this.deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        public final Instant getEndTimeExclusive() {
            return this.endTimeExclusive;
        }

        @Override
        public final Builder endTimeExclusive(Instant endTimeExclusive) {
            this.endTimeExclusive = endTimeExclusive;
            return this;
        }

        public final void setEndTimeExclusive(Instant endTimeExclusive) {
            this.endTimeExclusive = endTimeExclusive;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Instant getStartTimeInclusive() {
            return this.startTimeInclusive;
        }

        @Override
        public final Builder startTimeInclusive(Instant startTimeInclusive) {
            this.startTimeInclusive = startTimeInclusive;
            return this;
        }

        public final void setStartTimeInclusive(Instant startTimeInclusive) {
            this.startTimeInclusive = startTimeInclusive;
        }

        public final String getTrackerName() {
            return this.trackerName;
        }

        @Override
        public final Builder trackerName(String trackerName) {
            this.trackerName = trackerName;
            return this;
        }

        public final void setTrackerName(String trackerName) {
            this.trackerName = trackerName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDevicePositionHistoryRequest build() {
            return new GetDevicePositionHistoryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LocationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDevicePositionHistoryRequest> {
        public Builder deviceId(String var1);

        public Builder endTimeExclusive(Instant var1);

        public Builder nextToken(String var1);

        public Builder startTimeInclusive(Instant var1);

        public Builder trackerName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

