/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.location.model.LocationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeGeofenceCollectionResponse
extends LocationResponse
implements ToCopyableBuilder<Builder, DescribeGeofenceCollectionResponse> {
    private static final SdkField<String> COLLECTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CollectionArn").getter(DescribeGeofenceCollectionResponse.getter(DescribeGeofenceCollectionResponse::collectionArn)).setter(DescribeGeofenceCollectionResponse.setter(Builder::collectionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionArn").build()}).build();
    private static final SdkField<String> COLLECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CollectionName").getter(DescribeGeofenceCollectionResponse.getter(DescribeGeofenceCollectionResponse::collectionName)).setter(DescribeGeofenceCollectionResponse.setter(Builder::collectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionName").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(DescribeGeofenceCollectionResponse.getter(DescribeGeofenceCollectionResponse::createTime)).setter(DescribeGeofenceCollectionResponse.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribeGeofenceCollectionResponse.getter(DescribeGeofenceCollectionResponse::description)).setter(DescribeGeofenceCollectionResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdateTime").getter(DescribeGeofenceCollectionResponse.getter(DescribeGeofenceCollectionResponse::updateTime)).setter(DescribeGeofenceCollectionResponse.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_ARN_FIELD, COLLECTION_NAME_FIELD, CREATE_TIME_FIELD, DESCRIPTION_FIELD, UPDATE_TIME_FIELD));
    private final String collectionArn;
    private final String collectionName;
    private final Instant createTime;
    private final String description;
    private final Instant updateTime;

    private DescribeGeofenceCollectionResponse(BuilderImpl builder) {
        super(builder);
        this.collectionArn = builder.collectionArn;
        this.collectionName = builder.collectionName;
        this.createTime = builder.createTime;
        this.description = builder.description;
        this.updateTime = builder.updateTime;
    }

    public String collectionArn() {
        return this.collectionArn;
    }

    public String collectionName() {
        return this.collectionName;
    }

    public Instant createTime() {
        return this.createTime;
    }

    public String description() {
        return this.description;
    }

    public Instant updateTime() {
        return this.updateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGeofenceCollectionResponse)) {
            return false;
        }
        DescribeGeofenceCollectionResponse other = (DescribeGeofenceCollectionResponse)((Object)obj);
        return Objects.equals(this.collectionArn(), other.collectionArn()) && Objects.equals(this.collectionName(), other.collectionName()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.updateTime(), other.updateTime());
    }

    public String toString() {
        return ToString.builder((String)"DescribeGeofenceCollectionResponse").add("CollectionArn", (Object)this.collectionArn()).add("CollectionName", (Object)this.collectionName()).add("CreateTime", (Object)this.createTime()).add("Description", (Object)this.description()).add("UpdateTime", (Object)this.updateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CollectionArn": {
                return Optional.ofNullable(clazz.cast(this.collectionArn()));
            }
            case "CollectionName": {
                return Optional.ofNullable(clazz.cast(this.collectionName()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "UpdateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeGeofenceCollectionResponse, T> g) {
        return obj -> g.apply((DescribeGeofenceCollectionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationResponse.BuilderImpl
    implements Builder {
        private String collectionArn;
        private String collectionName;
        private Instant createTime;
        private String description;
        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGeofenceCollectionResponse model) {
            super(model);
            this.collectionArn(model.collectionArn);
            this.collectionName(model.collectionName);
            this.createTime(model.createTime);
            this.description(model.description);
            this.updateTime(model.updateTime);
        }

        public final String getCollectionArn() {
            return this.collectionArn;
        }

        @Override
        public final Builder collectionArn(String collectionArn) {
            this.collectionArn = collectionArn;
            return this;
        }

        public final void setCollectionArn(String collectionArn) {
            this.collectionArn = collectionArn;
        }

        public final String getCollectionName() {
            return this.collectionName;
        }

        @Override
        public final Builder collectionName(String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        public final void setCollectionName(String collectionName) {
            this.collectionName = collectionName;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public DescribeGeofenceCollectionResponse build() {
            return new DescribeGeofenceCollectionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LocationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeGeofenceCollectionResponse> {
        public Builder collectionArn(String var1);

        public Builder collectionName(String var1);

        public Builder createTime(Instant var1);

        public Builder description(String var1);

        public Builder updateTime(Instant var1);
    }
}

