/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.location.model.BatchDeleteGeofenceError;
import software.amazon.awssdk.services.location.model.BatchDeleteGeofenceErrorListCopier;
import software.amazon.awssdk.services.location.model.LocationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteGeofenceResponse
extends LocationResponse
implements ToCopyableBuilder<Builder, BatchDeleteGeofenceResponse> {
    private static final SdkField<List<BatchDeleteGeofenceError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Errors").getter(BatchDeleteGeofenceResponse.getter(BatchDeleteGeofenceResponse::errors)).setter(BatchDeleteGeofenceResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchDeleteGeofenceError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERRORS_FIELD));
    private final List<BatchDeleteGeofenceError> errors;

    private BatchDeleteGeofenceResponse(BuilderImpl builder) {
        super(builder);
        this.errors = builder.errors;
    }

    public boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public List<BatchDeleteGeofenceError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteGeofenceResponse)) {
            return false;
        }
        BatchDeleteGeofenceResponse other = (BatchDeleteGeofenceResponse)((Object)obj);
        return this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public String toString() {
        return ToString.builder((String)"BatchDeleteGeofenceResponse").add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteGeofenceResponse, T> g) {
        return obj -> g.apply((BatchDeleteGeofenceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationResponse.BuilderImpl
    implements Builder {
        private List<BatchDeleteGeofenceError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteGeofenceResponse model) {
            super(model);
            this.errors(model.errors);
        }

        public final Collection<BatchDeleteGeofenceError.Builder> getErrors() {
            if (this.errors instanceof SdkAutoConstructList) {
                return null;
            }
            return this.errors != null ? (Collection)this.errors.stream().map(BatchDeleteGeofenceError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errors(Collection<BatchDeleteGeofenceError> errors) {
            this.errors = BatchDeleteGeofenceErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchDeleteGeofenceError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchDeleteGeofenceError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (BatchDeleteGeofenceError)((BatchDeleteGeofenceError.Builder)BatchDeleteGeofenceError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setErrors(Collection<BatchDeleteGeofenceError.BuilderImpl> errors) {
            this.errors = BatchDeleteGeofenceErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public BatchDeleteGeofenceResponse build() {
            return new BatchDeleteGeofenceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LocationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDeleteGeofenceResponse> {
        public Builder errors(Collection<BatchDeleteGeofenceError> var1);

        public Builder errors(BatchDeleteGeofenceError ... var1);

        public Builder errors(Consumer<BatchDeleteGeofenceError.Builder> ... var1);
    }
}

