/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteRelationalDatabaseRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, DeleteRelationalDatabaseRequest> {
    private static final SdkField<String> RELATIONAL_DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("relationalDatabaseName").getter(DeleteRelationalDatabaseRequest.getter(DeleteRelationalDatabaseRequest::relationalDatabaseName)).setter(DeleteRelationalDatabaseRequest.setter(Builder::relationalDatabaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabaseName").build()}).build();
    private static final SdkField<Boolean> SKIP_FINAL_SNAPSHOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("skipFinalSnapshot").getter(DeleteRelationalDatabaseRequest.getter(DeleteRelationalDatabaseRequest::skipFinalSnapshot)).setter(DeleteRelationalDatabaseRequest.setter(Builder::skipFinalSnapshot)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("skipFinalSnapshot").build()}).build();
    private static final SdkField<String> FINAL_RELATIONAL_DATABASE_SNAPSHOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("finalRelationalDatabaseSnapshotName").getter(DeleteRelationalDatabaseRequest.getter(DeleteRelationalDatabaseRequest::finalRelationalDatabaseSnapshotName)).setter(DeleteRelationalDatabaseRequest.setter(Builder::finalRelationalDatabaseSnapshotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("finalRelationalDatabaseSnapshotName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELATIONAL_DATABASE_NAME_FIELD, SKIP_FINAL_SNAPSHOT_FIELD, FINAL_RELATIONAL_DATABASE_SNAPSHOT_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteRelationalDatabaseRequest.memberNameToFieldInitializer();
    private final String relationalDatabaseName;
    private final Boolean skipFinalSnapshot;
    private final String finalRelationalDatabaseSnapshotName;

    private DeleteRelationalDatabaseRequest(BuilderImpl builder) {
        super(builder);
        this.relationalDatabaseName = builder.relationalDatabaseName;
        this.skipFinalSnapshot = builder.skipFinalSnapshot;
        this.finalRelationalDatabaseSnapshotName = builder.finalRelationalDatabaseSnapshotName;
    }

    public final String relationalDatabaseName() {
        return this.relationalDatabaseName;
    }

    public final Boolean skipFinalSnapshot() {
        return this.skipFinalSnapshot;
    }

    public final String finalRelationalDatabaseSnapshotName() {
        return this.finalRelationalDatabaseSnapshotName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.relationalDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.skipFinalSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(this.finalRelationalDatabaseSnapshotName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRelationalDatabaseRequest)) {
            return false;
        }
        DeleteRelationalDatabaseRequest other = (DeleteRelationalDatabaseRequest)((Object)obj);
        return Objects.equals(this.relationalDatabaseName(), other.relationalDatabaseName()) && Objects.equals(this.skipFinalSnapshot(), other.skipFinalSnapshot()) && Objects.equals(this.finalRelationalDatabaseSnapshotName(), other.finalRelationalDatabaseSnapshotName());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteRelationalDatabaseRequest").add("RelationalDatabaseName", (Object)this.relationalDatabaseName()).add("SkipFinalSnapshot", (Object)this.skipFinalSnapshot()).add("FinalRelationalDatabaseSnapshotName", (Object)this.finalRelationalDatabaseSnapshotName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "relationalDatabaseName": {
                return Optional.ofNullable(clazz.cast(this.relationalDatabaseName()));
            }
            case "skipFinalSnapshot": {
                return Optional.ofNullable(clazz.cast(this.skipFinalSnapshot()));
            }
            case "finalRelationalDatabaseSnapshotName": {
                return Optional.ofNullable(clazz.cast(this.finalRelationalDatabaseSnapshotName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("relationalDatabaseName", RELATIONAL_DATABASE_NAME_FIELD);
        map.put("skipFinalSnapshot", SKIP_FINAL_SNAPSHOT_FIELD);
        map.put("finalRelationalDatabaseSnapshotName", FINAL_RELATIONAL_DATABASE_SNAPSHOT_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteRelationalDatabaseRequest, T> g) {
        return obj -> g.apply((DeleteRelationalDatabaseRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String relationalDatabaseName;
        private Boolean skipFinalSnapshot;
        private String finalRelationalDatabaseSnapshotName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRelationalDatabaseRequest model) {
            super(model);
            this.relationalDatabaseName(model.relationalDatabaseName);
            this.skipFinalSnapshot(model.skipFinalSnapshot);
            this.finalRelationalDatabaseSnapshotName(model.finalRelationalDatabaseSnapshotName);
        }

        public final String getRelationalDatabaseName() {
            return this.relationalDatabaseName;
        }

        public final void setRelationalDatabaseName(String relationalDatabaseName) {
            this.relationalDatabaseName = relationalDatabaseName;
        }

        @Override
        public final Builder relationalDatabaseName(String relationalDatabaseName) {
            this.relationalDatabaseName = relationalDatabaseName;
            return this;
        }

        public final Boolean getSkipFinalSnapshot() {
            return this.skipFinalSnapshot;
        }

        public final void setSkipFinalSnapshot(Boolean skipFinalSnapshot) {
            this.skipFinalSnapshot = skipFinalSnapshot;
        }

        @Override
        public final Builder skipFinalSnapshot(Boolean skipFinalSnapshot) {
            this.skipFinalSnapshot = skipFinalSnapshot;
            return this;
        }

        public final String getFinalRelationalDatabaseSnapshotName() {
            return this.finalRelationalDatabaseSnapshotName;
        }

        public final void setFinalRelationalDatabaseSnapshotName(String finalRelationalDatabaseSnapshotName) {
            this.finalRelationalDatabaseSnapshotName = finalRelationalDatabaseSnapshotName;
        }

        @Override
        public final Builder finalRelationalDatabaseSnapshotName(String finalRelationalDatabaseSnapshotName) {
            this.finalRelationalDatabaseSnapshotName = finalRelationalDatabaseSnapshotName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteRelationalDatabaseRequest build() {
            return new DeleteRelationalDatabaseRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteRelationalDatabaseRequest> {
        public Builder relationalDatabaseName(String var1);

        public Builder skipFinalSnapshot(Boolean var1);

        public Builder finalRelationalDatabaseSnapshotName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

