/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetContainerLogRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, GetContainerLogRequest> {
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceName").getter(GetContainerLogRequest.getter(GetContainerLogRequest::serviceName)).setter(GetContainerLogRequest.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()}).build();
    private static final SdkField<String> CONTAINER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("containerName").getter(GetContainerLogRequest.getter(GetContainerLogRequest::containerName)).setter(GetContainerLogRequest.setter(Builder::containerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerName").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(GetContainerLogRequest.getter(GetContainerLogRequest::startTime)).setter(GetContainerLogRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(GetContainerLogRequest.getter(GetContainerLogRequest::endTime)).setter(GetContainerLogRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<String> FILTER_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filterPattern").getter(GetContainerLogRequest.getter(GetContainerLogRequest::filterPattern)).setter(GetContainerLogRequest.setter(Builder::filterPattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterPattern").build()}).build();
    private static final SdkField<String> PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pageToken").getter(GetContainerLogRequest.getter(GetContainerLogRequest::pageToken)).setter(GetContainerLogRequest.setter(Builder::pageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAME_FIELD, CONTAINER_NAME_FIELD, START_TIME_FIELD, END_TIME_FIELD, FILTER_PATTERN_FIELD, PAGE_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetContainerLogRequest.memberNameToFieldInitializer();
    private final String serviceName;
    private final String containerName;
    private final Instant startTime;
    private final Instant endTime;
    private final String filterPattern;
    private final String pageToken;

    private GetContainerLogRequest(BuilderImpl builder) {
        super(builder);
        this.serviceName = builder.serviceName;
        this.containerName = builder.containerName;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.filterPattern = builder.filterPattern;
        this.pageToken = builder.pageToken;
    }

    public final String serviceName() {
        return this.serviceName;
    }

    public final String containerName() {
        return this.containerName;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String filterPattern() {
        return this.filterPattern;
    }

    public final String pageToken() {
        return this.pageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContainerLogRequest)) {
            return false;
        }
        GetContainerLogRequest other = (GetContainerLogRequest)((Object)obj);
        return Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.containerName(), other.containerName()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.filterPattern(), other.filterPattern()) && Objects.equals(this.pageToken(), other.pageToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetContainerLogRequest").add("ServiceName", (Object)this.serviceName()).add("ContainerName", (Object)this.containerName()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("FilterPattern", (Object)this.filterPattern()).add("PageToken", (Object)this.pageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "containerName": {
                return Optional.ofNullable(clazz.cast(this.containerName()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "filterPattern": {
                return Optional.ofNullable(clazz.cast(this.filterPattern()));
            }
            case "pageToken": {
                return Optional.ofNullable(clazz.cast(this.pageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("serviceName", SERVICE_NAME_FIELD);
        map.put("containerName", CONTAINER_NAME_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("filterPattern", FILTER_PATTERN_FIELD);
        map.put("pageToken", PAGE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetContainerLogRequest, T> g) {
        return obj -> g.apply((GetContainerLogRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String serviceName;
        private String containerName;
        private Instant startTime;
        private Instant endTime;
        private String filterPattern;
        private String pageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetContainerLogRequest model) {
            super(model);
            this.serviceName(model.serviceName);
            this.containerName(model.containerName);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.filterPattern(model.filterPattern);
            this.pageToken(model.pageToken);
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getContainerName() {
            return this.containerName;
        }

        public final void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        @Override
        public final Builder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getFilterPattern() {
            return this.filterPattern;
        }

        public final void setFilterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
        }

        @Override
        public final Builder filterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        public final String getPageToken() {
            return this.pageToken;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetContainerLogRequest build() {
            return new GetContainerLogRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetContainerLogRequest> {
        public Builder serviceName(String var1);

        public Builder containerName(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder filterPattern(String var1);

        public Builder pageToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

