/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.AppCategory;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBlueprintsRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, GetBlueprintsRequest> {
    private static final SdkField<Boolean> INCLUDE_INACTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("includeInactive").getter(GetBlueprintsRequest.getter(GetBlueprintsRequest::includeInactive)).setter(GetBlueprintsRequest.setter(Builder::includeInactive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeInactive").build()}).build();
    private static final SdkField<String> PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pageToken").getter(GetBlueprintsRequest.getter(GetBlueprintsRequest::pageToken)).setter(GetBlueprintsRequest.setter(Builder::pageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pageToken").build()}).build();
    private static final SdkField<String> APP_CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appCategory").getter(GetBlueprintsRequest.getter(GetBlueprintsRequest::appCategoryAsString)).setter(GetBlueprintsRequest.setter(Builder::appCategory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appCategory").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCLUDE_INACTIVE_FIELD, PAGE_TOKEN_FIELD, APP_CATEGORY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetBlueprintsRequest.memberNameToFieldInitializer();
    private final Boolean includeInactive;
    private final String pageToken;
    private final String appCategory;

    private GetBlueprintsRequest(BuilderImpl builder) {
        super(builder);
        this.includeInactive = builder.includeInactive;
        this.pageToken = builder.pageToken;
        this.appCategory = builder.appCategory;
    }

    public final Boolean includeInactive() {
        return this.includeInactive;
    }

    public final String pageToken() {
        return this.pageToken;
    }

    public final AppCategory appCategory() {
        return AppCategory.fromValue(this.appCategory);
    }

    public final String appCategoryAsString() {
        return this.appCategory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.includeInactive());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.appCategoryAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBlueprintsRequest)) {
            return false;
        }
        GetBlueprintsRequest other = (GetBlueprintsRequest)((Object)obj);
        return Objects.equals(this.includeInactive(), other.includeInactive()) && Objects.equals(this.pageToken(), other.pageToken()) && Objects.equals(this.appCategoryAsString(), other.appCategoryAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetBlueprintsRequest").add("IncludeInactive", (Object)this.includeInactive()).add("PageToken", (Object)this.pageToken()).add("AppCategory", (Object)this.appCategoryAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "includeInactive": {
                return Optional.ofNullable(clazz.cast(this.includeInactive()));
            }
            case "pageToken": {
                return Optional.ofNullable(clazz.cast(this.pageToken()));
            }
            case "appCategory": {
                return Optional.ofNullable(clazz.cast(this.appCategoryAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("includeInactive", INCLUDE_INACTIVE_FIELD);
        map.put("pageToken", PAGE_TOKEN_FIELD);
        map.put("appCategory", APP_CATEGORY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetBlueprintsRequest, T> g) {
        return obj -> g.apply((GetBlueprintsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private Boolean includeInactive;
        private String pageToken;
        private String appCategory;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBlueprintsRequest model) {
            super(model);
            this.includeInactive(model.includeInactive);
            this.pageToken(model.pageToken);
            this.appCategory(model.appCategory);
        }

        public final Boolean getIncludeInactive() {
            return this.includeInactive;
        }

        public final void setIncludeInactive(Boolean includeInactive) {
            this.includeInactive = includeInactive;
        }

        @Override
        public final Builder includeInactive(Boolean includeInactive) {
            this.includeInactive = includeInactive;
            return this;
        }

        public final String getPageToken() {
            return this.pageToken;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final String getAppCategory() {
            return this.appCategory;
        }

        public final void setAppCategory(String appCategory) {
            this.appCategory = appCategory;
        }

        @Override
        public final Builder appCategory(String appCategory) {
            this.appCategory = appCategory;
            return this;
        }

        @Override
        public final Builder appCategory(AppCategory appCategory) {
            this.appCategory(appCategory == null ? null : appCategory.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetBlueprintsRequest build() {
            return new GetBlueprintsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBlueprintsRequest> {
        public Builder includeInactive(Boolean var1);

        public Builder pageToken(String var1);

        public Builder appCategory(String var1);

        public Builder appCategory(AppCategory var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

