/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.ContainerServicePower;
import software.amazon.awssdk.services.lightsail.model.ContainerServicePowerListCopier;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetContainerServicePowersResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetContainerServicePowersResponse> {
    private static final SdkField<List<ContainerServicePower>> POWERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("powers").getter(GetContainerServicePowersResponse.getter(GetContainerServicePowersResponse::powers)).setter(GetContainerServicePowersResponse.setter(Builder::powers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("powers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContainerServicePower::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POWERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetContainerServicePowersResponse.memberNameToFieldInitializer();
    private final List<ContainerServicePower> powers;

    private GetContainerServicePowersResponse(BuilderImpl builder) {
        super(builder);
        this.powers = builder.powers;
    }

    public final boolean hasPowers() {
        return this.powers != null && !(this.powers instanceof SdkAutoConstructList);
    }

    public final List<ContainerServicePower> powers() {
        return this.powers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPowers() ? this.powers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContainerServicePowersResponse)) {
            return false;
        }
        GetContainerServicePowersResponse other = (GetContainerServicePowersResponse)((Object)obj);
        return this.hasPowers() == other.hasPowers() && Objects.equals(this.powers(), other.powers());
    }

    public final String toString() {
        return ToString.builder((String)"GetContainerServicePowersResponse").add("Powers", this.hasPowers() ? this.powers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "powers": {
                return Optional.ofNullable(clazz.cast(this.powers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<ContainerServicePower>>> map = new HashMap<String, SdkField<List<ContainerServicePower>>>();
        map.put("powers", POWERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetContainerServicePowersResponse, T> g) {
        return obj -> g.apply((GetContainerServicePowersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private List<ContainerServicePower> powers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetContainerServicePowersResponse model) {
            super(model);
            this.powers(model.powers);
        }

        public final List<ContainerServicePower.Builder> getPowers() {
            List<ContainerServicePower.Builder> result = ContainerServicePowerListCopier.copyToBuilder(this.powers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPowers(Collection<ContainerServicePower.BuilderImpl> powers) {
            this.powers = ContainerServicePowerListCopier.copyFromBuilder(powers);
        }

        @Override
        public final Builder powers(Collection<ContainerServicePower> powers) {
            this.powers = ContainerServicePowerListCopier.copy(powers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder powers(ContainerServicePower ... powers) {
            this.powers(Arrays.asList(powers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder powers(Consumer<ContainerServicePower.Builder> ... powers) {
            this.powers(Stream.of(powers).map(c -> (ContainerServicePower)((ContainerServicePower.Builder)ContainerServicePower.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetContainerServicePowersResponse build() {
            return new GetContainerServicePowersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetContainerServicePowersResponse> {
        public Builder powers(Collection<ContainerServicePower> var1);

        public Builder powers(ContainerServicePower ... var1);

        public Builder powers(Consumer<ContainerServicePower.Builder> ... var1);
    }
}

