/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.DiskSnapshotInfo;
import software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecordSourceType;
import software.amazon.awssdk.services.lightsail.model.InstanceSnapshotInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportSnapshotRecordSourceInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExportSnapshotRecordSourceInfo> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(ExportSnapshotRecordSourceInfo.getter(ExportSnapshotRecordSourceInfo::resourceTypeAsString)).setter(ExportSnapshotRecordSourceInfo.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(ExportSnapshotRecordSourceInfo.getter(ExportSnapshotRecordSourceInfo::createdAt)).setter(ExportSnapshotRecordSourceInfo.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ExportSnapshotRecordSourceInfo.getter(ExportSnapshotRecordSourceInfo::name)).setter(ExportSnapshotRecordSourceInfo.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ExportSnapshotRecordSourceInfo.getter(ExportSnapshotRecordSourceInfo::arn)).setter(ExportSnapshotRecordSourceInfo.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> FROM_RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fromResourceName").getter(ExportSnapshotRecordSourceInfo.getter(ExportSnapshotRecordSourceInfo::fromResourceName)).setter(ExportSnapshotRecordSourceInfo.setter(Builder::fromResourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromResourceName").build()}).build();
    private static final SdkField<String> FROM_RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fromResourceArn").getter(ExportSnapshotRecordSourceInfo.getter(ExportSnapshotRecordSourceInfo::fromResourceArn)).setter(ExportSnapshotRecordSourceInfo.setter(Builder::fromResourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromResourceArn").build()}).build();
    private static final SdkField<InstanceSnapshotInfo> INSTANCE_SNAPSHOT_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("instanceSnapshotInfo").getter(ExportSnapshotRecordSourceInfo.getter(ExportSnapshotRecordSourceInfo::instanceSnapshotInfo)).setter(ExportSnapshotRecordSourceInfo.setter(Builder::instanceSnapshotInfo)).constructor(InstanceSnapshotInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceSnapshotInfo").build()}).build();
    private static final SdkField<DiskSnapshotInfo> DISK_SNAPSHOT_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("diskSnapshotInfo").getter(ExportSnapshotRecordSourceInfo.getter(ExportSnapshotRecordSourceInfo::diskSnapshotInfo)).setter(ExportSnapshotRecordSourceInfo.setter(Builder::diskSnapshotInfo)).constructor(DiskSnapshotInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diskSnapshotInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD, CREATED_AT_FIELD, NAME_FIELD, ARN_FIELD, FROM_RESOURCE_NAME_FIELD, FROM_RESOURCE_ARN_FIELD, INSTANCE_SNAPSHOT_INFO_FIELD, DISK_SNAPSHOT_INFO_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExportSnapshotRecordSourceInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String resourceType;
    private final Instant createdAt;
    private final String name;
    private final String arn;
    private final String fromResourceName;
    private final String fromResourceArn;
    private final InstanceSnapshotInfo instanceSnapshotInfo;
    private final DiskSnapshotInfo diskSnapshotInfo;

    private ExportSnapshotRecordSourceInfo(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.createdAt = builder.createdAt;
        this.name = builder.name;
        this.arn = builder.arn;
        this.fromResourceName = builder.fromResourceName;
        this.fromResourceArn = builder.fromResourceArn;
        this.instanceSnapshotInfo = builder.instanceSnapshotInfo;
        this.diskSnapshotInfo = builder.diskSnapshotInfo;
    }

    public final ExportSnapshotRecordSourceType resourceType() {
        return ExportSnapshotRecordSourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final String fromResourceName() {
        return this.fromResourceName;
    }

    public final String fromResourceArn() {
        return this.fromResourceArn;
    }

    public final InstanceSnapshotInfo instanceSnapshotInfo() {
        return this.instanceSnapshotInfo;
    }

    public final DiskSnapshotInfo diskSnapshotInfo() {
        return this.diskSnapshotInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromResourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceSnapshotInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.diskSnapshotInfo());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportSnapshotRecordSourceInfo)) {
            return false;
        }
        ExportSnapshotRecordSourceInfo other = (ExportSnapshotRecordSourceInfo)obj;
        return Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.fromResourceName(), other.fromResourceName()) && Objects.equals(this.fromResourceArn(), other.fromResourceArn()) && Objects.equals(this.instanceSnapshotInfo(), other.instanceSnapshotInfo()) && Objects.equals(this.diskSnapshotInfo(), other.diskSnapshotInfo());
    }

    public final String toString() {
        return ToString.builder((String)"ExportSnapshotRecordSourceInfo").add("ResourceType", (Object)this.resourceTypeAsString()).add("CreatedAt", (Object)this.createdAt()).add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("FromResourceName", (Object)this.fromResourceName()).add("FromResourceArn", (Object)this.fromResourceArn()).add("InstanceSnapshotInfo", (Object)this.instanceSnapshotInfo()).add("DiskSnapshotInfo", (Object)this.diskSnapshotInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "fromResourceName": {
                return Optional.ofNullable(clazz.cast(this.fromResourceName()));
            }
            case "fromResourceArn": {
                return Optional.ofNullable(clazz.cast(this.fromResourceArn()));
            }
            case "instanceSnapshotInfo": {
                return Optional.ofNullable(clazz.cast(this.instanceSnapshotInfo()));
            }
            case "diskSnapshotInfo": {
                return Optional.ofNullable(clazz.cast(this.diskSnapshotInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("name", NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("fromResourceName", FROM_RESOURCE_NAME_FIELD);
        map.put("fromResourceArn", FROM_RESOURCE_ARN_FIELD);
        map.put("instanceSnapshotInfo", INSTANCE_SNAPSHOT_INFO_FIELD);
        map.put("diskSnapshotInfo", DISK_SNAPSHOT_INFO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportSnapshotRecordSourceInfo, T> g) {
        return obj -> g.apply((ExportSnapshotRecordSourceInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceType;
        private Instant createdAt;
        private String name;
        private String arn;
        private String fromResourceName;
        private String fromResourceArn;
        private InstanceSnapshotInfo instanceSnapshotInfo;
        private DiskSnapshotInfo diskSnapshotInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportSnapshotRecordSourceInfo model) {
            this.resourceType(model.resourceType);
            this.createdAt(model.createdAt);
            this.name(model.name);
            this.arn(model.arn);
            this.fromResourceName(model.fromResourceName);
            this.fromResourceArn(model.fromResourceArn);
            this.instanceSnapshotInfo(model.instanceSnapshotInfo);
            this.diskSnapshotInfo(model.diskSnapshotInfo);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ExportSnapshotRecordSourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getFromResourceName() {
            return this.fromResourceName;
        }

        public final void setFromResourceName(String fromResourceName) {
            this.fromResourceName = fromResourceName;
        }

        @Override
        public final Builder fromResourceName(String fromResourceName) {
            this.fromResourceName = fromResourceName;
            return this;
        }

        public final String getFromResourceArn() {
            return this.fromResourceArn;
        }

        public final void setFromResourceArn(String fromResourceArn) {
            this.fromResourceArn = fromResourceArn;
        }

        @Override
        public final Builder fromResourceArn(String fromResourceArn) {
            this.fromResourceArn = fromResourceArn;
            return this;
        }

        public final InstanceSnapshotInfo.Builder getInstanceSnapshotInfo() {
            return this.instanceSnapshotInfo != null ? this.instanceSnapshotInfo.toBuilder() : null;
        }

        public final void setInstanceSnapshotInfo(InstanceSnapshotInfo.BuilderImpl instanceSnapshotInfo) {
            this.instanceSnapshotInfo = instanceSnapshotInfo != null ? instanceSnapshotInfo.build() : null;
        }

        @Override
        public final Builder instanceSnapshotInfo(InstanceSnapshotInfo instanceSnapshotInfo) {
            this.instanceSnapshotInfo = instanceSnapshotInfo;
            return this;
        }

        public final DiskSnapshotInfo.Builder getDiskSnapshotInfo() {
            return this.diskSnapshotInfo != null ? this.diskSnapshotInfo.toBuilder() : null;
        }

        public final void setDiskSnapshotInfo(DiskSnapshotInfo.BuilderImpl diskSnapshotInfo) {
            this.diskSnapshotInfo = diskSnapshotInfo != null ? diskSnapshotInfo.build() : null;
        }

        @Override
        public final Builder diskSnapshotInfo(DiskSnapshotInfo diskSnapshotInfo) {
            this.diskSnapshotInfo = diskSnapshotInfo;
            return this;
        }

        public ExportSnapshotRecordSourceInfo build() {
            return new ExportSnapshotRecordSourceInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExportSnapshotRecordSourceInfo> {
        public Builder resourceType(String var1);

        public Builder resourceType(ExportSnapshotRecordSourceType var1);

        public Builder createdAt(Instant var1);

        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder fromResourceName(String var1);

        public Builder fromResourceArn(String var1);

        public Builder instanceSnapshotInfo(InstanceSnapshotInfo var1);

        default public Builder instanceSnapshotInfo(Consumer<InstanceSnapshotInfo.Builder> instanceSnapshotInfo) {
            return this.instanceSnapshotInfo((InstanceSnapshotInfo)((InstanceSnapshotInfo.Builder)InstanceSnapshotInfo.builder().applyMutation(instanceSnapshotInfo)).build());
        }

        public Builder diskSnapshotInfo(DiskSnapshotInfo var1);

        default public Builder diskSnapshotInfo(Consumer<DiskSnapshotInfo.Builder> diskSnapshotInfo) {
            return this.diskSnapshotInfo((DiskSnapshotInfo)((DiskSnapshotInfo.Builder)DiskSnapshotInfo.builder().applyMutation(diskSnapshotInfo)).build());
        }
    }
}

