/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.services.lightsail.model.RelationalDatabaseBundle;
import software.amazon.awssdk.services.lightsail.model.RelationalDatabaseBundleListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRelationalDatabaseBundlesResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetRelationalDatabaseBundlesResponse> {
    private static final SdkField<List<RelationalDatabaseBundle>> BUNDLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("bundles").getter(GetRelationalDatabaseBundlesResponse.getter(GetRelationalDatabaseBundlesResponse::bundles)).setter(GetRelationalDatabaseBundlesResponse.setter(Builder::bundles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bundles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RelationalDatabaseBundle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextPageToken").getter(GetRelationalDatabaseBundlesResponse.getter(GetRelationalDatabaseBundlesResponse::nextPageToken)).setter(GetRelationalDatabaseBundlesResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUNDLES_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("bundles", BUNDLES_FIELD);
            this.put("nextPageToken", NEXT_PAGE_TOKEN_FIELD);
        }
    });
    private final List<RelationalDatabaseBundle> bundles;
    private final String nextPageToken;

    private GetRelationalDatabaseBundlesResponse(BuilderImpl builder) {
        super(builder);
        this.bundles = builder.bundles;
        this.nextPageToken = builder.nextPageToken;
    }

    public final boolean hasBundles() {
        return this.bundles != null && !(this.bundles instanceof SdkAutoConstructList);
    }

    public final List<RelationalDatabaseBundle> bundles() {
        return this.bundles;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBundles() ? this.bundles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRelationalDatabaseBundlesResponse)) {
            return false;
        }
        GetRelationalDatabaseBundlesResponse other = (GetRelationalDatabaseBundlesResponse)((Object)obj);
        return this.hasBundles() == other.hasBundles() && Objects.equals(this.bundles(), other.bundles()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetRelationalDatabaseBundlesResponse").add("Bundles", this.hasBundles() ? this.bundles() : null).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bundles": {
                return Optional.ofNullable(clazz.cast(this.bundles()));
            }
            case "nextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetRelationalDatabaseBundlesResponse, T> g) {
        return obj -> g.apply((GetRelationalDatabaseBundlesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private List<RelationalDatabaseBundle> bundles = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRelationalDatabaseBundlesResponse model) {
            super(model);
            this.bundles(model.bundles);
            this.nextPageToken(model.nextPageToken);
        }

        public final List<RelationalDatabaseBundle.Builder> getBundles() {
            List<RelationalDatabaseBundle.Builder> result = RelationalDatabaseBundleListCopier.copyToBuilder(this.bundles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBundles(Collection<RelationalDatabaseBundle.BuilderImpl> bundles) {
            this.bundles = RelationalDatabaseBundleListCopier.copyFromBuilder(bundles);
        }

        @Override
        public final Builder bundles(Collection<RelationalDatabaseBundle> bundles) {
            this.bundles = RelationalDatabaseBundleListCopier.copy(bundles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bundles(RelationalDatabaseBundle ... bundles) {
            this.bundles(Arrays.asList(bundles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bundles(Consumer<RelationalDatabaseBundle.Builder> ... bundles) {
            this.bundles(Stream.of(bundles).map(c -> (RelationalDatabaseBundle)((RelationalDatabaseBundle.Builder)RelationalDatabaseBundle.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public GetRelationalDatabaseBundlesResponse build() {
            return new GetRelationalDatabaseBundlesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRelationalDatabaseBundlesResponse> {
        public Builder bundles(Collection<RelationalDatabaseBundle> var1);

        public Builder bundles(RelationalDatabaseBundle ... var1);

        public Builder bundles(Consumer<RelationalDatabaseBundle.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

