/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.OriginProtocolPolicyEnum;
import software.amazon.awssdk.services.lightsail.model.RegionName;
import software.amazon.awssdk.services.lightsail.model.ResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Origin
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Origin> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Origin.getter(Origin::name)).setter(Origin.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(Origin.getter(Origin::resourceTypeAsString)).setter(Origin.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<String> REGION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("regionName").getter(Origin.getter(Origin::regionNameAsString)).setter(Origin.setter(Builder::regionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionName").build()}).build();
    private static final SdkField<String> PROTOCOL_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("protocolPolicy").getter(Origin.getter(Origin::protocolPolicyAsString)).setter(Origin.setter(Builder::protocolPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocolPolicy").build()}).build();
    private static final SdkField<Integer> RESPONSE_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("responseTimeout").getter(Origin.getter(Origin::responseTimeout)).setter(Origin.setter(Builder::responseTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseTimeout").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, RESOURCE_TYPE_FIELD, REGION_NAME_FIELD, PROTOCOL_POLICY_FIELD, RESPONSE_TIMEOUT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String resourceType;
    private final String regionName;
    private final String protocolPolicy;
    private final Integer responseTimeout;

    private Origin(BuilderImpl builder) {
        this.name = builder.name;
        this.resourceType = builder.resourceType;
        this.regionName = builder.regionName;
        this.protocolPolicy = builder.protocolPolicy;
        this.responseTimeout = builder.responseTimeout;
    }

    public final String name() {
        return this.name;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final RegionName regionName() {
        return RegionName.fromValue(this.regionName);
    }

    public final String regionNameAsString() {
        return this.regionName;
    }

    public final OriginProtocolPolicyEnum protocolPolicy() {
        return OriginProtocolPolicyEnum.fromValue(this.protocolPolicy);
    }

    public final String protocolPolicyAsString() {
        return this.protocolPolicy;
    }

    public final Integer responseTimeout() {
        return this.responseTimeout;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseTimeout());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Origin)) {
            return false;
        }
        Origin other = (Origin)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.regionNameAsString(), other.regionNameAsString()) && Objects.equals(this.protocolPolicyAsString(), other.protocolPolicyAsString()) && Objects.equals(this.responseTimeout(), other.responseTimeout());
    }

    public final String toString() {
        return ToString.builder((String)"Origin").add("Name", (Object)this.name()).add("ResourceType", (Object)this.resourceTypeAsString()).add("RegionName", (Object)this.regionNameAsString()).add("ProtocolPolicy", (Object)this.protocolPolicyAsString()).add("ResponseTimeout", (Object)this.responseTimeout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "regionName": {
                return Optional.ofNullable(clazz.cast(this.regionNameAsString()));
            }
            case "protocolPolicy": {
                return Optional.ofNullable(clazz.cast(this.protocolPolicyAsString()));
            }
            case "responseTimeout": {
                return Optional.ofNullable(clazz.cast(this.responseTimeout()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Origin, T> g) {
        return obj -> g.apply((Origin)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String resourceType;
        private String regionName;
        private String protocolPolicy;
        private Integer responseTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(Origin model) {
            this.name(model.name);
            this.resourceType(model.resourceType);
            this.regionName(model.regionName);
            this.protocolPolicy(model.protocolPolicy);
            this.responseTimeout(model.responseTimeout);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getRegionName() {
            return this.regionName;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        @Override
        public final Builder regionName(RegionName regionName) {
            this.regionName(regionName == null ? null : regionName.toString());
            return this;
        }

        public final String getProtocolPolicy() {
            return this.protocolPolicy;
        }

        public final void setProtocolPolicy(String protocolPolicy) {
            this.protocolPolicy = protocolPolicy;
        }

        @Override
        public final Builder protocolPolicy(String protocolPolicy) {
            this.protocolPolicy = protocolPolicy;
            return this;
        }

        @Override
        public final Builder protocolPolicy(OriginProtocolPolicyEnum protocolPolicy) {
            this.protocolPolicy(protocolPolicy == null ? null : protocolPolicy.toString());
            return this;
        }

        public final Integer getResponseTimeout() {
            return this.responseTimeout;
        }

        public final void setResponseTimeout(Integer responseTimeout) {
            this.responseTimeout = responseTimeout;
        }

        @Override
        public final Builder responseTimeout(Integer responseTimeout) {
            this.responseTimeout = responseTimeout;
            return this;
        }

        public Origin build() {
            return new Origin(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Origin> {
        public Builder name(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder regionName(String var1);

        public Builder regionName(RegionName var1);

        public Builder protocolPolicy(String var1);

        public Builder protocolPolicy(OriginProtocolPolicyEnum var1);

        public Builder responseTimeout(Integer var1);
    }
}

