/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InstanceMetricName {
    CPU_UTILIZATION("CPUUtilization"),
    NETWORK_IN("NetworkIn"),
    NETWORK_OUT("NetworkOut"),
    STATUS_CHECK_FAILED("StatusCheckFailed"),
    STATUS_CHECK_FAILED_INSTANCE("StatusCheckFailed_Instance"),
    STATUS_CHECK_FAILED_SYSTEM("StatusCheckFailed_System"),
    BURST_CAPACITY_TIME("BurstCapacityTime"),
    BURST_CAPACITY_PERCENTAGE("BurstCapacityPercentage"),
    METADATA_NO_TOKEN("MetadataNoToken"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InstanceMetricName> VALUE_MAP;
    private final String value;

    private InstanceMetricName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InstanceMetricName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InstanceMetricName> knownValues() {
        EnumSet<InstanceMetricName> knownValues = EnumSet.allOf(InstanceMetricName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InstanceMetricName.class, InstanceMetricName::toString);
    }
}

