/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.HttpEndpoint;
import software.amazon.awssdk.services.lightsail.model.HttpProtocolIpv6;
import software.amazon.awssdk.services.lightsail.model.HttpTokens;
import software.amazon.awssdk.services.lightsail.model.InstanceMetadataState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceMetadataOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceMetadataOptions> {
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(InstanceMetadataOptions.getter(InstanceMetadataOptions::stateAsString)).setter(InstanceMetadataOptions.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> HTTP_TOKENS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("httpTokens").getter(InstanceMetadataOptions.getter(InstanceMetadataOptions::httpTokensAsString)).setter(InstanceMetadataOptions.setter(Builder::httpTokens)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpTokens").build()}).build();
    private static final SdkField<String> HTTP_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("httpEndpoint").getter(InstanceMetadataOptions.getter(InstanceMetadataOptions::httpEndpointAsString)).setter(InstanceMetadataOptions.setter(Builder::httpEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpEndpoint").build()}).build();
    private static final SdkField<Integer> HTTP_PUT_RESPONSE_HOP_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("httpPutResponseHopLimit").getter(InstanceMetadataOptions.getter(InstanceMetadataOptions::httpPutResponseHopLimit)).setter(InstanceMetadataOptions.setter(Builder::httpPutResponseHopLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpPutResponseHopLimit").build()}).build();
    private static final SdkField<String> HTTP_PROTOCOL_IPV6_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("httpProtocolIpv6").getter(InstanceMetadataOptions.getter(InstanceMetadataOptions::httpProtocolIpv6AsString)).setter(InstanceMetadataOptions.setter(Builder::httpProtocolIpv6)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpProtocolIpv6").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD, HTTP_TOKENS_FIELD, HTTP_ENDPOINT_FIELD, HTTP_PUT_RESPONSE_HOP_LIMIT_FIELD, HTTP_PROTOCOL_IPV6_FIELD));
    private static final long serialVersionUID = 1L;
    private final String state;
    private final String httpTokens;
    private final String httpEndpoint;
    private final Integer httpPutResponseHopLimit;
    private final String httpProtocolIpv6;

    private InstanceMetadataOptions(BuilderImpl builder) {
        this.state = builder.state;
        this.httpTokens = builder.httpTokens;
        this.httpEndpoint = builder.httpEndpoint;
        this.httpPutResponseHopLimit = builder.httpPutResponseHopLimit;
        this.httpProtocolIpv6 = builder.httpProtocolIpv6;
    }

    public final InstanceMetadataState state() {
        return InstanceMetadataState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final HttpTokens httpTokens() {
        return HttpTokens.fromValue(this.httpTokens);
    }

    public final String httpTokensAsString() {
        return this.httpTokens;
    }

    public final HttpEndpoint httpEndpoint() {
        return HttpEndpoint.fromValue(this.httpEndpoint);
    }

    public final String httpEndpointAsString() {
        return this.httpEndpoint;
    }

    public final Integer httpPutResponseHopLimit() {
        return this.httpPutResponseHopLimit;
    }

    public final HttpProtocolIpv6 httpProtocolIpv6() {
        return HttpProtocolIpv6.fromValue(this.httpProtocolIpv6);
    }

    public final String httpProtocolIpv6AsString() {
        return this.httpProtocolIpv6;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpTokensAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpEndpointAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpPutResponseHopLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpProtocolIpv6AsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceMetadataOptions)) {
            return false;
        }
        InstanceMetadataOptions other = (InstanceMetadataOptions)obj;
        return Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.httpTokensAsString(), other.httpTokensAsString()) && Objects.equals(this.httpEndpointAsString(), other.httpEndpointAsString()) && Objects.equals(this.httpPutResponseHopLimit(), other.httpPutResponseHopLimit()) && Objects.equals(this.httpProtocolIpv6AsString(), other.httpProtocolIpv6AsString());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceMetadataOptions").add("State", (Object)this.stateAsString()).add("HttpTokens", (Object)this.httpTokensAsString()).add("HttpEndpoint", (Object)this.httpEndpointAsString()).add("HttpPutResponseHopLimit", (Object)this.httpPutResponseHopLimit()).add("HttpProtocolIpv6", (Object)this.httpProtocolIpv6AsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "httpTokens": {
                return Optional.ofNullable(clazz.cast(this.httpTokensAsString()));
            }
            case "httpEndpoint": {
                return Optional.ofNullable(clazz.cast(this.httpEndpointAsString()));
            }
            case "httpPutResponseHopLimit": {
                return Optional.ofNullable(clazz.cast(this.httpPutResponseHopLimit()));
            }
            case "httpProtocolIpv6": {
                return Optional.ofNullable(clazz.cast(this.httpProtocolIpv6AsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceMetadataOptions, T> g) {
        return obj -> g.apply((InstanceMetadataOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String state;
        private String httpTokens;
        private String httpEndpoint;
        private Integer httpPutResponseHopLimit;
        private String httpProtocolIpv6;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceMetadataOptions model) {
            this.state(model.state);
            this.httpTokens(model.httpTokens);
            this.httpEndpoint(model.httpEndpoint);
            this.httpPutResponseHopLimit(model.httpPutResponseHopLimit);
            this.httpProtocolIpv6(model.httpProtocolIpv6);
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(InstanceMetadataState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getHttpTokens() {
            return this.httpTokens;
        }

        public final void setHttpTokens(String httpTokens) {
            this.httpTokens = httpTokens;
        }

        @Override
        public final Builder httpTokens(String httpTokens) {
            this.httpTokens = httpTokens;
            return this;
        }

        @Override
        public final Builder httpTokens(HttpTokens httpTokens) {
            this.httpTokens(httpTokens == null ? null : httpTokens.toString());
            return this;
        }

        public final String getHttpEndpoint() {
            return this.httpEndpoint;
        }

        public final void setHttpEndpoint(String httpEndpoint) {
            this.httpEndpoint = httpEndpoint;
        }

        @Override
        public final Builder httpEndpoint(String httpEndpoint) {
            this.httpEndpoint = httpEndpoint;
            return this;
        }

        @Override
        public final Builder httpEndpoint(HttpEndpoint httpEndpoint) {
            this.httpEndpoint(httpEndpoint == null ? null : httpEndpoint.toString());
            return this;
        }

        public final Integer getHttpPutResponseHopLimit() {
            return this.httpPutResponseHopLimit;
        }

        public final void setHttpPutResponseHopLimit(Integer httpPutResponseHopLimit) {
            this.httpPutResponseHopLimit = httpPutResponseHopLimit;
        }

        @Override
        public final Builder httpPutResponseHopLimit(Integer httpPutResponseHopLimit) {
            this.httpPutResponseHopLimit = httpPutResponseHopLimit;
            return this;
        }

        public final String getHttpProtocolIpv6() {
            return this.httpProtocolIpv6;
        }

        public final void setHttpProtocolIpv6(String httpProtocolIpv6) {
            this.httpProtocolIpv6 = httpProtocolIpv6;
        }

        @Override
        public final Builder httpProtocolIpv6(String httpProtocolIpv6) {
            this.httpProtocolIpv6 = httpProtocolIpv6;
            return this;
        }

        @Override
        public final Builder httpProtocolIpv6(HttpProtocolIpv6 httpProtocolIpv6) {
            this.httpProtocolIpv6(httpProtocolIpv6 == null ? null : httpProtocolIpv6.toString());
            return this;
        }

        public InstanceMetadataOptions build() {
            return new InstanceMetadataOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceMetadataOptions> {
        public Builder state(String var1);

        public Builder state(InstanceMetadataState var1);

        public Builder httpTokens(String var1);

        public Builder httpTokens(HttpTokens var1);

        public Builder httpEndpoint(String var1);

        public Builder httpEndpoint(HttpEndpoint var1);

        public Builder httpPutResponseHopLimit(Integer var1);

        public Builder httpProtocolIpv6(String var1);

        public Builder httpProtocolIpv6(HttpProtocolIpv6 var1);
    }
}

